(function ($) {
	"use strict";

	var Tp_Cascading_image = function ($scope, $) {


		var $wrapper = $scope.find('.wpb_single_image');
		if (!$wrapper.length) return;

		var tp_dataset = 'tp-gsap-cascding-image';

		Tp_image_animetions($wrapper, tp_dataset);

	};

	$(window).on("elementor/frontend/init", function () {
		elementorFrontend.hooks.addAction(
			"frontend/element_ready/tp-cascading-image.default",
			Tp_Cascading_image
		);
	});



	$(window).on("elementor/frontend/init", function () {

		if (!window.elementorFrontend.isEditMode()) {
			return;
		}
		
		elementor.on("preview:loaded", function () {

			elementor.channels.editor.on("tp:play_gsap_animation", function (controlView) {

				let elementObj = controlView.options.element;
				let elementId = elementObj.model.id;
				let settings = elementObj.model.get('settings').attributes;


				let tp_wrap = document.querySelector('.elementor-element-' + elementId);
				if (!tp_wrap) return;

				let tp_gsap_control = {
					tp_enable_image_ani: settings.enable_image_animation ?? 'no',
					tp_trigger: settings.image_trigger ?? 'onload',
					tp_x: settings.img_x?.size ?? 0,
					tp_y: settings.img_y?.size ?? 0,
					tp_skewx: settings.img_skewx?.size ?? 0,
					tp_skewy: settings.img_skewy?.size ?? 0,
					tp_scale: settings.img_scale?.size ?? 1,
					tp_rotation: settings.img_rotation?.size ?? 0,
					tp_opacity: settings.img_opacity?.size ?? 1,
					tp_origin: settings.img_origin ?? '50% 50%',
					tp_duration: settings.img_duration?.size ?? 1.2,
					tp_delay: settings.img_delay?.size ?? 0.3,
					tp_ease: settings.img_ease ?? 'power3.out',
					tp_clip_path_type: settings.tp_clip_path_type ?? 'none',
					tp_scrub: settings.tp_scrub ?? '',
					tp_custom_clip_path_value: settings.tp_custom_clip_path_value ?? '',
					// tp_img_stagger: settings.img_stagger ?? 1.2
				};

				var tp_image_ani_type = 'tp_elementor_editor';

				Tp_image_animetions(tp_wrap, tp_gsap_control, tp_image_ani_type);
			});
		});

	});



})(jQuery);