function waitForElement(selector, interval = 40000) {
    return new Promise(resolve => {
        const checkElement = () => {
            const el = document.querySelector(selector);
            if (el) {
                resolve(el); 
            } else {
                setTimeout(checkElement, interval); 
            }
        };
        checkElement();
    });
}

waitForElement('#elementor-editor-wrapper .elementor-panel #elementor-panel-state-loading').then(foundEl => {

    foundEl.style.flexDirection = "column";
    foundEl.style.gap = "5px";

    let popupdesign = `<div class="popup-overlay">
        <div class="popup-close"> <i class="theplus-i-cross" style="color:var(--e-a-color-txt);"></i> </div>
        <div class="popup">
            
            <div class="popup-header">
                <h4> Unable to Load Elementor Panel! </h4>
                <p>Try one of these steps to get the panel loading again.</p>
            </div>
        
            <div class="popup-content">
                <div class="popup-contnet-box">
                    <h4> Increase Memory Limit </h4>
                    <p> Your site may not have enough memory for Elementor to run smoothly. If you are using addons, we recommend setting your WordPress memory limit to at least 512MB - 1024MB. </p>
                    <div class="popup-small-btn"> Current limit: ${tp_memory_limit_popup.memory_limit} </div>
                    <a href="https://elementor.com/blog/how-to-increase-wordpress-memory-limit/" class="popup-info-btn" target="_blank" rel="noopener noreferrer"> Increase Memory Limit <i class="theplus-i-external-link"></i> </a>
                </div>

                <div class="hr-with-text">
                    <hr> <span>OR</span>
                </div>

                <div class="popup-contnet-box">
                    <h4> Disable Unused Widgets or Plugins </h4>
                    <p> To reduce memory usage and improve performance, it's a good idea to disable any inactive Elementor widgets that you don't need. You can do this manually using Elementor's Widget Manager, which allows you to turn off specific widgets and keep your site lighter. </p>
                    <a href="${tp_memory_limit_popup.manager_link}" class="popup-info-btn" target="_blank" rel="noopener noreferrer"> Disable Widgets/Plugins <i class="theplus-i-external-link"></i> </a>
                </div>

            </div>

            <div class="popup-footer">
                <h4> Above doesn't helped? </h4>
                <p> If the panel is still not loading, there may be other reasons. For more detailed guidance, please check Elementor's help documentation or reach out to their support team. </p>
                <a href="https://elementor.com/help/elementor-widget-panel-not-loading/" class="popup-info-btn" target="_blank" rel="noopener noreferrer"> Read Guide <i class="theplus-i-external-link"></i> </a>
            </div>

        </div>
    </div>`;

    let extraaText = `<div class="dont-show-again"> Do not show this again </div>`;

    foundEl.insertAdjacentHTML('beforeend', popupdesign);
    foundEl.insertAdjacentHTML('beforeend', extraaText);
});

jQuery(document).on('click', '.elementor-panel #elementor-panel-state-loading .popup-overlay .popup-close', function(e) {
    e.preventDefault();

    jQuery('.popup-overlay').hide();
    jQuery('.dont-show-again').hide();

});

jQuery(document).on('click', '.elementor-panel #elementor-panel-state-loading .dont-show-again', function(e) {
    e.preventDefault();

    jQuery.ajax({
        url: ajaxurl,
        type: 'POST',
        data: {
            action: 'theplus_memory_popup_dismiss',
            security: tp_memory_limit_popup.nonce,
            type: 'tpae_memory_limit_notice',
        },
        success: function(response) {
            jQuery('.popup-overlay').hide();
            jQuery('.dont-show-again').hide();
        }
    });
});
