<?php

use Elementor\Core\DynamicTags\Tag;
use Elementor\Modules\DynamicTags\Module;

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

/**
 * Plus Addons Dynamic Tag - Archive Description
 *
 * Provides a dynamic tag for Elementor to output the current archive description.
 *
 * @since 6.4.5
 */
class ThePlus_Dynamic_Tag_Archive_Description extends Tag {

    /**
     * Unique dynamic tag name used internally by Elementor.
     *
     * @since 6.4.5
     * @return string
     */
    public function get_name(): string {
        return 'plus-tag-archive-description';
    }

    /**
     * Label shown in Elementor Dynamic Tags list.
     *
     * @since 6.4.5
     * @return string
     */
    public function get_title(): string {
        return esc_html__( 'Archive Description', 'theplus' );
    }

    /**
     * Registers the group under which this tag will appear.
     *
     * @since 6.4.5
     * @return array
     */
    public function get_group(): array {
        return ['plus-opt-archive'];
    }

    /**
     * Defines the category type (Text) for this dynamic tag.
     *
     * @since 6.4.5
     * @return array
     */
    public function get_categories(): array {
        return [
            Module::TEXT_CATEGORY,
        ];
    }

    /**
     * Register controls for this dynamic tag.
     *
     * @since 6.4.5
     * @return void
     */
    protected function register_controls(): void {}

    /**
     * Register controls for this dynamic tag.
     *
     * @since 6.4.5
     * @return void
     */
    protected function register_advanced_section(): void {}

    /**
     * Render the dynamic archive description on frontend.
     *
     * Gets the current archive description and prints it.
     *
     * @since 6.4.5
     * @return void
     */
    public function render(): void {
        $value = '';

        if ( is_category() || is_tag() || is_tax() ) {
            $term = get_queried_object();
            if ( $term && ! empty( $term->description ) ) {
                $value = wpautop( $term->description );
            }
        } elseif ( is_author() ) {
            $author_id = get_queried_object_id();
            $value = get_the_author_meta( 'description', $author_id );
        } elseif ( is_post_type_archive() ) {
            $post_type = get_queried_object();
            if ( $post_type && ! empty( $post_type->description ) ) {
                $value = wpautop( $post_type->description );
            }
        }

        echo wp_kses_post( $value );
    }
}
