<?php

use Elementor\Core\DynamicTags\Tag;
use Elementor\Modules\DynamicTags\Module;

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

/**
 * Plus Addons Dynamic Tag - User Login/Logout URL
 *
 * Provides a dynamic tag for Elementor to output the current user login/logout URL.
 *
 * @since 6.4.5
 */
class ThePlus_Dynamic_Tag_User_Login_Logout_URL extends Tag {

    /**
     * Unique dynamic tag name used internally by Elementor.
     *
     * @since 6.4.5
     * @return string
     */
	public function get_name(): string {
		return 'plus-tag-user-login-logout-url';
	}

    /**
     * Label shown in Elementor Dynamic Tags list.
     *
     * @since 6.4.5
     * @return string
     */
	public function get_title(): string {
		return esc_html__( 'User Login/Logout URL', 'theplus' );
	}

    /**
     * Registers the group under which this tag will appear.
     *
     * @since 6.4.5
     * @return array
     */
	public function get_group(): array {
		return [ 'plus-opt-user' ];
	}

    /**
     * Defines the category type (URL) for this dynamic tag.
     *
     * @since 6.4.5
     * @return array
     */
	public function get_categories(): array {
		return [
			Module::URL_CATEGORY,
		];
	}

    /**
     * Register controls for this dynamic tag.
     *
     * @since 6.4.5
     * @return void
     */
	protected function register_advanced_section() {}

	/**
     * Register controls for this dynamic tag.
     *
     * @since 6.4.5
     * @return void
     */
	protected function register_controls(): void {}

	/**
     * Render the dynamic user login/logout URL on frontend.
     *
     * Gets the current user and show it's login/logout URL.
     *
     * @since 6.4.5
     * @return void
     */
	public function render(): void {

		if ( is_user_logged_in() ) {

			$url = wp_logout_url( get_permalink() );

		} else {

			$url = wp_login_url( get_permalink() );
		}

		if ( ! empty( $url ) ) {
			echo esc_url( $url );
		}
	}
}
