<?php

use Elementor\Core\DynamicTags\Tag;
use Elementor\Modules\DynamicTags\Module;

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

/**
 * Plus Addons Dynamic Tag - User URL
 *
 * Provides a dynamic tag for Elementor to output the current user url.
 *
 * @since 6.4.5
 */
class ThePlus_Dynamic_Tag_User_URL extends Tag {

    /**
     * Unique dynamic tag name used internally by Elementor.
     *
     * @since 6.4.5
     * @return string
     */
	public function get_name(): string {
		return 'plus-tag-user-url';
	}

    /**
     * Label shown in Elementor Dynamic Tags list.
     *
     * @since 6.4.5
     * @return string
     */
	public function get_title(): string {
		return esc_html__( 'User URL', 'theplus' );
	}

    /**
     * Registers the group under which this tag will appear.
     *
     * @since 6.4.5
     * @return array
     */
	public function get_group(): array {
		return [ 'plus-opt-user' ];
	}

    /**
     * Defines the category type (URL) for this dynamic tag.
     *
     * @since 6.4.5
     * @return array
     */
	public function get_categories(): array {
		return [
			Module::URL_CATEGORY,
		];
	}

    /**
     * Register controls for this dynamic tag.
     *
     * @since 6.4.5
     * @return void
     */
	protected function register_controls(): void {}

    /**
     * Render the dynamic user URL on frontend.
     *
     * Gets the current user and prints its URL.
     *
     * @since 6.4.5
     * @return void
     */
	public function render(): void {

		if ( is_author() ) {
			$user_id = get_queried_object_id();
		} else {
			$user_id = get_current_user_id();
		}

		if ( ! $user_id ) {
			return;
		}

		$url = get_author_posts_url( $user_id );

		if ( empty( $url ) ) {
			return;
		}

		echo esc_url( $url );
	}
}
