<?php

use Elementor\Core\DynamicTags\Tag;
use Elementor\Modules\DynamicTags\Module;

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

/**
 * Plus Addons Dynamic Tag - Product Short Description
 *
 * Provides a dynamic tag for Elementor to output the current product short description.
 *
 * @since 6.4.5
 */
class ThePlus_Dynamic_Tag_Product_Short_Description extends Tag {

    /**
     * Unique dynamic tag name used internally by Elementor.
     *
     * @since 6.4.5
     * @return string
     */
	public function get_name(): string {
		return 'plus-tag-product-short-description';
	}

    /**
     * Label shown in Elementor Dynamic Tags list.
     *
     * @since 6.4.5
     * @return string
     */
	public function get_title(): string {
		return esc_html__( 'Product Short Description', 'theplus' );
	}

    /**
     * Registers the group under which this tag will appear.
     *
     * @since 6.4.5
     * @return array
     */
	public function get_group(): array {
		return [ 'plus-opt-woocommerce' ];
	}

    /**
     * Defines the category type (Text, Post Meta) for this dynamic tag.
     *
     * @since 6.4.5
     * @return array
     */
	public function get_categories(): array {
		return [
			Module::TEXT_CATEGORY,
			Module::POST_META_CATEGORY,
		];
	}

    /**
     * Register controls for this dynamic tag.
     *
     * @since 6.4.5
     * @return void
     */
	protected function register_controls(): void {}

    /**
     * Render the dynamic product short description on frontend.
     *
     * Gets the current product short description and prints it.
     *
     * @since 6.4.5
     * @return void
     */
	public function render(): void {

		$short_description = '';

		$product = function_exists( 'wc_get_product' ) ? wc_get_product() : false;

		if ( $product ) {
			$short_description = $product->get_short_description();
		} else {
			$post_id = get_the_ID();
			if ( ! $post_id || 'product' !== get_post_type( $post_id ) ) {
				return;
			}
			$short_description = get_post_field( 'post_excerpt', $post_id );
		}

		if ( empty( $short_description ) ) {
			return;
		}

		$short_description = wp_strip_all_tags( $short_description, true );

		echo esc_html( $short_description );
	}
}
