<?php

use Elementor\Core\DynamicTags\Tag;
use Elementor\Modules\DynamicTags\Module;

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

/**
 * Plus Addons Dynamic Tag - Product SKU
 *
 * Provides a dynamic tag for Elementor to output the current product SKU.
 *
 * @since 6.4.5
 */
class ThePlus_Dynamic_Tag_Product_SKU extends Tag {

    /**
     * Unique dynamic tag name used internally by Elementor.
     *
     * @since 6.4.5
     * @return string
     */
	public function get_name(): string {
		return 'plus-tag-product-sku';
	}

    /**
     * Label shown in Elementor Dynamic Tags list.
     *
     * @since 6.4.5
     * @return string
     */
	public function get_title(): string {
		return esc_html__( 'Product SKU', 'theplus' );
	}

    /**
     * Registers the group under which this tag will appear.
     *
     * @since 6.4.5
     * @return array
     */
	public function get_group(): array {
		return [ 'plus-opt-woocommerce' ];
	}

    /**
     * Defines the category type (Text) for this dynamic tag.
     *
     * @since 6.4.5
     * @return array
     */
	public function get_categories(): array {
		return [
			Module::TEXT_CATEGORY,
		];
	}

    /**
     * Register controls for this dynamic tag.
     *
     * @since 6.4.5
     * @return void
     */
	protected function register_controls(): void {}

    /**
     * Render the dynamic product SKU on frontend.
     *
     * Gets the current product ID and prints its SKU.
     *
     * @since 6.4.5
     * @return void
     */
	public function render(): void {

		$product = wc_get_product();

		if ( $product ) {
			$sku = $product->get_sku();
			echo esc_html( $sku );
			return;
		}

		$post_id = get_the_ID();

		if ( $post_id && get_post_type( $post_id ) === 'product' ) {
			$product = wc_get_product( $post_id );

			if ( $product ) {
				echo esc_html( $product->get_sku() );
			}
		}
	}
}
