<?php

use Elementor\Core\DynamicTags\Tag;
use Elementor\Modules\DynamicTags\Module;

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

/**
 * Plus Addons Dynamic Tag - Product URL
 *
 * Provides a dynamic tag for Elementor to output the current product url.
 *
 * @since 6.4.5
 */
class ThePlus_Dynamic_Tag_Product_URL extends Tag {

    /**
     * Unique dynamic tag name used internally by Elementor.
     *
     * @since 6.4.5
     * @return string
     */
	public function get_name(): string {
		return 'plus-tag-product-url';
	}

    /**
     * Label shown in Elementor Dynamic Tags list.
     *
     * @since 6.4.5
     * @return string
     */
	public function get_title(): string {
		return esc_html__( 'Product URL', 'theplus' );
	}

    /**
     * Registers the group under which this tag will appear.
     *
     * @since 6.4.5
     * @return array
     */
	public function get_group(): array {
		return [ 'plus-opt-woocommerce' ];
	}

    /**
     * Defines the category type (URL) for this dynamic tag.
     *
     * @since 6.4.5
     * @return array
     */
	public function get_categories(): array {
		return [
			Module::URL_CATEGORY,
		];
	}

    /**
     * Register controls for this dynamic tag.
     *
     * @since 6.4.5
     * @return void
     */
	protected function register_advanced_section() {}

	/**
     * Register controls for this dynamic tag.
     *
     * @since 6.4.5
     * @return void
     */
	protected function register_controls(): void {}

    /**
     * Render the dynamic product URL on frontend.
     *
     * Gets the current product ID and prints its URL.
     *
     * @since 6.4.5
     * @return void
     */
	public function render(): void {

		$product = wc_get_product();

		if ( $product ) {
			$url = get_permalink( $product->get_id() );
			echo esc_url( $url );
			return;
		}

		$post_id = get_the_ID();

		if ( $post_id && 'product' === get_post_type( $post_id ) ) {
			$url = get_permalink( $post_id );
			echo esc_url( $url );
		}
	}
}
