<?php
use Automattic\WooCommerce\Blocks\Package;
use Automattic\WooCommerce\Blocks\StoreApi\Schemas\CartSchema;
use Automattic\WooCommerce\Blocks\StoreApi\Schemas\CheckoutSchema;
use Automattic\WooCommerce\Blocks\Integrations\IntegrationRegistry;

if ( ! class_exists( 'TC_WB_Extend_Store_Endpoint' ) ) {

    /**
     * Extend Store API.
     */
    class TC_WB_Extend_Store_Endpoint {

        /**
         * Stores cart data (fields, keys and values)
         * @var array
         */
        private static $cart_data;

        /**
         * Stores Rest Extending instance.
         * @var ExtendRestApi
         */
        private static $extend;

        /**
         * Plugin Identifier, unique to each plugin.
         * @var string
         */
        const IDENTIFIER = 'checkout-recaptcha';

        /**
         * Bootstraps the class and hooks required data.
         */
        public static function init() {

            self::$cart_data = TC_WB_Blocks_Integration::get_cart_data();
            self::$extend = Automattic\WooCommerce\StoreApi\StoreApi::container()->get( Automattic\WooCommerce\StoreApi\Schemas\ExtendSchema::class );

            if ( self::$cart_data ) {
                self::extend_store();
            }
        }

        /**
         * Registers the actual data into each endpoint.
         */
        public static function extend_store() {
            if ( is_callable( [ self::$extend, 'register_endpoint_data' ] ) ) {
                self::$extend->register_endpoint_data(
                    [
                        'endpoint'        => CheckoutSchema::IDENTIFIER,
                        'namespace'       => self::IDENTIFIER,
                        'schema_callback' => [ 'TC_WB_Extend_Store_Endpoint', 'extend_checkout_schema' ],
                        'schema_type'     => ARRAY_A,
                    ]
                );
            }
        }

        /**
         * Register checkout owner fields schema into the Checkout endpoint.
         * @return array Registered schema.
         */
        public static function extend_checkout_schema() {

            $cart_data = self::$cart_data;
            $data = [];

            // Owner Fields
            $cart_items = isset( $cart_data[ 'items' ] ) ? $cart_data[ 'items' ] : [];
            $owner_fields = isset( $cart_data[ 'owner_fields' ] ) ? $cart_data[ 'owner_fields' ] : [];
            foreach ( $cart_items as $ticket_type_id => $item ) {

                for ( $i = 0; $i < $item[ 'quantity' ]; $i++ ) {

                    foreach ( $owner_fields[ $ticket_type_id ] as $field ) {

                        if ( 'label' != $field[ 'field_type' ] ) {

                            $options = isset( $field[ 'field_values' ] ) ? explode( ',', $field[ 'field_values' ] ) : [];
                            $options = ( $options ) ? array_filter( $options ) : [];

                            if ( $options && 'checkbox' == $field[ 'field_type' ] ) {

                                foreach ( $options as $index => $option_value ) {

                                    $data[ $item[ 'id' ] . '_' . $i . '_' . $field[ 'field_name' ] . '_option_' . $index . '_post_meta' ] = [
                                        'description' => '',
                                        'type'        => 'string',
                                        'context'     => [ 'view', 'edit' ],
                                        'readonly'    => true,
                                        'optional'    => isset( $field[ 'required' ] ) ? $field[ 'required' ] : false,
                                        'arg_options' => [
                                            'validate_callback' => function( $value ) {
                                                return is_string( $value );
                                            },
                                        ]
                                    ];
                                }

                            } else {

                                $data[ $item[ 'id' ] . '_' . $i . '_' . $field[ 'field_name' ] . '_post_meta' ] = [
                                    'description' => '',
                                    'type'        => 'string',
                                    'context'     => [ 'view', 'edit' ],
                                    'readonly'    => true,
                                    'optional'    => isset( $field[ 'required' ] ) ? $field[ 'required' ] : false,
                                    'arg_options' => [
                                        'validate_callback' => function( $value ) {
                                            return is_string( $value );
                                        },
                                    ]
                                ];
                            }
                        }
                    }
                }
            }

            // Buyer Fields
            $buyer_fields = isset( $cart_data[ 'buyer_fields' ] ) ? $cart_data[ 'buyer_fields' ] : [];
            foreach ( $buyer_fields as $field ) {

                if ( ( ( isset( $field[ 'form_visibility' ] ) && $field[ 'form_visibility' ] ) || ! isset( $field[ 'form_visibility' ] ) ) && 'label' != $field[ 'field_type' ] ) {

                    $options = isset( $field[ 'field_values' ] ) ? explode( ',', $field[ 'field_values' ] ) : [];
                    $options = ( $options ) ? array_filter( $options ) : [];

                    if ( $options && 'checkbox' == $field[ 'field_type' ] ) {

                        foreach ( $options as $index => $option_value ) {

                            $data[ 'buyer_data_' . $field[ 'field_name' ] . '_option_' . $index . '_post_meta' ] = [
                                'description' => '',
                                'type'        => 'string',
                                'context'     => [ 'view', 'edit' ],
                                'readonly'    => true,
                                'optional'    => isset( $field[ 'required' ] ) ? $field[ 'required' ] : false,
                                'arg_options' => [
                                    'validate_callback' => function( $value ) {
                                        return is_string( $value );
                                    },
                                ]
                            ];
                        }

                    } else {

                        $data[ 'buyer_data_' . $field[ 'field_name' ] . '_post_meta' ] = [
                            'description' => '',
                            'type'        => 'string',
                            'context'     => [ 'view', 'edit' ],
                            'readonly'    => true,
                            'optional'    => isset( $field[ 'required' ] ) ? $field[ 'required' ] : false,
                            'arg_options' => [
                                'validate_callback' => function( $value ) {
                                    return is_string( $value );
                                },
                            ]
                        ];
                    }
                }
            }

            return $data;
        }
    }
}
