<?php
if ( defined('TC_DEBUG')) {
    error_reporting(E_ALL);
    @ini_set('display_errors', 'On');
}

$class_name = tc_save_eval_strings($class_name, true);
$original_element_name = sanitize_title(str_replace('-', "-", $element_name));
$element_name_orig = tc_save_eval_strings($element_name);
$element_name = tc_save_eval_strings($element_name, true);

eval("
namespace Tickera\Ticket\Element;
if ( ! class_exists( \"\Tickera\Ticket\Element\\\\$class_name\" ) && class_exists( \"\Tickera\TC_Ticket_Template_Elements\" ) ) {
    class $class_name extends \Tickera\TC_Ticket_Template_Elements {
        
        var \$element_name       = \"$element_name\";
        var \$element_title      = \"" . esc_html( $element_title ) . "\";
        var \$element_name_orig  = \"$element_name_orig\";
        
        function on_creation() {
            \$this->element_title = apply_filters('tc_" . $element_name . "_title', esc_attr( \$this->element_title ));
        }
        
        function admin_content() {
            ob_start();
            parent::get_font_sizes();
            parent::get_font_style();
            parent::get_font_colors();
            parent::get_cell_alignment();
            parent::get_element_margins();
            self::field_label();
            return ob_get_clean();
        }
        
        function field_label() {
            
            \$element_value = isset( \$this->template_metas[ '" . $element_name_orig . "_field_label'  ] ) ? esc_attr( \$this->template_metas[ '" . $element_name_orig . "_field_label' ] ) : esc_attr( \$this->element_title );
           
            \$html = '<label>' . _e( 'Field Label', 'cf' );
            \$html .= \"<input class='ticket_element_field_label' type='text' name='" . esc_attr( $element_name_orig ) . "_field_label_post_meta' value='\$element_value'/>\";
            \$html .= '</label>';
            
            echo \$html;
        }
        
        function ticket_content( \$ticket_instance_id = false, \$ticket_type_id = false ) {
            
            if ( \$ticket_instance_id ) {
            
                \$ticket_instance = new \Tickera\TC_Ticket_Instance( (int) \$ticket_instance_id );
                \$order = new \Tickera\TC_Order( \$ticket_instance->details->post_parent );
             
                if ( 'buyer' == '" . $form_type . "' )
                    \$field_value = isset( \$order->details->tc_cart_info[ 'buyer_data' ][ '" . $element_name_orig . "_post_meta'] ) ? \$order->details->tc_cart_info[ 'buyer_data' ][ '" . $element_name_orig . "_post_meta'] : '' ;
    
                if ( 'owner' == '" . $form_type . "' )
                    \$field_value = isset( \$ticket_instance->details->$element_name_orig ) ? \$ticket_instance->details->$element_name_orig : '' ;
                    
                if ( isset( \$this->template_metas[ '" . $element_name_orig . "_field_label' ] ) && !empty( \$this->template_metas['" . $element_name_orig . "_field_label' ] ) )
                    \$field_label = apply_filters( 'tc_custom_forms_ticket_template_element_label_output', \$this->template_metas[ '" . $element_name_orig . "_field_label' ].'<br/>', \$this->element_name_orig );
                    
                else
                    \$field_label = '';
                
                return apply_filters( 'tc_custom_forms_ticket_template_element_output', apply_filters('tc_" . $element_name . "_ticket_type', \$field_label.' '.\$field_value), \$field_label, \$field_value );
            
            }  else {
                return esc_attr(\$this->element_title);
            }
        }
     }
     \\Tickera\\tickera_register_template_element('Tickera\Ticket\Element\\" . $element_name . "', '" . esc_attr( $element_title ) . "');
 }
");