<?php

/*
 * Plugin Name: Mollie for Tickera
 * Plugin URI: http://tickera.com/
 * Description: Accept iDeal, Credit Card, Bancontact / Mister Cash, SOFORT Banking, Overbooking, Bitcoin, PayPal, paysafecard and AcceptEmail payment via Mollie.
 * Author: Tickera.com
 * Author URI: http://tickera.com/
 * Version: 2.0.3
 * Update URI: https://api.freemius.com
 * Text Domain: tc-mollie
 * Domain Path: /languages/
 * Copyright 2019 Tickera (http://tickera.com/)
 */
namespace Tickera\Gateway;

if ( !defined( 'ABSPATH' ) ) {
    exit;
}
// Exit if accessed directly
if ( !function_exists( 'Tickera\\Gateway\\mpg_fs' ) ) {
    /**
     * Create a helper function for easy SDK access.
     *
     * @return Freemius
     * @throws \Freemius_Exception
     */
    function mpg_fs() {
        global $mpg_fs;
        if ( !isset( $mpg_fs ) ) {
            // Activate multisite network integration.
            if ( !defined( 'WP_FS__PRODUCT_3172_MULTISITE' ) ) {
                define( 'WP_FS__PRODUCT_3172_MULTISITE', true );
            }
            // Include Freemius SDK.
            if ( file_exists( dirname( dirname( __FILE__ ) ) . '/tickera-event-ticketing-system/freemius/start.php' ) ) {
                // Try to load SDK from parent plugin folder.
                require_once dirname( dirname( __FILE__ ) ) . '/tickera-event-ticketing-system/freemius/start.php';
            } elseif ( file_exists( dirname( dirname( __FILE__ ) ) . '/tickera/freemius/start.php' ) ) {
                // Try to load SDK from premium parent plugin folder.
                require_once dirname( dirname( __FILE__ ) ) . '/tickera/freemius/start.php';
            } else {
                require_once dirname( __FILE__ ) . '/freemius/start.php';
            }
            $mpg_fs = fs_dynamic_init( array(
                'id'               => '3172',
                'slug'             => 'mollie-payment-gateway',
                'premium_slug'     => 'mollie-payment-gateway',
                'type'             => 'plugin',
                'public_key'       => 'pk_e3581fda159a13888e4269b0621b6',
                'is_premium'       => true,
                'is_premium_only'  => true,
                'has_paid_plans'   => true,
                'is_org_compliant' => false,
                'parent'           => array(
                    'id'         => '3102',
                    'slug'       => 'tickera-event-ticketing-system',
                    'public_key' => 'pk_7a38a2a075ec34d6221fe925bdc65',
                    'name'       => 'Tickera',
                ),
                'menu'             => array(
                    'first-path' => 'plugins.php',
                    'support'    => false,
                ),
                'is_live'          => true,
            ) );
        }
        return $mpg_fs;
    }

}
/**
 * Check if the parent's init SDK method exists.
 *
 * @return bool
 */
function mpg_fs_is_parent_active_and_loaded() {
    return function_exists( 'Tickera\\tets_fs' );
}

function mpg_fs_is_parent_active() {
    $active_plugins = get_option( 'active_plugins', array() );
    if ( is_multisite() ) {
        $network_active_plugins = get_site_option( 'active_sitewide_plugins', array() );
        $active_plugins = array_merge( $active_plugins, array_keys( $network_active_plugins ) );
    }
    foreach ( $active_plugins as $basename ) {
        if ( 0 === strpos( $basename, 'tickera-event-ticketing-system/' ) || 0 === strpos( $basename, 'tickera/' ) ) {
            return true;
        }
    }
    return false;
}

function mpg_fs_init() {
    if ( mpg_fs_is_parent_active_and_loaded() ) {
        /*
         * Parent is active, add your init code here.
         * Init Freemius.
         */
        mpg_fs();
        if ( !mpg_fs()->can_use_premium_code() ) {
            return;
        }
    } else {
        /* Parent is inactive, add your error handling here. */
    }
}

if ( mpg_fs_is_parent_active_and_loaded() ) {
    // If parent already included, init add-on.
    mpg_fs_init();
} elseif ( mpg_fs_is_parent_active() ) {
    // Init add-on only after the parent is loaded.
    add_action( 'tets_fs_loaded', 'Tickera\\Gateway\\mpg_fs_init' );
} else {
    // Even though the parent is not activated, execute add-on for activation / uninstall hooks.
    mpg_fs_init();
}
//if( mpg_fs_is_parent_active_and_loaded() && mpg_fs()->can_use_premium_code() ){
add_action( 'tc_load_gateway_plugins', 'Tickera\\Gateway\\register_mollie_gateway' );
//}
function register_mollie_gateway() {
    class TC_Gateway_Mollie extends \Tickera\TC_Gateway_API {
        var $version = '1.6';

        var $plugin_name = 'mollie';

        var $admin_name = 'Mollie';

        var $public_name = '';

        var $method_img_url = '';

        var $method_button_img_url = '';

        var $ipn_url;

        var $currencies = [];

        var $skip_payment_screen = true;

        var $dir_name = 'mollie-payment-gateway';

        var $location = 'plugins';

        var $plugin_dir = '';

        var $plugin_url = '';

        var $hourly_interval = [];

        var $api_key;

        var $currency;

        var $language;

        var $mollie;

        /**
         * Support for older payment gateway API
         */
        function on_creation() {
            $this->init();
            add_action( 'activated_plugin', array($this, 'plugin_dependencies'), 99 );
            add_action( 'tc_save_tc_gateway_settings', array($this, 'schedule_order_status_confirmation') );
            add_action( 'tc_mollie_maybe_confirm_pending_posts_hook', array($this, 'maybe_confirm_pending_orders') );
        }

        function init() {
            $this->init_vars();
            // Localize the plugin
            add_action( 'init', array(&$this, 'localization'), 10 );
            $this->admin_name = __( 'Mollie', 'tc-mollie' );
            $this->public_name = __( 'Mollie', 'tc-mollie' );
            $this->method_img_url = apply_filters( 'tc_gateway_method_img_url', plugin_dir_url( __FILE__ ) . 'assets/images/mollie.png', $this->plugin_name );
            $this->admin_img_url = apply_filters( 'tc_gateway_admin_img_url', plugin_dir_url( __FILE__ ) . 'assets/images/small-mollie.png', $this->plugin_name );
            $this->api_key = $this->get_option( 'api_key' );
            $this->public_name = $this->get_option( 'public_name', $this->public_name );
            $this->currency = $this->get_option( 'currency', 'EUR' );
            $currencies = array(
                "EUR" => __( 'EUR (All payment methods)', 'tc' ),
                "AUD" => __( 'AUD - Australian Dollar (PayPal, credit card)', 'tc' ),
                "BGN" => __( 'BGN - Bulgarian lev (Credit card)', 'tc' ),
                "BRL" => __( 'BRL - Brazilian real (PayPal)', 'tc' ),
                "CAD" => __( 'CAD - Canadian dollar (PayPal, credit card)', 'tc' ),
                "CHF" => __( 'CHF - Swiss franc (PayPal, credit card)', 'tc' ),
                "CZK" => __( 'CZK - Czech koruna (PayPal, credit card)', 'tc' ),
                "DKK" => __( 'DKK - Danish krone (PayPal, credit card)', 'tc' ),
                "GBP" => __( 'GBP - British pound (PayPal, credit card)', 'tc' ),
                "HKD" => __( 'HKD - Hong Kong dollar (PayPal, credit card)', 'tc' ),
                "HRK" => __( 'HRK - Croatian kuna (Credit card)', 'tc' ),
                "HUF" => __( 'HUF - Hungarian forint (PayPal, credit card)', 'tc' ),
                "ILS" => __( 'ILS - Israeli shekel (PayPal, credit card)', 'tc' ),
                "ISK" => __( 'ISK - Icelandic krona (Credit card)', 'tc' ),
                "JPY" => __( 'JPY - Japanese yen (PayPal, credit card)', 'tc' ),
                "MXN" => __( 'MXN - Mexican peso (PayPal)', 'tc' ),
                "MYR" => __( 'MYR - Malaysian ringgit (PayPal)', 'tc' ),
                "NOK" => __( 'NOK - Norwegian krone (PayPal, credit card)', 'tc' ),
                "NZD" => __( 'NZD - New Zealand dollar (PayPal)', 'tc' ),
                "PHP" => __( 'PHP - Philippine piso (PayPal)', 'tc' ),
                "PLN" => __( 'PLN - Polish zloty (PayPal, credit card)', 'tc' ),
                "RON" => __( 'RON - Romanian leu (Credit card)', 'tc' ),
                "RUB" => __( 'RUB - Russian ruble (PayPal)', 'tc' ),
                "SEK" => __( 'SEK - Swedish krona (PayPal, credit card)', 'tc' ),
                "SGD" => __( 'SGD - Singapore dollar (PayPal)', 'tc' ),
                "THB" => __( 'THB - Thai baht (PayPal)', 'tc' ),
                "TWD" => __( 'TWD - New Taiwan dollar (PayPal)', 'tc' ),
                "USD" => __( 'USD - US dollar (PayPal, credit card)', 'tc' ),
            );
            $this->currencies = apply_filters( 'tc_mollie_currencies', $currencies );
            for ($i = 1; $i <= 72; $i++) {
                $this->hourly_interval[$i] = sprintf( __( 'Every %s %s', 'tc' ), $i, ( $i > 1 ? 'hours' : 'hour' ) );
            }
        }

        /**
         * Setup proper directories
         */
        function init_vars() {
            if ( defined( 'WP_PLUGIN_URL' ) && defined( 'WP_PLUGIN_DIR' ) && file_exists( WP_PLUGIN_DIR . '/' . $this->dir_name . '/' . basename( __FILE__ ) ) ) {
                $this->location = 'subfolder-plugins';
                $this->plugin_dir = WP_PLUGIN_DIR . '/' . $this->dir_name . '/';
                $this->plugin_url = plugins_url( '/', __FILE__ );
            } elseif ( defined( 'WP_PLUGIN_URL' ) && defined( 'WP_PLUGIN_DIR' ) && file_exists( WP_PLUGIN_DIR . '/' . basename( __FILE__ ) ) ) {
                $this->location = 'plugins';
                $this->plugin_dir = WP_PLUGIN_DIR . '/';
                $this->plugin_url = plugins_url( '/', __FILE__ );
            } elseif ( is_multisite() && defined( 'WPMU_PLUGIN_URL' ) && defined( 'WPMU_PLUGIN_DIR' ) && file_exists( WPMU_PLUGIN_DIR . '/' . basename( __FILE__ ) ) ) {
                $this->location = 'mu-plugins';
                $this->plugin_dir = WPMU_PLUGIN_DIR;
                $this->plugin_url = WPMU_PLUGIN_URL;
            } else {
                wp_die( sprintf( __( 'There was an issue determining where %s is installed. Please reinstall it.', 'tc-mollie' ), $this->title ) );
            }
        }

        /**
         * Plugin localization function
         */
        function localization() {
            /*
             * Load up the localization file if we're using WordPress in a different language.
             * Place it in this plugin's "languages" folder and name it "tc-[value in wp-config].mo"
             */
            if ( 'mu-plugins' == $this->location ) {
                load_muplugin_textdomain( 'tc-mollie', 'languages/' );
            } elseif ( 'subfolder-plugins' == $this->location ) {
                load_plugin_textdomain( 'tc-mollie', false, dirname( plugin_basename( __FILE__ ) ) . '/languages/' );
            } elseif ( 'plugins' == $this->location ) {
                load_plugin_textdomain( 'tc-mollie', false, 'languages/' );
            }
            $temp_locales = explode( '_', get_locale() );
            $this->language = ( $temp_locales[0] ? $temp_locales[0] : 'en' );
        }

        /**
         * Load this plugin the very last to ensure all the dependencies loaded first.
         */
        function plugin_dependencies() {
            $plugin_slug = basename( __DIR__ ) . '/' . basename( __FILE__ );
            $active_plugins = get_option( 'active_plugins', [] );
            $index = array_search( $plugin_slug, $active_plugins );
            if ( $index !== false ) {
                unset($active_plugins[$index]);
                $active_plugins[] = $plugin_slug;
                update_option( 'active_plugins', array_values( $active_plugins ) );
            }
        }

        /**
         * Initiate Mollie files
         */
        function init_mollie() {
            require_once 'mollie-api-php/vendor/autoload.php';
            $this->mollie = new \Mollie\Api\MollieApiClient();
            $this->mollie->setApiKey( $this->api_key );
        }

        /**
         * Process payment during checkout
         *
         * @param $cart
         */
        function process_payment( $cart ) {
            global $tc;
            $this->maybe_start_session();
            $this->save_cart_info();
            $this->init_mollie();
            $order_id = $tc->generate_order_id();
            $duedate = strtotime( apply_filters( 'tc_mollie_duedate_days', '+30 days' ), time() );
            try {
                $payment = $this->mollie->payments->create( [
                    "amount"      => [
                        "currency" => $this->currency,
                        "value"    => number_format(
                            (float) $this->total(),
                            2,
                            '.',
                            ''
                        ),
                    ],
                    "description" => $this->cart_items(),
                    "redirectUrl" => apply_filters( 'tc_mollie_redirect_url', $tc->get_confirmation_slug( true, $order_id ), $order_id ),
                    "webhookUrl"  => $this->ipn_url,
                    'cancelUrl'   => $tc->get_payment_slug( true ),
                    "metadata"    => array(
                        "order_id" => $order_id,
                    ),
                    "dueDate"     => date( 'Y-m-d', $duedate ),
                ] );
                $payment_url = $payment->_links->checkout->href;
                $payment_info = array_merge( (array) $payment, [
                    'transaction_id' => $payment->id,
                ] );
                $payment_info = $this->save_payment_info( $payment_info );
                $order_id = $tc->create_order(
                    $order_id,
                    $this->cart_contents(),
                    $this->cart_info(),
                    $payment_info,
                    false
                );
                $order = tickera_get_order_id_by_name( $order_id );
                // Store transaction id for later use.
                update_post_meta( $order->ID, 'transaction_id', $payment_info['transaction_id'] );
                // Add transaction id as a note.
                \Tickera\TC_Order::add_order_note( $order->ID, __( 'Transaction ID: ' . $payment_info['transaction_id'], 'tc-mollie' ) );
                // Store gateway class for cron processes
                update_post_meta( $order->ID, 'gateway_class', 'TC_Gateway_Mollie' );
                /**
                 * Suppressing errors from wp_redirect.
                 * Fallback redirection with tc_js_redirect
                 */
                @wp_redirect( $payment_url );
                tickera_js_redirect( $payment_url );
                exit;
            } catch ( \Mollie\Api\Exceptions\ApiException $e ) {
                $error = __( 'API call failed: ', 'tc-mollie' ) . htmlspecialchars( $e->getMessage() );
                $tc->session->set( 'tc_gateway_error', $error );
                /**
                 * Suppressing errors from wp_redirect.
                 * Fallback redirection with tc_js_redirect
                 */
                @wp_redirect( $tc->get_payment_slug( true ) );
                tickera_js_redirect( $tc->get_payment_slug( true ) );
                exit;
            }
        }

        /**
         * Confirm payment from Mollie gateway to Tickera
         *
         * @param $order
         * @param string $payment_info
         * @param string $cart_info
         */
        function order_confirmation( $order, $payment_info = '', $cart_info = '' ) {
            $order = tickera_get_order_id_by_name( $order );
            $order_object = new \Tickera\TC_Order($order->ID);
            $transaction_id = ( isset( $_REQUEST['id'] ) ? $_REQUEST['id'] : $order_object->details->tc_payment_info['transaction_id'] );
            self::confirm_mollie_payment_status( $order->ID, $transaction_id );
        }

        /**
         * Confirm and process order status based on Mollie payment post data.
         *
         * @param $order_id
         * @param $transaction_id
         */
        function confirm_mollie_payment_status( $order_id, $transaction_id ) {
            global $tc;
            $this->init_mollie();
            if ( $transaction_id ) {
                try {
                    $this->init_mollie();
                    $payment = $this->mollie->payments->get( $transaction_id );
                    if ( $payment->isPaid() ) {
                        if ( $payment->hasRefunds() ) {
                            if ( 'yes' == $this->get_option( 'skip_refund_status_update', 'no' ) ) {
                                self::refund_order( $order_id, $payment );
                            }
                        } else {
                            $tc->update_order_payment_status( $order_id, true );
                        }
                    } else {
                        $note = sprintf( __( '%s payment by Mollie', 'tc-mollie' ), ucwords( $payment->status ) );
                        \Tickera\TC_Order::add_order_note( $order_id, $note );
                        $order_statuses = [
                            'canceled' => 'order_cancelled',
                            'open'     => 'order_cancelled',
                            'pending'  => 'order_cancelled',
                            'expired'  => 'order_cancelled',
                            'failed'   => 'order_cancelled',
                            'paid'     => 'order_paid',
                        ];
                        if ( isset( $order_statuses[$payment->status] ) ) {
                            $tc->update_order_status( $order_id, $order_statuses[$payment->status] );
                        }
                    }
                } catch ( Mollie\Api\Exceptions\ApiException $e ) {
                    \Tickera\TC_Order::add_order_note( $order_id, $e->getMessage() );
                }
            }
        }

        function refund_order( $order_id, $payment ) {
            global $wpdb;
            $wpdb->update(
                $wpdb->posts,
                array(
                    'post_status' => 'order_refunded',
                ),
                array(
                    'ID' => $order_id,
                ),
                array('%s'),
                array('%1d')
            );
            // Ensures the status has been updated. There's an instance when $wpdb->update remains pending for some reasons.
            if ( 'order_refunded' != get_post_status( (int) $order_id ) ) {
                wp_update_post( [
                    'ID'          => (int) $order_id,
                    'post_status' => 'order_refunded',
                ] );
            }
            add_post_meta( (int) $order_id, 'tr_refunded', $payment );
            $amount_refunded = $payment->amountRefunded->value . ' ' . $payment->amountRefunded->currency;
            $amount_remaining = $payment->amountRemaining->value . ' ' . $payment->amountRemaining->currency;
            \Tickera\TC_Order::add_order_note( $order_id, sprintf( 
                /* translator: 1: Amount refunded 2. Amount remaining */
                __( '<strong>Refunded by Mollie</strong><br>Refunded: %s<br>Remaining: %s', 'tc' ),
                esc_html( $amount_refunded ),
                esc_html( $amount_remaining )
             ) );
        }

        /**
         * Render admin setting fields
         *
         * @param $settings
         * @param $visible
         */
        function gateway_admin_settings( $settings, $visible ) {
            ?>
            <div id="<?php 
            echo $this->plugin_name;
            ?>" class="postbox" <?php 
            echo ( !$visible ? 'style="display:none;"' : '' );
            ?>>
                <h3 class='handle'><span><?php 
            printf( __( '%s Settings', 'tc-mollie' ), $this->admin_name );
            ?></span></h3>
                <div class="inside">
                    <span class="description">
                        <?php 
            _e( 'Mollie provides a fully PCI Compliant and secure way to collect payments via iDeal, Credit Card, Bancontact / Mister Cash, SOFORT Banking, Overbooking, Bitcoin, PayPal, paysafecard and AcceptEmail.', 'tc-mollie' );
            if ( in_array( $_SERVER['REMOTE_ADDR'], array('127.0.0.1', '::1') ) ) {
                printf( '<div style="border-left: 4px solid #ffb900; margin: 5px 0 15px; background: #fff; left: 4px; solid #fff; box-shadow: 0 1px 1px 0 rgba(0,0,0,.1); padding: 5px 12px;">%s</div>', __( 'NOTE: Mollie cannot be tested in the localhost environment because it won\'t unable to reach webhook URL.', 'tc' ) );
            }
            ?>
                    </span>
                    <?php 
            $fields = [
                'api_key'                                           => [
                    'title' => __( 'Mollie API Key', 'tc-mollie' ),
                    'type'  => 'text',
                ],
                'public_name'                                       => [
                    'title' => __( 'Payment Method Name (shown on front)', 'tc-mollie' ),
                    'type'  => 'text',
                ],
                'currency'                                          => [
                    'title'       => __( 'Currency', 'tc' ),
                    'type'        => 'select',
                    'options'     => $this->currencies,
                    'default'     => 'EUR',
                    'description' => __( 'Make sure that currency selected is the same as store currency selected in the General Settings', 'tc' ),
                ],
                'mollie_periodically_confirm_order_status'          => array(
                    'title'       => __( 'Periodically confirm order status', 'tc' ),
                    'type'        => 'select',
                    'options'     => [
                        'yes' => __( 'Yes', 'tc' ),
                        'no'  => __( 'No', 'tc' ),
                    ],
                    'default'     => 'no',
                    'description' => __( 'There\'s an instance when a payment gateway fails to return transaction response to the merchant website. This setting will allow the merchant\'s website to periodically confirms order status.', 'tc' ),
                ),
                'skip_refund_status_update'                         => [
                    'title'       => __( 'Skip refund status update', 'tc' ),
                    'type'        => 'select',
                    'options'     => [
                        'yes' => __( 'Yes', 'tc' ),
                        'no'  => __( 'No', 'tc' ),
                    ],
                    'default'     => 'no',
                    'description' => __( 'Keep the order status unchanged on the website when a payment is refunded through the Mollie dashboard.', 'tc' ),
                ],
                'mollie_periodically_confirm_order_status_interval' => array(
                    'title'       => __( 'Periodically confirm order status interval', 'tc' ),
                    'type'        => 'select',
                    'options'     => $this->hourly_interval,
                    'default'     => 24,
                    'conditional' => array(
                        'field_name' => 'mollie_periodically_confirm_order_status',
                        'field_type' => 'select',
                        'value'      => 'yes',
                        'action'     => 'show',
                    ),
                ),
            ];
            $form = new \Tickera\TC_Form_Fields_API(
                $fields,
                'tc',
                'gateways',
                $this->plugin_name
            );
            ?>
                    <table class="form-table">
                        <?php 
            $form->admin_options();
            ?>
                    </table>
                </div>
            </div>
            <?php 
        }

        function process_gateway_settings( $settings ) {
            return $settings;
        }

        /**
         * Mollie Webhook
         */
        function ipn() {
            if ( $_POST && isset( $_POST['id'] ) ) {
                $transaction_id = sanitize_text_field( $_POST['id'] );
                $order = get_posts( [
                    'post_type'      => 'tc_orders',
                    'post_status'    => 'any',
                    'meta_key'       => 'transaction_id',
                    'meta_value'     => $transaction_id,
                    'posts_per_page' => 1,
                ] );
                $order = reset( $order );
                self::confirm_mollie_payment_status( $order->ID, $transaction_id );
            }
        }

        function schedule_order_status_confirmation() {
            $periodically_confirm_order_status = $this->get_option( 'mollie_periodically_confirm_order_status', 'no' );
            if ( 'yes' == $periodically_confirm_order_status ) {
                if ( !wp_next_scheduled( 'tc_mollie_maybe_confirm_pending_posts_hook' ) ) {
                    wp_schedule_event( time(), 'hourly', 'tc_mollie_maybe_confirm_pending_posts_hook' );
                }
                self::maybe_confirm_pending_orders();
            } else {
                wp_clear_scheduled_hook( 'tc_mollie_maybe_confirm_pending_posts_hook' );
            }
        }

        function maybe_confirm_pending_orders() {
            global $wpdb;
            $periodically_confirm_order_status = $this->get_option( 'mollie_periodically_confirm_order_status', 'no' );
            $periodically_confirm_order_status_interval = $this->get_option( 'mollie_periodically_confirm_order_status_interval', 24 );
            if ( 'yes' == $periodically_confirm_order_status ) {
                $pending_orders = $wpdb->get_results( 'SELECT ID FROM ' . $wpdb->posts . ' as p, ' . $wpdb->postmeta . ' as pm  WHERE p.ID=pm.post_id AND pm.meta_key="gateway_class" AND pm.meta_value="TC_Gateway_Mollie" AND post_date < (NOW() - INTERVAL ' . (int) $periodically_confirm_order_status_interval . ' HOUR) AND p.post_type = "tc_orders" AND p.post_status = "order_received"', OBJECT );
                foreach ( $pending_orders as $pending_order ) {
                    $order_id = $pending_order->ID;
                    $order = new \Tickera\TC_Order($order_id);
                    if ( 'TC_Gateway_Mollie' == $order->details->tc_cart_info['gateway_class'] ) {
                        $transaction_id = get_post_meta( $order_id, 'transaction_id', true );
                        if ( $transaction_id ) {
                            self::confirm_mollie_payment_status( $order_id, $transaction_id );
                        }
                    }
                }
            }
        }

    }

    \Tickera\tickera_register_gateway_plugin( 'Tickera\\Gateway\\TC_Gateway_Mollie', 'mollie', __( 'Mollie', 'tc-mollie' ) );
}
