( function( $ ) {

    $( document ).ready( function() {

        /**
         * Update regions based on selected country
         */
        $(document).on('change', '#authorize-billing-country', function() {

            let selected_country = $(this).val();

            // Make sure to empty field before process
            $('#authorize-billing-state').empty().attr('disabled', true);

            $( authorizenet_params.region_data ).each( function( index, elem ) {

                if ( elem.countryShortCode == selected_country ) {
                    for ( let i = 0;  i < elem.regions.length; i++ ) {
                        $('#authorize-billing-state').append( '<option value="' + elem.regions[i].name + '">' + elem.regions[i].name + ' | ' + elem.regions[i].shortCode + '</option>' );
                    }
                    $('#authorize-billing-state').attr('disabled', false);
                }
            });
        });

        /**
         * Trigger Validation on Submit Payment
         */
        $(document).on('click', '#authorizenet-aim .tc_payment_confirm', function ( event ) {

            let error = false;

            $( '.tbl_authorizenet input, .tbl_authorizenet select' ).each( function() {

                if ( $( this ).val() == '' ) {
                    error = true;
                    $( this ).addClass( 'has-error' );
                }
            } );

            if ( error ) {
                event.preventDefault();

            } else {
                $( '#authorizenet-aim input[type="submit"]' ).hide();
                $( '#authorizenet-aim .overlay' ).addClass( 'active' );
            }
        });

        $( '.tbl_authorizenet input, .tbl_authorizenet select' ).on( 'keypress, change', function() {

            if ( $( this ) != '' ) {
                $( this ).removeClass( 'has-error' );
            }
        } );

        /**
         * Validate if Numeric value
         * @param evt
         * @returns {boolean}
         */
        function isNumeric(evt) {
            let charCode = (evt.which) ? evt.which : event.keyCode
            if (charCode > 31 && (charCode < 48 || charCode > 57))
                return false;
            return true;
        }

    } );

} )( jQuery );