<?php
if ( wp_verify_nonce( @$_POST[ 'save_pushover_settings_nonce' ], 'save_pushover_settings' ) ) {
	update_option( 'tc_pushover_settings', $_POST[ 'tc_pushover' ] );
}

$tc_pushover_settings = get_option( 'tc_pushover_settings' );
?>

<div class="wrap tc_wrap">

    <div id="poststuff" class="metabox-holder tc-settings">
        <?php
        $current_tab_url = add_query_arg( array(
            'post_type'	 => 'tc_events',
            'page'		 => $_GET[ 'page' ],
            'tab'		 => isset( $_GET[ 'tab' ] ) ? $_GET[ 'tab' ] : '',
        ), admin_url( 'edit.php' ) );
        ?>
        <form id="tc-pushover-settings" method="post" action="<?php echo $current_tab_url; ?>">
            <?php
            wp_nonce_field( 'save_pushover_settings', 'save_pushover_settings_nonce' );

            $pushover_settings = new TC_Settings_Pushover();
            $sections = $pushover_settings->get_settings_pushover_sections();
            ?>

            <?php foreach ( $sections as $section ) {
                ?>
                <div id="<?php echo esc_attr( $section[ 'name' ] ); ?>" class="postbox">
                    <h3><span><?php echo esc_attr( $section[ 'title' ] ); ?></span></h3>
                    <div class="inside">
                        <span class="description"><?php echo $section[ 'description' ]; ?></span>
                        <table class="form-table">
                            <?php
                            $fields = $pushover_settings->get_settings_pushover_fields();

                            foreach ( $fields as $field ) {
                                if ( isset( $field[ 'section' ] ) && $field[ 'section' ] == $section[ 'name' ] ) {
                                    ?>
                                    <tr valign="top" id="<?php echo esc_attr( $field[ 'field_name' ] . '_holder' ); ?>" <?php Tickera\TC_Fields::conditionals( $field ); ?>>
                                        <th scope="row"><label for="<?php echo esc_attr( $field[ 'field_name' ] ); ?>"><?php echo $field[ 'field_title' ]; ?><?php (isset( $field[ 'tooltip' ] ) ? tickera_tooltip( $field[ 'tooltip' ] ) : ''); ?></label></th>
                                        <td class="pushover-regular-fields">
                                            <?php

                                            $field_name_tag = isset( $field['tag'] ) ? $field['tag'] : $field['field_name'];

                                            switch ( $field_name_tag ) {

                                                case 'priority':
                                                    $selected_priority = isset( $tc_pushover_settings[$field['field_name']] ) ? $tc_pushover_settings[$field['field_name']] : '1';
                                                    $default_options = array (
                                                        '-2' => __( 'Generate no notification / alert', 'push'),
                                                        '-1' => __( 'Always send as a quiet notification', 'push' ),
                                                        '1' => __( "Display as high-priority and bypass the user's quiet hours", 'push' ),
                                                        '2' => __( 'Require confirmation from the user', 'push' )
                                                    );
                                                    $html = '<select id="' . esc_attr($field["field_name"]) . '" name="tc_pushover[' . esc_attr($field["field_name"]) . ']">';
                                                    foreach ( $default_options as $key => $val ) {
                                                        if ( $selected_priority == $key ) {
                                                            $html .=  '<option value="' . $key . '" selected="selected">' . __($val, 'push') . '</option>';
                                                        } else {
                                                            $html .=  '<option value="' . $key . '">' . __($val, 'push') . '</option>';
                                                        }
                                                    }
                                                    $html .= '</select>';
                                                    echo $html;
                                                    break;

                                                case 'sound':
                                                    $selected_sound = isset( $tc_pushover_settings[$field['field_name']] ) ? $tc_pushover_settings[$field['field_name']] : 'pushover';
                                                    $default_options = array (
                                                        'pushover' => __('Pushover (default)', 'push'),
                                                        'bike' => __('Bike', 'push'),
                                                        'bugle' => __('Bugle', 'push'),
                                                        'cashregister' => __('Cash Register', 'push'),
                                                        'classical' => __('Classical', 'push'),
                                                        'cosmic' => __('Cosmic', 'push'),
                                                        'falling' => __('Falling', 'push'),
                                                        'gamelan' => __('Gamelan', 'push'),
                                                        'incoming' => __('Incoming', 'push'),
                                                        'intermission' => __('Intermission', 'push'),
                                                        'magic' => __('Magic', 'push'),
                                                        'mechanical' => __('Mechanical', 'push'),
                                                        'pianobar' => __('Piano Bar', 'push'),
                                                        'siren' => __('Siren', 'push'),
                                                        'spacealarm' => __('Space Alarm', 'push'),
                                                        'tugboat' => __('Tug Boat', 'push'),
                                                        'alien' => __('Alien Alarm (long)', 'push'),
                                                        'climb' => __('Climb (long)', 'push'),
                                                        'persistent' => __('Persistent (long)', 'push'),
                                                        'echo' => __('Pushover Echo (long)', 'push'),
                                                        'updown' => __('Up Down (long)', 'push'),
                                                        'none' => __('None (silent))', 'push')
                                                    );
                                                    $html = '<select id="' . esc_attr($field['field_name']) . '" name="tc_pushover[' . esc_attr($field['field_name']) . ']">';
                                                    foreach ( $default_options as $key => $val ) {
                                                        if ( $selected_sound == $key ) {
                                                            $html .=  '<option value="' . $key . '" selected="selected">' . __($val, 'push') . '</option>';
                                                        } else {
                                                            $html .=  '<option value="' . $key . '">' . __($val, 'push') . '</option>';
                                                        }
                                                    }
                                                    $html .= '</select>';
                                                    echo $html;
                                                    break;

                                                default:

                                                    switch ( $field['field_type'] ) {
                                                        case 'extended_radio':
                                                            $html = '';
                                                            $selected_radio = isset( $tc_pushover_settings[$field['field_name']] ) ? $tc_pushover_settings[$field['field_name']] : 0;
                                                            foreach ( $field['values'] as $key => $val ) {

                                                                if ( $selected_radio == $key ) {
                                                                    $html .= '<label><input type="radio" name="tc_pushover[' . esc_attr( $field['field_name'] ) . ']" class="' . esc_attr( $field['field_name'] ) . '" value="' . stripslashes( esc_attr( $key ) ) . '" checked="checked">' . $val . '</label>';
                                                                } else {
                                                                    $html .= '<label><input type="radio" name="tc_pushover[' . esc_attr( $field['field_name'] ) . ']" class="' . esc_attr( $field['field_name'] ) . '" value="' . stripslashes( esc_attr( $key ) ) . '">' . $val . '</label>';
                                                                }
                                                            }
                                                            echo $html;
                                                            break;

                                                        case 'extended_textarea':
                                                            $pushover_settings->tc_get_pushover_message($field['field_name'], $field['default_value']);
                                                            $html = '<span class="description">' . esc_attr($field['field_description']) . '</span>';
                                                            echo $html;
                                                            break;

                                                        case 'extended_text':
                                                            $default_value = isset( $tc_pushover_settings[$field['field_name']] ) ? $tc_pushover_settings[$field['field_name']] : '';
                                                            $html = '<input type="text" class="' . esc_attr($field['field_name']) . '" id="' . esc_attr($field['field_name']) . '" name="tc_pushover[' . esc_attr($field['field_name']) . ']" value="' . $default_value . '">';
                                                            echo $html;
                                                            break;

                                                        default:
                                                            Tickera\TC_Fields::render_field( $field, 'tc_pushover_settings' );

                                                    }
                                            }

                                            ?>
                                        </td>
                                    </tr>
                                    <?php
                                }
                            }
                            ?>
                        </table>
                    </div>
                </div>
            <?php } ?>

            <?php submit_button( __( 'Save Settings' ), 'primary', 'save_tc_settings' ); ?>
        </form>
    </div>
</div>

