<?php

if (!defined('ABSPATH'))
    exit; // Exit if accessed directly

if (!class_exists('TC_Settings_Pushover')) {

    class TC_Settings_Pushover {

        function __construct() {
        }

        function TC_Settings_Pushover() {
            $this->__construct();
        }

        /**
         * Initialize Pushover Configuration Sections
         * @return array
         */
        function get_settings_pushover_sections() {
            $sections = array(
                array(
                    'name' => 'general_settings',
                    'title' => __('Pushover General Settings'),
                    'description' => '',
                ),
                array(
                    'name' => 'push_on_order_received',
                    'title' => __('Pushover Notification on Order Received'),
                    'description' => '',
                ),
                array(
                    'name' => 'push_on_order_paid',
                    'title' => __('Pushover Notification on Order Paid'),
                    'description' => '',
                ),
                array(
                    'name' => 'push_on_order_cancelled',
                    'title' => __('Pushover Notification on Order Cancelled'),
                    'description' => '',
                ),
                array(
                    'name' => 'push_on_order_fraud',
                    'title' => __('Pushover Notification on Order Fraud'),
                    'description' => '',
                ),
            );

            return $sections;
        }

        /**
         * Initialize Pushover Configuration Fields
         * @return array
         */
        function get_settings_pushover_fields() {

            $general_settings_email_fields = array(
                array(
                    'field_name' => 'api_key',
                    'field_title' => __('API Token/Key', 'push'),
                    'field_type' => 'extended_text',
                    'default_value' => '',
                    'field_description' => sprintf( __( '<a href="%s" target="_blank">%s</a> %s', 'push' ), 'https://pushover.net/apps/create', __( 'Create New App', 'push' ), __( 'and copy API Token/Key here', 'push' ) ),
                    'section' => 'general_settings'
                ),
                array(
                    'field_name' => 'user_key',
                    'field_title' => __('User Key', 'push'),
                    'field_type' => 'extended_text',
                    'default_value' => '',
                    'field_description' => sprintf( __( 'You will find this key under %s dashboard', 'push' ), '<a target="_blank" href="http://pushover.net">pushover.net</a>' ),
                    'section' => 'general_settings',
                ),
                array(
                    'field_name' => 'device',
                    'field_title' => __('Device', 'push'),
                    'field_type' => 'extended_text',
                    'default_value' => '',
                    'field_description' => __( "Your user's device name to send the message directly to that device, rather than all of the user's devices", 'push' ),
                    'section' => 'general_settings',
                ),
            );

            $push_on_order_received_fields = array(
                array(
                    'field_name' => 'order_received_notification',
                    'field_title' => __('Enable Notification', 'push'),
                    'field_type' => 'extended_radio',
                    'values' => [ 1 => 'Yes', 0 => 'No'],
                    'default_value' => '',
                    'section' => 'push_on_order_received',
                ),
                array(
                    'field_name' => 'order_received_title',
                    'field_title' => __('Title', 'push'),
                    'field_type' => 'extended_text',
                    'default_value' => '',
                    'section' => 'push_on_order_received',
                ),
                array(
                    'field_name' => 'order_received_message',
                    'field_title' => __('Message', 'push'),
                    'field_type' => 'extended_textarea',
                    'default_value' => sprintf( __('New order totalling %s with order no %s has been placed.', 'push'), 'ORDER_TOTAL', 'ORDER_ID' ),
                    'field_description' => sprintf(__('Body of the e-mail. You can use following placeholders (%s)', 'push'), 'ORDER_ID, ORDER_TOTAL, DOWNLOAD_URL, BUYER_NAME' ),
                    'section' => 'push_on_order_received',
                ),
                array(
                    'field_name' => 'order_received_priority',
                    'field_title' => __('Type / Priority', 'push'),
                    'field_type' => 'extended_select',
                    'function' => '',
                    'default_value' => '',
                    'section' => 'push_on_order_received',
                    'tag' => 'priority'
                ),
                array(
                    'field_name' => 'order_received_sound',
                    'field_title' => __('Sound', 'push'),
                    'field_type' => 'extended_select',
                    'default_value' => '',
                    'section' => 'push_on_order_received',
                    'tag' => 'sound'
                ),
            );

            $push_on_order_paid_fields = array(
                array(
                    'field_name' => 'order_paid_notification',
                    'field_title' => __('Enable Notification', 'push'),
                    'field_type' => 'extended_radio',
                    'values' => [ 1 => 'Yes', 0 => 'No'],
                    'default_value' => '',
                    'section' => 'push_on_order_paid',
                ),
                array(
                    'field_name' => 'order_paid_title',
                    'field_title' => __('Title', 'push'),
                    'field_type' => 'extended_text',
                    'default_value' => '',
                    'section' => 'push_on_order_paid',
                ),
                array(
                    'field_name' => 'order_paid_message',
                    'field_title' => __('Message', 'push'),
                    'field_type' => 'extended_textarea',
                    'default_value' => sprintf( __('New order totalling %s with order no %s has been placed.', 'push'), 'ORDER_TOTAL', 'ORDER_ID' ),
                    'field_description' => sprintf(__('Body of the e-mail. You can use following placeholders (%s)', 'push'), 'ORDER_ID, ORDER_TOTAL, DOWNLOAD_URL, BUYER_NAME' ),
                    'section' => 'push_on_order_paid',
                ),
                array(
                    'field_name' => 'order_paid_priority',
                    'field_title' => __('Type / Priority', 'push'),
                    'field_type' => 'extended_select',
                    'function' => '',
                    'default_value' => '',
                    'section' => 'push_on_order_paid',
                    'tag' => 'priority'
                ),
                array(
                    'field_name' => 'order_paid_sound',
                    'field_title' => __('Sound', 'push'),
                    'field_type' => 'extended_select',
                    'default_value' => '',
                    'section' => 'push_on_order_paid',
                    'tag' => 'sound'
                ),
            );

            $push_on_order_cancelled_fields = array(
                array(
                    'field_name' => 'order_cancelled_notification',
                    'field_title' => __('Enable Notification', 'push'),
                    'field_type' => 'extended_radio',
                    'values' => [ 1 => 'Yes', 0 => 'No'],
                    'default_value' => '',
                    'section' => 'push_on_order_cancelled',
                ),
                array(
                    'field_name' => 'order_cancelled_title',
                    'field_title' => __('Title', 'push'),
                    'field_type' => 'extended_text',
                    'default_value' => '',
                    'section' => 'push_on_order_cancelled',
                ),
                array(
                    'field_name' => 'order_cancelled_message',
                    'field_title' => __('Message', 'push'),
                    'field_type' => 'extended_textarea',
                    'default_value' => sprintf( __('New order totalling %s with order no %s has been placed.', 'push'), 'ORDER_TOTAL', 'ORDER_ID' ),
                    'field_description' => sprintf(__('Body of the e-mail. You can use following placeholders (%s)', 'push'), 'ORDER_ID, ORDER_TOTAL, DOWNLOAD_URL, BUYER_NAME' ),
                    'section' => 'push_on_order_cancelled',
                ),
                array(
                    'field_name' => 'order_cancelled_priority',
                    'field_title' => __('Type / Priority', 'push'),
                    'field_type' => 'extended_select',
                    'function' => '',
                    'default_value' => '',
                    'section' => 'push_on_order_cancelled',
                    'tag' => 'priority'
                ),
                array(
                    'field_name' => 'order_cancelled_sound',
                    'field_title' => __('Sound', 'push'),
                    'field_type' => 'extended_select',
                    'default_value' => '',
                    'section' => 'push_on_order_cancelled',
                    'tag' => 'sound'
                ),
            );

            $push_on_order_fraud_fraud = array(
                array(
                    'field_name' => 'order_fraud_notification',
                    'field_title' => __('Enable Notification', 'push'),
                    'field_type' => 'extended_radio',
                    'values' => [ 1 => 'Yes', 0 => 'No'],
                    'default_value' => '',
                    'section' => 'push_on_order_fraud',
                ),
                array(
                    'field_name' => 'order_fraud_title',
                    'field_title' => __('Title', 'push'),
                    'field_type' => 'extended_text',
                    'default_value' => '',
                    'section' => 'push_on_order_fraud',
                ),
                array(
                    'field_name' => 'order_fraud_message',
                    'field_title' => __('Message', 'push'),
                    'field_type' => 'extended_textarea',
                    'default_value' => sprintf( __('New order totalling %s with order no %s has been placed.', 'push'), 'ORDER_TOTAL', 'ORDER_ID' ),
                    'field_description' => sprintf(__('Body of the e-mail. You can use following placeholders (%s)', 'push'), 'ORDER_ID, ORDER_TOTAL, DOWNLOAD_URL, BUYER_NAME' ),
                    'section' => 'push_on_order_fraud',
                ),
                array(
                    'field_name' => 'order_fraud_priority',
                    'field_title' => __('Type / Priority', 'push'),
                    'field_type' => 'extended_select',
                    'function' => '',
                    'default_value' => '',
                    'section' => 'push_on_order_fraud',
                    'tag' => 'priority'
                ),
                array(
                    'field_name' => 'order_fraud_sound',
                    'field_title' => __('Sound', 'push'),
                    'field_type' => 'extended_select',
                    'default_value' => '',
                    'section' => 'push_on_order_fraud',
                    'tag' => 'sound'
                ),
            );

            return array_merge($general_settings_email_fields, $push_on_order_received_fields, $push_on_order_paid_fields, $push_on_order_cancelled_fields, $push_on_order_fraud_fraud);
        }

        /**
         * Load wp_editor
         * @param $field_name
         * @param string $default_value
         */
        function tc_get_pushover_message($field_name, $default_value = '') {
            $tc_pushover_settings = get_option( 'tc_pushover_settings' );
            if (isset($tc_pushover_settings[$field_name])) {
                $value = $tc_pushover_settings[$field_name];
            } else {
                if ($default_value !== '') {
                    $value = $default_value;
                } else {
                    $value = '';
                }
            }
            wp_editor(html_entity_decode(stripcslashes($value)), $field_name, array('textarea_name' => 'tc_pushover[' . $field_name . ']', 'textarea_rows' => 2));
        }
    }
}