<?php

/*
 Plugin Name: Tickera - Pushover Add-on
 Plugin URI: http://tickera.com/
 Description: Send sale notifications to your iOS and Android devices vie pushover.net service
 Author: Tickera.com
 Author URI: http://tickera.com/
 Version: 1.2.2
 Update URI: https://api.freemius.com
 TextDomain: push
 Domain Path: /languages/
 Copyright 2019 Tickera (http://tickera.com/)
*/
if ( !defined( 'ABSPATH' ) ) {
    exit;
}
// Exit if accessed directly
if ( !function_exists( 'pus_fs' ) ) {
    // Create a helper function for easy SDK access.
    function pus_fs() {
        global $pus_fs;
        if ( !isset( $pus_fs ) ) {
            // Activate multisite network integration.
            if ( !defined( 'WP_FS__PRODUCT_3174_MULTISITE' ) ) {
                define( 'WP_FS__PRODUCT_3174_MULTISITE', true );
            }
            // Include Freemius SDK.
            if ( file_exists( dirname( dirname( __FILE__ ) ) . '/tickera-event-ticketing-system/freemius/start.php' ) ) {
                // Try to load SDK from parent plugin folder.
                require_once dirname( dirname( __FILE__ ) ) . '/tickera-event-ticketing-system/freemius/start.php';
            } else {
                if ( file_exists( dirname( dirname( __FILE__ ) ) . '/tickera/freemius/start.php' ) ) {
                    // Try to load SDK from premium parent plugin folder.
                    require_once dirname( dirname( __FILE__ ) ) . '/tickera/freemius/start.php';
                } else {
                    require_once dirname( __FILE__ ) . '/freemius/start.php';
                }
            }
            $pus_fs = fs_dynamic_init( array(
                'id'               => '3174',
                'slug'             => 'pushover',
                'premium_slug'     => 'pushover',
                'type'             => 'plugin',
                'public_key'       => 'pk_e4590e11ef24e0b111e324796a1f5',
                'is_premium'       => true,
                'is_premium_only'  => true,
                'has_paid_plans'   => true,
                'is_org_compliant' => false,
                'parent'           => array(
                    'id'         => '3102',
                    'slug'       => 'tickera-event-ticketing-system',
                    'public_key' => 'pk_7a38a2a075ec34d6221fe925bdc65',
                    'name'       => 'Tickera',
                ),
                'menu'             => array(
                    'first-path' => 'plugins.php',
                    'support'    => false,
                ),
                'is_live'          => true,
            ) );
        }
        return $pus_fs;
    }

}
function pus_fs_is_parent_active_and_loaded() {
    // Check if the parent's init SDK method exists.
    return function_exists( 'Tickera\\tets_fs' );
}

function pus_fs_is_parent_active() {
    $active_plugins = get_option( 'active_plugins', array() );
    if ( is_multisite() ) {
        $network_active_plugins = get_site_option( 'active_sitewide_plugins', array() );
        $active_plugins = array_merge( $active_plugins, array_keys( $network_active_plugins ) );
    }
    foreach ( $active_plugins as $basename ) {
        if ( 0 === strpos( $basename, 'tickera-event-ticketing-system/' ) || 0 === strpos( $basename, 'tickera/' ) ) {
            return true;
        }
    }
    return false;
}

function pus_fs_init() {
    if ( pus_fs_is_parent_active_and_loaded() ) {
        // Parent is active, add your init code here.
        // Init Freemius.
        pus_fs();
        if ( !pus_fs()->can_use_premium_code() ) {
            return;
        }
    } else {
        // Parent is inactive, add your error handling here.
    }
}

if ( pus_fs_is_parent_active_and_loaded() ) {
    // If parent already included, init add-on.
    pus_fs_init();
} else {
    if ( pus_fs_is_parent_active() ) {
        // Init add-on only after the parent is loaded.
        add_action( 'tets_fs_loaded', 'pus_fs_init' );
    } else {
        // Even though the parent is not activated, execute add-on for activation / uninstall hooks.
        pus_fs_init();
    }
}
if ( !class_exists( 'TC_Pushover' ) ) {
    class TC_Pushover {
        var $version = '1.1.8';

        var $title = 'Pushover';

        var $name = 'tc_pushover';

        var $dir_name = 'pushover';

        var $location = 'plugins';

        var $plugin_dir = '';

        var $plugin_url = '';

        var $language;

        /**
         * Initialize Actions and Filters
         */
        function __construct() {
            $this->init_vars();
            add_action( 'activated_plugin', array($this, 'plugin_dependencies'), 99 );
            require_once $this->plugin_dir . 'includes/classes/class.settings_pushover.php';
            // Check if Tickera plugin is active / main Ticekra class exists
            if ( class_exists( 'Tickera\\TC' ) ) {
                global $tc;
                add_filter(
                    'tc_settings_new_menus',
                    array(&$this, 'tc_settings_new_menus'),
                    10,
                    1
                );
                add_action( 'tc_settings_menu_pushover', array(&$this, 'tc_settings_menu_pushover') );
                add_filter( 'tc_admin_capabilities', array(&$this, 'append_capabilities') );
                add_filter( 'tc_staff_capabilities', array(&$this, 'append_capabilities') );
                add_action(
                    'tc_order_created',
                    array(&$this, 'send_pushover_notification'),
                    999,
                    5
                );
                add_action(
                    'tc_order_updated_status_to_paid',
                    array(&$this, 'send_pushover_notification'),
                    999,
                    5
                );
                add_action(
                    'tc_order_paid_change',
                    array(&$this, 'send_pushover_notification'),
                    999,
                    5
                );
                add_action(
                    'save_post',
                    array($this, 'save_orders_meta'),
                    999,
                    1
                );
            }
            add_filter(
                'tc_delete_info_plugins_list',
                array($this, 'tc_delete_info_plugins_list'),
                10,
                1
            );
            add_action(
                'tc_delete_plugins_data',
                array($this, 'tc_delete_plugins_data'),
                10,
                1
            );
            add_action( 'init', array(&$this, 'localization'), 10 );
            add_action( 'admin_enqueue_scripts', array(&$this, 'enqueue_scripts') );
        }

        /**
         * Plugin localization function.
         * Load up the localization file if we're using WordPress in a different language.
         * Place it in this plugin's "languages" folder and name it "tc-[value in wp-config].mo".
         */
        function localization() {
            if ( $this->location == 'mu-plugins' ) {
                load_muplugin_textdomain( 'push', 'languages/' );
            } elseif ( $this->location == 'subfolder-plugins' ) {
                load_plugin_textdomain( 'push', false, dirname( plugin_basename( __FILE__ ) ) . '/languages/' );
            } elseif ( $this->location == 'plugins' ) {
                load_plugin_textdomain( 'push', false, 'languages/' );
            }
            $temp_locales = explode( '_', get_locale() );
            $this->language = ( $temp_locales[0] ? $temp_locales[0] : 'en' );
        }

        /**
         * Load this plugin the very last to ensure all the dependencies loaded first.
         */
        function plugin_dependencies() {
            $plugin_slug = basename( __DIR__ ) . '/' . basename( __FILE__ );
            $active_plugins = get_option( 'active_plugins', [] );
            $index = array_search( $plugin_slug, $active_plugins );
            if ( $index !== false ) {
                unset($active_plugins[$index]);
                $active_plugins[] = $plugin_slug;
                update_option( 'active_plugins', array_values( $active_plugins ) );
            }
        }

        /**
         * @param $plugins
         * @return mixed
         */
        function tc_delete_info_plugins_list( $plugins ) {
            $plugins[$this->name] = $this->title;
            return $plugins;
        }

        /**
         * @param $submitted_data
         */
        function tc_delete_plugins_data( $submitted_data ) {
            if ( array_key_exists( $this->name, $submitted_data ) ) {
                global $wpdb;
                // Delete options
                $options = array('tc_pushover_settings');
                foreach ( $options as $option ) {
                    delete_option( $option );
                }
            }
        }

        /**
         * Initialize Variables.
         * Setup proper directories
         */
        function init_vars() {
            if ( defined( 'WP_PLUGIN_URL' ) && defined( 'WP_PLUGIN_DIR' ) && file_exists( WP_PLUGIN_DIR . '/' . $this->dir_name . '/' . basename( __FILE__ ) ) ) {
                $this->location = 'subfolder-plugins';
                $this->plugin_dir = WP_PLUGIN_DIR . '/' . $this->dir_name . '/';
                $this->plugin_url = plugins_url( '/', __FILE__ );
            } elseif ( defined( 'WP_PLUGIN_URL' ) && defined( 'WP_PLUGIN_DIR' ) && file_exists( WP_PLUGIN_DIR . '/' . basename( __FILE__ ) ) ) {
                $this->location = 'plugins';
                $this->plugin_dir = WP_PLUGIN_DIR . '/';
                $this->plugin_url = plugins_url( '/', __FILE__ );
            } elseif ( is_multisite() && defined( 'WPMU_PLUGIN_URL' ) && defined( 'WPMU_PLUGIN_DIR' ) && file_exists( WPMU_PLUGIN_DIR . '/' . basename( __FILE__ ) ) ) {
                $this->location = 'mu-plugins';
                $this->plugin_dir = WPMU_PLUGIN_DIR;
                $this->plugin_url = WPMU_PLUGIN_URL;
            } else {
                wp_die( sprintf( __( 'There was an issue determining where %s is installed. Please reinstall it.', 'push' ), $this->title ) );
            }
        }

        /**
         * Load CSS and JS Files
         */
        function enqueue_scripts() {
            wp_enqueue_style( 'css-pushover', plugins_url( 'assets/css/pushover.css', __FILE__ ) );
        }

        /**
         * Include Pushover Configuration on Tickera Settings Page
         */
        function tc_settings_menu_pushover() {
            include $this->plugin_dir . 'includes/admin-pages/pushover_settings.php';
        }

        /**
         * Include Pushover Menu at Tickera Settings Page Sidebar
         * @param $menus
         * @return mixed
         */
        function tc_settings_new_menus( $menus ) {
            $menus['pushover'] = __( 'Push Notifications', 'cp' );
            return $menus;
        }

        /**
         * Add additional capabilities to staff and admins
         * @param $capabilities
         * @return mixed
         */
        function append_capabilities( $capabilities ) {
            $capabilities['manage_' . $this->name . '_cap'] = 1;
            return $capabilities;
        }

        /**
         * Execute sending of messages based on Enabled Status Notification
         * @param $order_id
         * @param $status
         * @param $cart_contents
         * @param $cart_info
         * @param $payment_info
         * @return bool
         */
        function send_pushover_notification(
            $order_id,
            $status,
            $cart_contents,
            $cart_info,
            $payment_info
        ) {
            global $tc;
            // Executes per enabled notifications
            $tc_pushover_settings = get_option( 'tc_pushover_settings' );
            if ( $tc_pushover_settings && isset( $tc_pushover_settings[$status . '_notification'] ) && $tc_pushover_settings[$status . '_notification'] ) {
                $api_key = $tc_pushover_settings['api_key'];
                $user_key = $tc_pushover_settings['user_key'];
                $device = $tc_pushover_settings['device'];
                $message_title = $tc_pushover_settings[$status . '_title'];
                $message = $tc_pushover_settings[$status . '_message'];
                $priority = $tc_pushover_settings[$status . '_priority'];
                $sound = $tc_pushover_settings[$status . '_sound'];
            } else {
                return false;
            }
            // Order Object
            $order_id = ( !is_int( $order_id ) ? tickera_get_order_id_by_name( $order_id )->ID : $order_id );
            $order = new Tickera\TC_Order($order_id);
            // Initialized Order Variables
            $cart_contents = ( !$cart_contents ? $order->details->tc_cart_contents : $cart_contents );
            $cart_info = ( !$cart_info ? $order->details->tc_cart_info : $cart_info );
            $payment_info = ( !$payment_info ? $order->details->tc_payment_info : $payment_info );
            // Download URL
            $order_status_url = $tc->tc_order_status_url(
                $order,
                $order->details->tc_order_date,
                '',
                false
            );
            // Buyer Data
            $buyer_data = ( isset( $cart_info['buyer_data'] ) ? $cart_info['buyer_data'] : $cart_info[0]['buyer_data'] );
            $buyer_name = $buyer_data['first_name_post_meta'] . ' ' . $buyer_data['last_name_post_meta'];
            // Payment Total
            $payment_total = ( isset( $payment_info['total'] ) ? $payment_info['total'] : $payment_info[0]['total'] );
            $placeholders = array(
                'ORDER_ID',
                'ORDER_TOTAL',
                'DOWNLOAD_URL',
                'BUYER_NAME'
            );
            $placeholder_values = array(
                $order->details->post_title,
                apply_filters( 'tc_cart_currency_and_format', $payment_total ),
                $order_status_url,
                $buyer_name
            );
            // Replace placeholders with values
            $message = str_replace( $placeholders, $placeholder_values, $message );
            require_once $this->plugin_dir . 'includes/Pushover.php';
            // Load PHP service wrapper for the pushover.net
            $push = new Pushover();
            $push->setToken( $api_key );
            $push->setUser( $user_key );
            $push->setTitle( $message_title );
            $push->setDevice( $device );
            $push->setPriority( $priority );
            $push->setTimestamp( time() );
            $push->setSound( $sound );
            do_action( 'tc_before_pushover_send' );
            $push->setMessage( apply_filters( 'tc_pushover_message', $message ) );
            $push->send();
            do_action( 'tc_pushover_order_created' );
        }

        /**
         * Execute Pushover on Better Order Update Status
         * @param $post_id
         */
        function save_orders_meta( $post_id ) {
            if ( !isset( $_POST['order_status_change'] ) || get_post_type( $post_id ) !== 'tc_orders' ) {
                //Make sure the edit comes from the order details page
                return;
            }
            $current_status = sanitize_text_field( $_POST['original_post_status'] );
            $updated_status = sanitize_text_field( $_POST['order_status_change'] );
            $cart_contents = get_post_meta( $post_id, 'tc_cart_contents', false );
            $cart_info = get_post_meta( $post_id, 'tc_cart_info', false );
            $payment_info = get_post_meta( $post_id, 'tc_payment_info', false );
            // Only executes when status has been updated
            $trigger_statuses = array('order_cancelled', 'order_fraud', 'order_received');
            if ( in_array( $updated_status, $trigger_statuses ) && $current_status != $updated_status ) {
                self::send_pushover_notification(
                    $post_id,
                    $updated_status,
                    $cart_contents,
                    $cart_info,
                    $payment_info
                );
            }
        }

    }

}
/**
 * Allow access in Multisite (Network)
 */
if ( !function_exists( 'is_plugin_active_for_network' ) ) {
    require_once ABSPATH . '/wp-admin/includes/plugin.php';
}
if ( pus_fs_is_parent_active_and_loaded() && pus_fs()->can_use_premium_code() ) {
    if ( is_multisite() && is_plugin_active_for_network( plugin_basename( __FILE__ ) ) ) {
        function tc_pushovar_load() {
            global $tc_pushover;
            $tc_pushover = new TC_Pushover();
        }

        add_action( 'tets_fs_loaded', 'tc_pushovar_load' );
    } else {
        $tc_pushover = new TC_Pushover();
    }
}