import { useBlockProps } from '@wordpress/block-editor';
import { stringConvention } from "../components/functions";

/**
 * Dummy content in block editor
 *
 * @param attributes
 * @param setAttributes
 * @returns {JSX.Element}
 * @constructor
 */
export const Edit = ({ attributes, setAttributes }) => {
	const blockProps = useBlockProps();
	return (
		<div {...blockProps} style={{ display: 'block' }}>
			<div>
				<h4>{tc_woobridge_block.general_admission}</h4>
				<div>
					<h5>{ "1. " + tc_woobridge_block.attendee_info }</h5>
					<div className={ 'wc-block-components-text-input is-active' }>
						<input type="text"/>
						<label>{ stringConvention( tc_woobridge_block.first_name ) }</label>
					</div>
					<div className={ 'wc-block-components-text-input is-active' }>
						<input type="text"/>
						<label>{ stringConvention( tc_woobridge_block.last_name ) }</label>
					</div>
					<div className={ 'wc-block-components-text-input is-active' }>
						<input type="text"/>
						<label>{ stringConvention( tc_woobridge_block.email_address ) }</label>
					</div>
				</div>
			</div>
		</div>
	);
};

export const Save = ({ attributes }) => {
	return ( <div {...useBlockProps.save()}></div> );
};
