<?php
$tc_checkinera_settings = get_option( 'tc_checkinera_settings' );
if ( isset( $tc_checkinera_settings[ 'enable_toolbar' ] ) && 'yes' == $tc_checkinera_settings[ 'enable_toolbar' ] ) {
    // include_once( 'layout-toolbar.php' );
}
?>
<div class="tc-login">
    <div class="tc-login-wrap">
        <div class="tc-notification"><!--error, info, warning and success messages goes here--></div>
        <?php
        $tc_logo_image = ( ! isset( $tc_checkinera_settings[ 'app_logo_checkinera' ] ) )
            ? trailingslashit( $plugin_url ) . 'assets/images/tickera-logo.png'
            : $tc_checkinera_settings[ 'app_logo_checkinera' ];

        $prefill_url = ( isset( $tc_checkinera_settings[ 'prefill_url' ] ) && 'yes' == $tc_checkinera_settings[ 'prefill_url' ] ) ? true : false;
        ?>
        <form id="tc_login_form">
            <?php
            if ( ! chk_fs()->can_use_premium_code() ) : ?>
                <p style="text-align: center; font-size: 20px; color: #fff;"><?php _e( 'Please activate the valid license.', 'tc_ch' ); ?></p>
            <?php else :
                $translation = apply_filters( 'tc_translation_data_output', [] );
                ?>
                <div class="tc-login-logo"><img src="<?php echo $tc_logo_image; ?>"/></div>
                <div class="tc-login-input-wrap<?php echo $prefill_url ? ' tc-hidden' : ''; ?>">
                    <label for="tc-website-url">
                        <span class="WORDPRESS_INSTALLATION_URL"><?php echo isset( $translation[ 'WORDPRESS_INSTALLATION_URL' ] ) ? $translation[ 'WORDPRESS_INSTALLATION_URL' ] : 'WORDPRESS INSTALLATION URL'; ?></span>
                    </label>
                    <input type="<?php echo $prefill_url ? 'hidden' : 'text'; ?>" id="tc-website-url" data-prefill="<?php echo $prefill_url ? 'true' : 'false'; ?>" placeholder="http://www.website.com/" <?php echo $prefill_url ? ' value="' . esc_url( trailingslashit( site_url() ) ) . '"' : ''; ?>/>
                </div>
                <div class="tc-login-input-wrap">
                    <label for="tc-api-key"><span class="API_KEY"><?php echo isset( $translation[ 'API_KEY' ] ) ? $translation[ 'API_KEY' ] : 'API KEY'; ?></span></label>
                    <input type="password" id="tc-api-key"/>
                </div>
                <div class="tc-auto-login">
                    <label>
                        <span class="login-text AUTO_LOGIN"><?php echo isset( $translation[ 'AUTO_LOGIN' ] ) ? $translation[ 'AUTO_LOGIN' ] : 'AUTO LOGIN'; ?></span>
                        <input type="checkbox" id="auto-login">
                        <span class="tc-login-image">
                            <span class="tc-login-ball"></span>
                        </span>
                    </label>
                </div>
                <button class="tc-login-button SIGN_IN"><?php echo isset( $translation[ 'SIGN_IN' ] ) ? $translation[ 'SIGN_IN' ] : 'SIGN IN'; ?></button>
            <?php endif; ?>
        </form>
    </div>
</div>
