<?php
function tc_get_posts_and_pages( $field_name = '', $post_id = '' ) {

    $currently_selected = ( $post_id !== '' ) ? get_post_meta( $post_id, $field_name, true ) : '';

    $args = apply_filters( 'tc_get_posts_and_pages_args', array(
        'posts_per_page' => -1,
        'orderby' => 'date',
        'order' => 'DESC',
        'post_type' => array( 'post', 'page' ),
        'post_status' => 'publish',
        'suppress_filters' => true
    ) );

    $posts = get_posts( $args );
    ?>
    <select name="<?php echo $field_name; ?>_post_meta">
        <option value=""><?php _e( 'None', 'ec' ); ?></option>
        <?php foreach ( $posts as $post ) { ?>
            <option value="<?php echo $post->ID; ?>" <?php selected( $currently_selected, $post->ID, true ); ?>><?php echo $post->post_title; ?></option>
        <?php } ?>
    </select>
    <?php
}

function tc_get_calendar_color_schemes() {

    global $tc_event_calendar;

    $color_schemes = array(
        'default' => array(
            'name' => __( 'Default', 'ec' ),
            'url' => '',
            'colors' => array( '#ffffff', '#fcf8e3', '#3a87ad' )
        ),
        'blue' => array(
            'name' => __( 'Blue', 'ec' ),
            'url' => $tc_event_calendar->plugin_url . 'includes/css/blue.css',
            'colors' => array( '#3498db', '#3486BD', '#50A9E4' )
        ),
        'dark' => array(
            'name' => __( 'Dark', 'ec' ),
            'url' => $tc_event_calendar->plugin_url . 'includes/css/dark.css',
            'colors' => array( '#2c3e50', '#3B4E61', '#2980b9' )
        ),
        'flat' => array(
            'name' => __( 'Flat', 'ec' ),
            'url' => $tc_event_calendar->plugin_url . 'includes/css/flat.css',
            'colors' => array( '#1abc9c', '#16a085', '#179078' )
        ),
        'orange' => array(
            'name' => __( 'Orange', 'ec' ),
            'url' => $tc_event_calendar->plugin_url . 'includes/css/orange.css',
            'colors' => array( '#e67e22', '#CC6B2C', '#EF8E38' )
        ),
        'red' => array(
            'name' => __( 'Red', 'ec' ),
            'url' => $tc_event_calendar->plugin_url . 'includes/css/red.css',
            'colors' => array( '#e74c3c', '#EF5C4D', '#CA3F30' )
        ),
    );

    return apply_filters( 'tc_calendar_color_schemes', $color_schemes );
}

function show_tc_calendar_attributes() { ?>
    <table id="tc-calendar-shortcode" class="shortcode-table" style="display:none">
        <tr>
            <th scope="row"><?php _e( 'Select a calendar theme', 'ec' ); ?></th>
            <td>
                <?php
                $color_schemes = tc_get_calendar_color_schemes();
                $selected = 0;
                foreach ( $color_schemes as $color_scheme => $color_scheme_info ) { ?>
                    <div class="color-option">
                        <input name="color_scheme" id="admin_color_<?php echo esc_attr( $color_scheme ); ?>" type="radio" value="<?php echo $color_scheme; ?>" class="tog" <?php echo $selected == 0 ? 'checked="checked"' : ''; ?>>
                        <label for="admin_color_<?php echo esc_attr( $color_scheme ); ?>"><?php echo esc_attr( $color_scheme_info[ 'name' ] ); ?></label>
                        <table class="color-palette">
                            <tbody>
                            <?php foreach ( $color_scheme_info[ 'colors' ] as $color ) { ?>
                                <tr><td style="background-color: <?php echo $color; ?>">&nbsp;</td></tr>
                            <?php } ?>
                            </tbody>
                        </table>
                    </div>

                    <?php
                    $selected++;
                } ?>
            </td>
        </tr>
        <tr>
            <th scope="row"><?php _e( 'Calendar Width', 'ec' ); ?></th>
            <td>
                <select name="width">
                    <option value="default"><?php _e( 'Default', 'ec' ) ?></option>
                    <option value="wide"><?php _e( 'Wide', 'ec' ) ?></option>
                    <option value="full"><?php _e( 'Full', 'ec' ) ?></option>
                </select>
            </td>
        </tr>
        <tr>
            <th scope="row"><?php _e( 'Select calendar language', 'ec' ); ?></th>
            <td>
                <select name="lang">
                    <option value="en" selected="selected"><?php _e( 'English', 'ec' ) ?></option>
                    <option value="ar-ma"><?php _e( 'Arabic (Morocco)', 'ec' ) ?></option>
                    <option value="ar-sa"><?php _e( 'Arabic (Saudi Arabia)', 'ec' ) ?></option>
                    <option value="ar-tn"><?php _e( 'Arabic (Tunisia)', 'ec' ) ?></option>
                    <option value="ar"><?php _e( 'Arabic', 'ec' ) ?></option>
                    <option value="bg"><?php _e( 'Bulgarian', 'ec' ) ?></option>
                    <option value="ca"><?php _e( 'Catalan', 'ec' ) ?></option>
                    <option value="cs"><?php _e( 'Czech', 'ec' ) ?></option>
                    <option value="da"><?php _e( 'Danish', 'ec' ) ?></option>
                    <option value="de-at"><?php _e( 'German (Austria)', 'ec' ) ?></option>
                    <option value="de"><?php _e( 'German', 'ec' ) ?></option>
                    <option value="el"><?php _e( 'Greek', 'ec' ) ?></option>
                    <option value="en-au"><?php _e( 'English (Australia)', 'ec' ) ?></option>
                    <option value="en-ca"><?php _e( 'English (Canada)', 'ec' ) ?></option>
                    <option value="en-gb"><?php _e( 'English (United Kingdom)', 'ec' ) ?></option>
                    <option value="es"><?php _e( 'Spanish', 'ec' ) ?></option>
                    <option value="fi"><?php _e( 'Finnish', 'ec' ) ?></option>
                    <option value="fr-ca"><?php _e( 'French (Canada)', 'ec' ) ?></option>
                    <option value="fr"><?php _e( 'French', 'ec' ) ?></option>
                    <option value="he"><?php _e( 'Hebrew', 'ec' ) ?></option>
                    <option value="hi"><?php _e( 'Hindi (India)', 'ec' ) ?></option>
                    <option value="hr"><?php _e( 'Croatian', 'ec' ) ?></option>
                    <option value="hu"><?php _e( 'Hungarian', 'ec' ) ?></option>
                    <option value="id"><?php _e( 'Indonesian', 'ec' ) ?></option>
                    <option value="is"><?php _e( 'Icelandic', 'ec' ) ?></option>
                    <option value="it"><?php _e( 'Italian', 'ec' ) ?></option>
                    <option value="ja"><?php _e( 'Japanese', 'ec' ) ?></option>
                    <option value="ko"><?php _e( 'Korean', 'ec' ) ?></option>
                    <option value="lt"><?php _e( 'Lithuanian', 'ec' ) ?></option>
                    <option value="lv"><?php _e( 'Latvian', 'ec' ) ?></option>
                    <option value="nb"><?php _e( 'Norwegian Bokmål (Norway)', 'ec' ) ?></option>
                    <option value="nl"><?php _e( 'Dutch', 'ec' ) ?></option>
                    <option value="pl"><?php _e( 'Polish', 'ec' ) ?></option>
                    <option value="pt-br"><?php _e( 'Portuguese (Brazil)', 'ec' ) ?></option>
                    <option value="pt"><?php _e( 'Portuguese', 'ec' ) ?></option>
                    <option value="ro"><?php _e( 'Romanian', 'ec' ) ?></option>
                    <option value="ru"><?php _e( 'Russian', 'ec' ) ?></option>
                    <option value="sk"><?php _e( 'Slovak', 'ec' ) ?></option>
                    <option value="sl"><?php _e( 'Slovenian', 'ec' ) ?></option>
                    <option value="sr-cyrl"><?php _e( 'Serbian Cyrillic', 'ec' ) ?></option>
                    <option value="sr"><?php _e( 'Serbian', 'ec' ) ?></option>
                    <option value="sv"><?php _e( 'Swedish', 'ec' ) ?></option>
                    <option value="th"><?php _e( 'Thai', 'ec' ) ?></option>
                    <option value="tr"><?php _e( 'Turkish', 'ec' ) ?></option>
                    <option value="uk"><?php _e( 'Ukrainian', 'ec' ) ?></option>
                    <option value="vi"><?php _e( 'Vietnamese', 'ec' ) ?></option>
                    <option value="zh-cn"><?php _e( 'Chinese (China)', 'ec' ) ?></option>
                    <option value="zh-tw"><?php _e( 'Chinese (Taiwan)', 'ec' ) ?></option>
                </select>
            </td>
        </tr>
        <tr>
            <th scope="row"><?php _e( 'Grid View', 'ec' ); ?></th>
            <td>
                <select name="grid_view">
                    <option value="monthly"><?php _e( 'Monthly', 'ec' ) ?></option>
                    <option value="weekly"><?php _e( 'Weekly', 'ec' ) ?></option>
                    <option value="daily"><?php _e( 'Daily', 'ec' ) ?></option>
                </select>
            </td>
        </tr>
        <tr>
            <th scope="row"><?php _e( 'First Day', 'ec' ); ?></th>
            <td>
                <select name="first_day">
                    <option value="0"><?php _e( 'Sunday', 'ec' ) ?></option>
                    <option value="1"><?php _e( 'Monday', 'ec' ) ?></option>
                    <option value="2"><?php _e( 'Tuesday', 'ec' ) ?></option>
                    <option value="3"><?php _e( 'Wednesday', 'ec' ) ?></option>
                    <option value="4"><?php _e( 'Thursday', 'ec' ) ?></option>
                    <option value="5"><?php _e( 'Friday', 'ec' ) ?></option>
                    <option value="6"><?php _e( 'Saturday', 'ec' ) ?></option>
                </select>
            </td>
        </tr>
        <tr>
            <th scope="row"><?php _e( 'Default Month', 'ec' ); ?></th>
            <td>
                <input type="text" class="regular-text" id="tc_calendar_default_month" name="default_month">
            </td>
        </tr>
        <tr>
            <th scope="row"><?php _e( 'Show/Hide Past Events', 'ec' ); ?></th>
            <td>
                <input name="show_past_events" id="tc_show_past_events_yes" type="radio" checked value="yes" class="tog">
                <label for="tc_show_past_events_yes"><?php _e( 'Show Past Events', 'ec' ) ?> </label>
                <input name="show_past_events" id="tc_hide_past_events_no" type="radio" value="no" class="tog">
                <label for="tc_hide_past_events_no"><?php _e( 'Hide Past Events', 'ec' ) ?></label>
            </td>
        </tr>
        <tr>
            <th scope="row"><?php _e( 'Show events for categories', 'ec' ); ?></th>
            <td>
                <?php
                $taxonomia = array(
                    'post_tag',
                    'my_tax',
                );

                $args = array(
                    'orderby' => 'name',
                    'order' => 'ASC',
                    'hide_empty' => true,
                    'exclude' => array(),
                    'exclude_tree' => array(),
                    'include' => array(),
                    'number' => '',
                    'fields' => 'all',
                    'slug' => '',
                    'parent' => '',
                    'hierarchical' => true,
                    'child_of' => 0,
                    'childless' => false,
                    'get' => '',
                    'name__like' => '',
                    'description__like' => '',
                    'pad_counts' => false,
                    'offset' => '',
                    'search' => '',
                    'cache_domain' => 'core'
                );

                $terms = get_terms( array(
                    'taxonomy' => 'event_category',
                    'hide_empty' => false,
                ) );

                foreach ( $terms as $term ) { ?>
                    <label><?php echo $term->name; ?>
                        <input name="et_<?php echo esc_attr( $term->term_id ); ?>" type="checkbox" checked value="1"/>
                    </label>
                <?php } ?>
                <p><?php _e( 'Note: If none selected, all events will be visible.', 'ec' ); ?></p>
            </td>
        </tr>
        <!-- show event calendar image -->
        <!-- <tr>
            <th scope="row"><?php // _e( 'Event image', 'ec' ); ?></th>
            <td>
                <input name="tc_display_popup_title" id="tc_display_popup_title" type="checkbox" checked value="1">
                <label for="tc_display_popup_title"><?php // _e( 'Display Title and Image Background On Hover', 'ec' ) ?></label>
            </td>
        </tr> -->
    </table>
    <?php
}
?>
