<?php
$settings = get_option( 'tc_atteende_keep_selection' );
$settings = is_array( $settings ) ? $settings : maybe_unserialize( $settings );
?>
<div class="wrap tc_wrap tc_csv_export">
    <div id="poststuff" class="metabox-holder tc-settings">
        <form id="tc_form_attendees_csv_export" method="post">
            <input type="hidden" name="action" value="tc_export_attendee_list" />
            <input type="hidden" name="page_num" id="page_num" value="1" />
            <div id="store_settings" class="postbox">
                <h3><span><?php _e('Attendee List (CSV Export)', 'tccsv'); ?></span></h3>
                <div class="inside">
                    <table class="form-table">
                        <tbody>
                        <tr valign="top">
                            <th scope="row">
                                <label for="tc_export_csv_event_data"><?php _e('Event', 'tccsv'); ?></label>
                                <p>
                                    <?php _e('Select an event you wish to export CSV file for', 'tccsv'); ?>
                                </p>
                            </th>
                            <td class="regular-text">
                                <?php
                                    $wp_events_search = new Tickera\TC_Events_Search( '', '', -1 );
                                    $selected_event_ids = isset( $settings[ 'tc_export_csv_event_data' ] ) ? $settings[ 'tc_export_csv_event_data' ] : [ 'all' ];
                                ?>
                                <select name="tc_export_csv_event_data[]" id="tc_export_csv_event_data" multiple>
                                    <option value="all" <?php selected( in_array( 'all', $selected_event_ids ), true, true ); ?>><?php esc_html_e( 'All', 'tccsv' ) ?></option>
                                    <?php foreach ($wp_events_search->get_results() as $event) :
                                        $event_obj = new Tickera\TC_Event($event->ID);
                                        $event_object = $event_obj->details;
                                        $event_date = $event_obj->get_event_date(); ?>
                                        <option value="<?php echo $event_object->ID; ?>" <?php selected( in_array( $event->ID, $selected_event_ids ), true, true ); ?>><?php echo apply_filters( 'tc_csv_event_name', $event_object->post_title . ' (' . $event_date . ')', $event_object ); ?></option>
                                    <?php endforeach; ?>
                                </select>
                                <?php ?>
                            </td>
                        </tr>
                        <!-- added ticket type -->
                        <?php if ( ! apply_filters( 'tc_export_skip_ticket_type_filter', false ) ) : ?>
                            <tr valign="top">
                                <th scope="row">
                                    <label for="tc_export_csv_ticket_type_data"><?php _e('Ticket Type', 'tccsv'); ?></label>
                                    <p>
                                        <?php _e('Select a ticket type you wish to export CSV file for', 'tccsv'); ?>
                                    </p>
                                </th>
                                <td class="regular-text">
                                    <?php
                                    global $wpdb; ?>
                                    <select name="tc_export_csv_ticket_type_data[]" id="tc_export_csv_ticket_type_data" multiple>
                                        <?php
                                            $selected_ticket_type_ids = isset( $settings[ 'tc_export_csv_ticket_type_data' ] ) ? $settings[ 'tc_export_csv_ticket_type_data' ] : [ 'all' ];
                                        ?>
                                        <option <?php selected( in_array( 'all', $selected_ticket_type_ids ), true, true ); ?> value="all"><?php _e( 'All', 'tccsv' ); ?></option>
                                        <?php if ( isset( $settings[ 'tc_export_csv_event_data' ] ) ) :

                                            $event_name = ( apply_filters( 'tc_bridge_for_woocommerce_is_active', false ) == true )
                                                ? '_event_name'
                                                : 'event_name';

                                            if ( in_array( 'all', $settings[ 'tc_export_csv_event_data' ] ) ) {
                                                $events_search = new Tickera\TC_Events_Search( '', '', -1 );
                                                $event_ids = wp_list_pluck( $events_search->get_results(), 'ID' );

                                            } else {
                                                $event_ids = $settings[ 'tc_export_csv_event_data' ];
                                            }

                                            $ticket_types = get_posts( [
                                                'post_type' => ( ! apply_filters( 'tc_bridge_for_woocommerce_is_active', false ) ) ? 'tc_tickets' : 'product',
                                                'post_status' => 'any',
                                                'meta_key' => $event_name,
                                                'meta_value' => $event_ids,
                                                'posts_per_page' => -1
                                            ]);
                                            ?>
                                            <?php foreach ( $ticket_types as $ticket_type ) :
                                                $ticket_id = $ticket_type->ID;
                                                $ticket_title = $ticket_type->post_title; ?>
                                                <option value="<?php echo (int) $ticket_id;?>" <?php selected( in_array( $ticket_id, $selected_ticket_type_ids ), true, true ); ?>><?php echo esc_html( $ticket_title );?></option>
                                            <?php endforeach; ?>
                                        <?php endif; ?>
                                    </select>
                                </td>
                            </tr>
                        <?php endif; ?>
                        <!-- added ticket type -->
                        <!--export from-to date-->
                        <tr valign="top">
                            <th scope="row">
                                <label for="tc_list_from"><?php _e('Date range', 'tccsv'); ?></label>
                                <p>
                                    <?php _e('Select a date range or a single date to export CSV for', 'tccsv'); ?>
                                </p>
                            </th>
                            <td>
                                <label class="tc-calendar-field-title"><?php _e('From', 'tccsv'); ?></label><br />
                                <input type="text" name='tc_list_from' class="tc_date_field" value='<?php echo esc_attr( ( isset( $settings[ 'tc_list_from' ] ) ? $settings[ 'tc_list_from' ] : '' ) ) ?>' />
                            </td>
                            <td>
                                <label class="tc-calendar-field-title"><?php _e('To', 'tccsv'); ?></label><br />
                                <input type="text" name='tc_list_to' class="tc_date_field" value='<?php echo esc_attr( ( isset( $settings[ 'tc_list_to' ] ) ? $settings[ 'tc_list_to' ] : '' ) ) ?>' />
                            </td>
                        </tr>
                        <!--export from-to date end-->
                        <tr valign="top">
                            <th scope="row">
                                <label for="attendee_export_field"><?php _e('Show Columns', 'tccsv'); ?></label>
                                <p>
                                    <?php _e('Select which information to include in the CSV', 'tccsv'); ?>
                                </p>
                            </th>
                            <td>
                                <fieldset>
                                    <?php
                                    $csv_fields = apply_filters( 'tc_csv_admin_fields', array (
                                            'col_event_name' => __( 'Event Name', 'tccsv' ),
                                            'col_buyer_first_name' => __( 'Buyer First Name', 'tccsv' ),
                                            'col_buyer_last_name' => __( 'Buyer Last Name', 'tccsv' ),
                                            'col_buyer_name' => __( 'Buyer Full Name', 'tccsv' ),
                                            'col_buyer_email' => __( 'Buyer Email', 'tccsv' ),
                                            'col_owner_first_name' => __( 'Attendee First Name', 'tccsv' ),
                                            'col_owner_last_name' => __( 'Attendee Last Name', 'tccsv' ),
                                            'col_owner_name' => __( 'Attendee Full Name', 'tccsv' ),
                                            'col_owner_email' => __( 'Attendee E-mail', 'tccsv' ),
                                            'col_payment_date' => __( 'Payment Date', 'tccsv' ),
                                            'col_payment_gateway' => __( 'Payment Gateway', 'tccsv' ),
                                            'col_order_number' => __( 'Order Number', 'tccsv' ),
                                            'col_order_total' => __( 'Order Total', 'tccsv' ),
                                            'col_order_total_once' => __( 'Order Total (Shown Once)', 'tccsv' ),
                                            'col_ticket_subtotal' => __( 'Ticket Subtotal', 'tccsv' ),
                                            'col_ticket_fee' => __( 'Ticket Fee', 'tccsv' ),
                                            'col_ticket_discount' => __( 'Ticket Discount', 'tccsv' ),
                                            'col_ticket_tax' => __( 'Ticket Tax', 'tccsv' ),
                                            'col_ticket_total' => __( 'Ticket Total', 'tccsv' ),
                                            'col_order_status' => __( 'Order Status', 'tccsv' ),
                                            'col_discount_code' => __( 'Discount Code', 'tccsv' ),
                                            'col_ticket_id' => __( 'Ticket Code', 'tccsv' ),
                                            'col_ticket_instance_id' => __( 'Ticket ID', 'tccsv' ),
                                            'col_ticket_type' => __( 'Ticket Type', 'tccsv' ),
                                            'col_ticket_download_url' => __( 'Ticket Download Url', 'tccsv' ),
                                            'col_checked_in' => __( 'Checked-in', 'tccsv' ),
                                            'col_checkins' => __( 'Check-ins', 'tccsv' ),
                                            'col_checkouts' => __( 'Check-outs', 'tccsv' ),
                                            'col_owner_api_key' => __( 'Api Key', 'tccsv' ),
                                            'col_order_price' => __( 'Price', 'tccsv' ),
                                            'col_order_notes' => __( 'Order Notes', 'tccsv' )
                                        )
                                    );

                                    $csv_checked_by_default = apply_filters( 'tc_csv_checked_fields', ( $settings ? array_keys( $settings ) : [
                                        'col_event_name',
                                        'col_owner_name',
                                        'col_owner_email',
                                        'col_order_number',
                                        'col_ticket_id',
                                        'col_ticket_instance_id',
                                        'col_ticket_type',
                                        'col_buyer_name',
                                        'col_buyer_email',
                                        'col_owner_phone_number',
                                        'col_buyer_phone_number',
                                    ]) );

                                    foreach ( $csv_fields as $key => $val ) : ?>
                                        <label for="<?php echo esc_attr( $key ); ?>" class="tc_checkboxes_label">
                                            <input type="checkbox" id="<?php echo esc_attr( $key ); ?>" name="<?php echo esc_attr( $key ); ?>" <?php checked( in_array( $key, $csv_checked_by_default ), true, true ); ?>>
                                            <?php echo esc_attr( $val ); ?>
                                        </label>
                                    <?php endforeach; ?>
                                    <?php do_action('tc_csv_admin_columns'); ?>
                                </fieldset>
                            </td>
                        </tr>
                        <tr valign="top">
                            <th scope="row">
                                <label for="tc_limit_order_type">
                                    <?php _e('Order Status', 'tccsv'); ?>
                                </label>
                                <p>
                                    <?php _e('Select order with only certain order status or export all of the orders', 'tccsv'); ?>
                                </p>
                            </th>
                            <td>
                                <select name="tc_limit_order_type[]" id="tc_limit_order_type" multiple>
                                    <?php
                                    $payment_statuses = apply_filters( 'tc_csv_payment_statuses', [
                                            'any' => __( 'Any', 'tccsv' ),
                                            'order_paid' => __( 'Paid', 'tccsv' ),
                                            'order_received' => __( 'Pending / Received', 'tccsv' ),
                                            'order_fraud'       =>  'Fraud Detected',
                                            'order_cancelled' => __( 'Cancelled', 'tccsv' ),
                                            'order_refunded' => __( 'Refunded', 'tccsv' )
                                        ]
                                    );

                                    $selected_order_status = isset( $settings[ 'tc_limit_order_type' ] ) ? (array) $settings[ 'tc_limit_order_type' ] : [ 'any' ];
                                    foreach ( $payment_statuses as $payment_status_key => $payment_status_value ) : ?>
                                        <option <?php selected( in_array( $payment_status_key, $selected_order_status ), true, true ); ?> value="<?php echo esc_attr( $payment_status_key ); ?>"><?php echo esc_attr( $payment_status_value ); ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </td>
                        </tr>
                        <tr valign="top">
                            <th scope="row">
                                <label for="document_title">
                                    <?php _e( 'Document Title', 'tccsv' ); ?>
                                </label>
                                <p>
                                    <?php _e('The title of the file that will be saved on your computer', 'tccsv'); ?>
                                </p>

                            </th>
                            <td>
                                <input type="text" name='document_title' id="document_title" value='<?php echo esc_attr( ( isset( $settings[ 'document_title' ] ) ? $settings[ 'document_title' ] : __( 'Attendee List', 'tccsv' ) ) ) ?>' />
                            </td>
                        </tr>
                        <tr valign="top">
                            <th scope="row">
                                <label for="document_title">
                                    <?php _e('Select / Deselect All', 'tccsv'); ?>
                                </label>

                                <p>
                                    <?php _e('Select or deselect all of the columns', 'tccsv'); ?>
                                </p>

                            </th>
                            <td>
                                <input type="checkbox" name='tc_select_all_csv' id="tc_select_all_csv" <?php checked( ( isset( $settings[ 'tc_select_all_csv' ] ) ? true : false ), true, true ) ?>/>
                            </td>
                        </tr>
                        <!-- Keep selection fields-->
                        <tr valign="top">
                            <th scope="row"><label for="document_title">
                                <?php _e('Remember Export Fields', 'tccsv'); ?></label>
                                <p>
                                    <?php _e('Save checked fields for the next session', 'tccsv'); ?>
                                </p>
                            </th>
                            <td>
                                <input type="checkbox" name='tc_keep_selection_fields' id="tc_keep_selection_fields" <?php checked( ( isset( $settings[ 'tc_keep_selection_fields' ] ) ? true : false ), true, true ) ?>/>
                            </td>
                        </tr>
                        <!-- Keep selection fields-->
                        </tbody>
                    </table>
                    <div id="csv_export_progressbar"><div class="progress-label"></div></div>
                </div><!-- .inside -->
            </div><!-- .postbox -->
            <p class="submit">
                <input type="submit" name="export_csv_event_data" id="export_csv_event_data" class="button button-primary" value="Export Data">
            </p>
        </form>
    </div><!-- #poststuff -->
</div><!-- .wrap -->
