( function( $ ) {

    // This identifies your website in the createToken call below
    Stripe.setPublishableKey( stripe.publisher_key );

    function stripeConnectResponseHandler( status, response ) {

        if ( response.error ) {

            // Re-enable the submit button
            $( '.tc_payment_confirm' ).removeAttr( "disabled" ).show();
            $( '#stripe_processing' ).hide();

            // Show the errors on the form
            $( "#stripe_checkout_errors" ).append( '<div class="tc_checkout_error">' + response.error.message + '</div>' );

        } else {

            $( '.tc_payment_confirm' ).attr( "disabled", "disabled" );

            // Token contains id, last4, and card type
            var token = response[ 'id' ];

            // Insert the token into the form so it gets submitted to the server
            $( "#tc_payment_form" ).append( "<input type='hidden' name='stripeToken' value='" + token + "' />" );

            // And submit
            $( "#tc_payment_form" ).get( 0 ).submit();
        }
    }

    $( document ).ready( function( $ ) {

        $( "#tc_payment_form" ).submit( function( event ) {

            /*
             * FPM: Seems this JS is trapping on all types of payment. So we need to only process if the payment
             * Type is stripe or stipe is the only option
             * If we have the radio buttons allowing the user to select the payment method? ...
             * If the length is zero then stripe or some other payment gateway is the only one defined.
             */
            if ( $( 'input.tc_choose_gateway' ).length ) {

                // If the payment option selected is not stripe then return and bypass input validations
                if ( $( 'input.tc_choose_gateway:checked' ).val() != "stripe-connect" ) {
                    return true;
                }
            }

            // Clear errors
            $( "#stripe_checkout_errors" ).empty();
            var is_error = false;

            // Check form fields
            if ( $( '#cc_name' ).val().length < 4 ) {
                $( "#stripe_checkout_errors" ).append( '<div class="tc_checkout_error">' + stripe.name + '</div>' );
                is_error = true;
            }

            if ( !Stripe.validateCardNumber( $( '#cc_number' ).val() ) ) {
                $( "#stripe_checkout_errors" ).append( '<div class="tc_checkout_error">' + stripe.number + '</div>' );
                is_error = true;
            }

            if ( !Stripe.validateExpiry( $( '#cc_month' ).val(), $( '#cc_year' ).val() ) ) {
                $( "#stripe_checkout_errors" ).append( '<div class="tc_checkout_error">' + stripe.expiration + '</div>' );
                is_error = true;
            }

            if ( !Stripe.validateCVC( $( '#cc_cvv2' ).val() ) ) {
                $( "#stripe_checkout_errors" ).append( '<div class="tc_checkout_error">' + stripe.cvv2 + '</div>' );
                is_error = true;
            }

            if ( is_error ) {
                $( '.tc_payment_confirm' ).removeAttr( "disabled" ).show();
                return false;
            }

            // Disable the submit button to prevent repeated clicks
            $( '#tc_payment_confirm' ).attr( "disabled", "disabled" ).hide();
            $( '#stripe_processing' ).show();

            // CreateToken returns immediately - the supplied callback submits the form if there are no errors
            Stripe.createToken( {
                name: $( '#cc_name' ).val(),
                number: $( '#cc_number' ).val(),
                cvc: $( '#cc_cvv2' ).val(),
                exp_month: $( '#cc_month' ).val(),
                exp_year: $( '#cc_year' ).val()
            }, stripeConnectResponseHandler );
            return false;
        } );
    } );
} )( jQuery );
