var el = wp.element.createElement,
    registerBlockType = wp.blocks.registerBlockType,
    BlockControls = wp.editor.BlockControls;

if ( tc_event_add_speakers.since_611 ) {
    var InspectorControls = wp.blockEditor.InspectorControls,
        ServerSideRender = wp.serverSideRender;

} else {
    var InspectorControls = wp.editor.InspectorControls,
        ServerSideRender = wp.components.ServerSideRender;
}

var AlignmentToolbar = wp.editor.AlignmentToolbar,
    RichText = wp.editor.RichText,
    SelectControl = wp.components.SelectControl,
    RangeControl = wp.components.RangeControl,
    TextControl = wp.components.TextControl,
    ToggleControl = wp.components.ToggleControl;

var __ = wp.i18n.__,
    displayType = 'tc_grid';

registerBlockType( 'tickera/event-speakers', {
    title: __( 'Event Speakers' ),
    description: __( 'Show Speakers For A Specific Event' ),
    icon: 'groups',
    category: 'widgets',
    keywords: [
        __( 'Tickera' ),
        __( 'Speakers' ),
    ],
    supports: {
        html: false,
    },
    attributes: {
        event_id: {
            type: 'string',
        },
        speakers_display: {
            type: 'string',
            default: 'tc_grid'
        },
        grid_count: {
            type: 'string',
            default: '2'
        },
        show_categories: {
            type: 'string',
            default: 'yes',
        }
    },
    edit: function( props ) {

        displayType = props.attributes.speakers_display;

        var events = jQuery.parseJSON( tc_event_add_speakers.events ),
            event_ids = [];

        events.forEach( function( entry ) {
            event_ids.push( { value: entry[ 0 ], label: entry[ 1 ] } );
        } );

        return [
            el(
                InspectorControls,
                { key: 'controls' },
                el(
                    SelectControl,
                    {
                        label: __( 'Event' ),
                        className: 'tc-gb-component',
                        value: props.attributes.event_id,
                        onChange: function change_val( value ) {
                            return props.setAttributes( { event_id: value } );
                        },
                        options: event_ids
                    }
                ),


                el(
                    SelectControl,
                    {
                        label: __( 'Display:' ),
                        className: 'tc-gb-component',
                        value: props.attributes.speakers_display,
                        onChange: function change_val( value ) {
                            return props.setAttributes( { speakers_display: value } );
                        },
                        options: [
                            { value: 'tc_grid', label: __( 'Grid' ) },
                            { value: 'tc_slider', label: __( 'Slider' ) },
                            { value: 'tc_list', label: __( 'List' ) },
                        ]
                    }
                ),

                el(
                    SelectControl,
                    {
                        label: __( 'Number Of Columns:' ),
                        className: 'tc-gb-component show-in-grid ' + displayType,
                        value: props.attributes.grid_count,
                        onChange: function change_val( value ) {
                            return props.setAttributes( { grid_count: value } );
                        },
                        options: [
                            { value: '2', label: __( '2' ) },
                            { value: '3', label: __( '3' ) },
                            { value: '4', label: __( '4' ) },
                        ]
                    }
                ),
                el(
                    SelectControl,
                    {
                        label: __( 'Show Categories:' ),
                        className: 'tc-gb-component show-in-grid show-in-list ' + displayType,
                        value: props.attributes.show_categories,
                        onChange: function change_val( value ) {
                            return props.setAttributes( { show_categories: value } );
                        },
                        options: [
                            { value: 'yes', label: __( 'Yes' ) },
                            { value: 'no', label: __( 'No' ) },
                        ]
                    }
                ),
            ),

            el( ServerSideRender, {
                block: "tickera/event-speakers",
                attributes: props.attributes
            } )
        ];
    },
    save: function( props ) {
        return null;
    }
} );
