/*
  Ultimate Member - User Photos dependencies
*/

const { src, dest, parallel } = require( 'gulp' );
const uglify      = require( 'gulp-uglify' );
const cleanCSS    = require( 'gulp-clean-css' );
const rename      = require( 'gulp-rename' );
const gulp = require("gulp");

function defaultTask( done ) {

	// -------- frontend assets ---------
	src(['assets/js/*.js','!assets/js/*.min.js'])
		.pipe( uglify() )
		.pipe( rename({ suffix: '.min' }) )
		.pipe( dest( 'assets/js/' ) );

	src([ 'assets/css/*.css', '!assets/css/*.min.css' ])
		.pipe( cleanCSS() )
		.pipe( rename({ suffix: '.min' }) )
		.pipe( dest( 'assets/css/' ) );

	// -------- wp-admin assets ---------
	src(['assets/js/admin/*.js','!assets/js/admin/*.min.js'])
		.pipe( uglify() )
		.pipe( rename({ suffix: '.min' }) )
		.pipe( dest( 'assets/js/admin/' ) );

	src([ 'assets/css/admin/*.css', '!assets/css/admin/*.min.css' ])
		.pipe( cleanCSS() )
		.pipe( rename({ suffix: '.min' }) )
		.pipe( dest( 'assets/css/admin/' ) );

	done();
}
exports.default = defaultTask;
