<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Filter for user menu links.
 *
 * @param array $actions
 * @param int   $user_profile_id
 *
 * @return array
 */
function um_reviews_admin_user_actions( $actions, $user_profile_id ) {
	if ( UM()->roles()->um_current_user_can( 'edit', $user_profile_id ) ) {
		if ( ! UM()->Reviews()->api()->is_blocked( $user_profile_id ) ) {
			$actions['block_add_review'] = array( 'label' => __( 'Block reviews', 'um-reviews' ) );
		} else {
			$actions['unblock_add_review'] = array( 'label' => __( 'Unblock reviews', 'um-reviews' ) );
		}
	}
	return $actions;
}
add_filter( 'um_admin_user_actions_hook', 'um_reviews_admin_user_actions', 100, 2 );

/**
 * Block user from adding review
 *
 * @param $action
 * @param $user_id
 */
function um_reviews_process_user_admin( $action, $user_id ) {
	if ( ! in_array( $action, array( 'block_add_review', 'unblock_add_review' ), true ) ) {
		return;
	}

	if ( ! UM()->common()->users()->can_current_user_edit_user( $user_id ) ) {
		wp_die( esc_html__( 'You do not have permission to edit this user.', 'um-reviews' ) );
	}

	if ( 'block_add_review' === $action ) {
		if ( ! wp_verify_nonce( $_REQUEST['nonce'], "block_add_review{$user_id}" ) ) {
			wp_die( esc_html__( 'The link you followed has expired.', 'um-reviews' ) );
		}

		$result = update_user_meta( $user_id, '_cannot_add_review', 1 );
	} else {
		if ( ! wp_verify_nonce( $_REQUEST['nonce'], "unblock_add_review{$user_id}" ) ) {
			wp_die( esc_html__( 'The link you followed has expired.', 'um-reviews' ) );
		}

		$result = delete_user_meta( $user_id, '_cannot_add_review' );
	}

	if ( ! $result ) {
		wp_die( esc_html__( 'Something went wrong.', 'um-reviews' ) );
	}

	um_safe_redirect( UM()->permalinks()->get_current_url( true ) );
	exit;
}
add_action( 'um_action_user_request_hook', 'um_reviews_process_user_admin', 10, 2 );
