<?php
namespace um_ext\um_reviews\core;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class Actions_Listener
 * @package um_ext\um_reviews\core
 */
class Actions_Listener {

	/**
	 * Actions_Listener constructor.
	 */
	public function __construct() {
		add_action( 'admin_init', array( $this, 'actions_listener' ) );
		add_filter( 'um_adm_action_individual_nonce_actions', array( $this, 'extends_individual_nonce_actions' ) ); // @todo remove soon after UM core update
		add_filter( 'um_adm_action_custom_update_notice', array( &$this, 'extends_admin_action_notice' ), 10, 2 );
	}

	/**
	 * Handle wp-admin actions
	 *
	 * @since 2.8.7
	 */
	public function actions_listener() {
		if ( ! current_user_can( 'manage_options' ) ) {
			return;
		}

		$rolename = UM()->roles()->get_priority_user_role( get_current_user_id() );
		$role     = get_role( $rolename );

		if ( null === $role ) {
			return;
		}

		// Add Ultimate Member bulk actions only when the current user has 'edit_users' capability.
		if ( ! current_user_can( 'edit_users' ) && ! $role->has_cap( 'edit_users' ) ) {
			return;
		}

		if ( ! empty( $_REQUEST['um_adm_action'] ) ) {
			switch ( sanitize_key( $_REQUEST['um_adm_action'] ) ) { // phpcs:ignore WordPress.Security.NonceVerification -- there is nonce verification below for each case
				case 'block_add_review':
					if ( empty( $_REQUEST['uid'] ) || ! is_numeric( $_REQUEST['uid'] ) ) {
						die( esc_html__( 'Invalid user ID', 'um-reviews' ) );
					}

					$user_id = absint( $_REQUEST['uid'] );

					check_admin_referer( "block_add_review{$user_id}" );

					$result = update_user_meta( $user_id, '_cannot_add_review', 1 );

					$redirect = wp_get_referer();
					if ( $result ) {
						$redirect = add_query_arg(
							array(
								'update'        => 'um_reviews_blocked',
								'blocked_count' => 1,
							),
							$redirect
						);
					}
					wp_safe_redirect( $redirect );
					exit;
				case 'unblock_add_review':
					if ( empty( $_REQUEST['uid'] ) || ! is_numeric( $_REQUEST['uid'] ) ) {
						die( esc_html__( 'Invalid user ID', 'um-reviews' ) );
					}

					$user_id = absint( $_REQUEST['uid'] );

					check_admin_referer( "unblock_add_review{$user_id}" );

					$result = delete_user_meta( $user_id, '_cannot_add_review' );

					$redirect = wp_get_referer();
					if ( $result ) {
						$redirect = add_query_arg(
							array(
								'update'          => 'um_reviews_allowed',
								'unblocked_count' => 1,
							),
							$redirect
						);
					}
					wp_safe_redirect( $redirect );
					exit;
			}
		}
	}

	public function extends_individual_nonce_actions( $actions ) {
		$actions[] = 'block_add_review';
		$actions[] = 'unblock_add_review';
		return $actions;
	}

	public function extends_admin_action_notice( $messages, $update ) {
		if ( 'um_reviews_blocked' === $update ) {
			$blocked_count          = isset( $_REQUEST['blocked_count'] ) ? absint( $_REQUEST['blocked_count'] ) : 0;
			$messages[0]['content'] = sprintf( _n( '<strong>%s</strong> user has been blocked to add reviews.', '<strong>%s</strong> users have been blocked to add reviews.', $blocked_count, 'um-reviews' ), $blocked_count );
		} elseif ( 'um_reviews_allowed' === $update ) {
			$unblocked_count        = isset( $_REQUEST['unblocked_count'] ) ? absint( $_REQUEST['unblocked_count'] ) : 0;
			$messages[0]['content'] = sprintf( _n( '<strong>%s</strong> user has been unblocked to add reviews.', '<strong>%s</strong> users have been unblocked to add reviews.', $unblocked_count, 'um-reviews' ), $unblocked_count );
		}
		return $messages;
	}
}
