<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class UM_Reviews
 */
class UM_Reviews {

	/**
	 * For backward compatibility with 1.3.x and PHP8.2 compatibility.
	 *
	 * @var bool
	 */
	public $plugin_inactive = false;

	/**
	 * @var
	 */
	private static $instance;

	/**
	 * @return UM_Reviews
	 */
	public static function instance() {
		if ( is_null( self::$instance ) ) {
			self::$instance = new self();
		}
		return self::$instance;
	}

	/**
	 * UM_Reviews constructor.
	 */
	public function __construct() {
		// Global for backwards compatibility.
		$GLOBALS['um_reviews'] = $this;
		add_filter( 'um_call_object_Reviews', array( &$this, 'get_this' ) );

		if ( UM()->is_request( 'admin' ) ) {
			$this->admin_upgrade();
			$this->actions_listener();
		}

		$this->admin();
		$this->shortcode();
		$this->enqueue();
		$this->member_directory();
		$this->account();

		add_action( 'init', array( &$this, 'create_post_type' ), 2 );
		add_action( 'plugins_loaded', array( &$this, 'init' ), 0 );

		require_once um_reviews_path . 'includes/core/um-reviews-widget.php';
		add_action( 'widgets_init', array( &$this, 'widgets_init' ) );

		add_filter( 'um_settings_default_values', array( &$this, 'default_settings' ), 10, 1 );

		add_filter( 'um_cpt_list', array( &$this, 'add_cpt' ) );
		add_filter( 'um_rest_api_get_stats', array( &$this, 'rest_api_get_stats' ), 10, 1 );
		add_filter( 'um_email_templates_path_by_slug', array( &$this, 'email_templates_path_by_slug' ), 10, 1 );

		add_action( 'wp_ajax_um_review_add', array( $this->api(), 'ajax_review_add' ) );
		add_action( 'wp_ajax_um_review_edit', array( $this->api(), 'ajax_review_add' ) );
		add_action( 'wp_ajax_um_review_flag', array( $this->api(), 'ajax_review_flag' ) );
		add_action( 'wp_ajax_nopriv_um_review_flag', array( $this->api(), 'ajax_review_flag' ) );

		add_action( 'wp_ajax_um_review_trash', array( $this->api(), 'ajax_review_trash' ) );
		add_action( 'wp_ajax_um_reviews_reply', array( $this->api(), 'ajax_reply_post' ) );
		add_action( 'wp_ajax_um_reviews_reply_delete', array( $this->api(), 'ajax_reply_delete' ) );
	}

	public function email_templates_path_by_slug( $slugs ) {
		$slugs['review_notice']         = um_reviews_path . 'templates/email/';
		$slugs['review_pending_notice'] = um_reviews_path . 'templates/email/';
		$slugs['review_reply_notice']   = um_reviews_path . 'templates/email/';
		$slugs['review_report_notice']  = um_reviews_path . 'templates/email/';
		return $slugs;
	}

	public function rest_api_get_stats( $response ) {
		global $wpdb;

		$total_reviews = $wpdb->get_var(
			"SELECT COUNT(*)
			FROM {$wpdb->prefix}posts
			WHERE post_status='publish' AND
				  post_type='um_review'"
		);

		$response['stats']['total_reviews'] = absint( $total_reviews );
		return $response;
	}

	public function default_settings( $defaults ) {
		$defaults = array_merge( $defaults, $this->setup()->settings_defaults );
		return $defaults;
	}

	/**
	 * @param $cpt array
	 *
	 * @return array
	 */
	public function add_cpt( $cpt ) {
		$cpt[] = 'um_review';
		return $cpt;
	}

	/**
	 * @return um_ext\um_reviews\core\Reviews_Setup()
	 */
	public function setup() {
		if ( empty( UM()->classes['um_reviews_setup'] ) ) {
			UM()->classes['um_reviews_setup'] = new um_ext\um_reviews\core\Reviews_Setup();
		}
		return UM()->classes['um_reviews_setup'];
	}

	public function get_this() {
		return $this;
	}

	/**
	 * @return um_ext\um_reviews\core\Reviews_Main_API()
	 */
	public function api() {
		if ( empty( UM()->classes['um_reviews_api'] ) ) {
			UM()->classes['um_reviews_api'] = new um_ext\um_reviews\core\Reviews_Main_API();
		}
		return UM()->classes['um_reviews_api'];
	}

	/**
	 * @return um_ext\um_reviews\core\Reviews_Admin()
	 */
	public function admin() {
		if ( empty( UM()->classes['um_reviews_admin'] ) ) {
			UM()->classes['um_reviews_admin'] = new um_ext\um_reviews\core\Reviews_Admin();
		}
		return UM()->classes['um_reviews_admin'];
	}

	/**
	 * @return um_ext\um_reviews\core\Reviews_Email()
	 */
	public function email() {
		if ( empty( UM()->classes['um_reviews_email'] ) ) {
			UM()->classes['um_reviews_email'] = new um_ext\um_reviews\core\Reviews_Email();
		}
		return UM()->classes['um_reviews_email'];
	}

	/**
	 * @return um_ext\um_reviews\core\Reviews_Enqueue()
	 */
	public function enqueue() {
		if ( empty( UM()->classes['um_reviews_enqueue'] ) ) {
			UM()->classes['um_reviews_enqueue'] = new um_ext\um_reviews\core\Reviews_Enqueue();
		}
		return UM()->classes['um_reviews_enqueue'];
	}

	/**
	 * @return um_ext\um_reviews\core\Reviews_Shortcode()
	 */
	public function shortcode() {
		if ( empty( UM()->classes['um_reviews_shortcode'] ) ) {
			UM()->classes['um_reviews_shortcode'] = new um_ext\um_reviews\core\Reviews_Shortcode();
		}
		return UM()->classes['um_reviews_shortcode'];
	}

	/**
	 * @return um_ext\um_reviews\core\Reviews_Member_Directory()
	 */
	public function member_directory() {
		if ( empty( UM()->classes['um_reviews_member_directory'] ) ) {
			UM()->classes['um_reviews_member_directory'] = new um_ext\um_reviews\core\Reviews_Member_Directory();
		}
		return UM()->classes['um_reviews_member_directory'];
	}

	/**
	 * @return um_ext\um_reviews\core\Reviews_Account()
	 */
	public function account() {
		if ( empty( UM()->classes['um_reviews_account'] ) ) {
			UM()->classes['um_reviews_account'] = new um_ext\um_reviews\core\Reviews_Account();
		}
		return UM()->classes['um_reviews_account'];
	}

	/**
	 * @return um_ext\um_reviews\admin\core\Admin_Upgrade()
	 */
	public function admin_upgrade() {
		if ( empty( UM()->classes['um_reviews_admin_upgrade'] ) ) {
			UM()->classes['um_reviews_admin_upgrade'] = new um_ext\um_reviews\admin\core\Admin_Upgrade();
		}
		return UM()->classes['um_reviews_admin_upgrade'];
	}

	/**
	 * @return um_ext\um_reviews\core\Actions_Listener
	 */
	public function actions_listener() {
		if ( empty( UM()->classes['um_reviews_actions_listener'] ) ) {
			UM()->classes['um_reviews_actions_listener'] = new um_ext\um_reviews\core\Actions_Listener();
		}
		return UM()->classes['um_reviews_actions_listener'];
	}

	/**
	 * Creates a post type
	 */
	public function create_post_type() {
		register_post_type(
			'um_review',
			array(
				'labels'       => array(
					'name'               => __( 'User Reviews', 'um-reviews' ),
					'singular_name'      => __( 'Review', 'um-reviews' ),
					'add_new'            => __( 'Add New Review', 'um-reviews' ),
					'add_new_item'       => __( 'Add New Review', 'um-reviews' ),
					'edit_item'          => __( 'Edit Review', 'um-reviews' ),
					'not_found'          => __( 'No user reviews have been submitted yet', 'um-reviews' ),
					'not_found_in_trash' => __( 'Nothing found in Trash', 'um-reviews' ),
					'search_items'       => __( 'Search Reviews', 'um-reviews' ),
				),
				'show_ui'      => true,
				'show_in_menu' => false,
				'public'       => false,
				'supports'     => array( 'title', 'editor' ),
			)
		);
	}

	/**
	 * Init
	 *
	 */
	public function init() {
		// Actions
		require_once um_reviews_path . 'includes/core/actions/um-reviews-tabs.php';
		require_once um_reviews_path . 'includes/core/actions/um-reviews-trash.php';
		require_once um_reviews_path . 'includes/core/actions/um-reviews-admin.php';
		require_once um_reviews_path . 'includes/core/actions/um-reviews-controls.php';
		require_once um_reviews_path . 'includes/core/actions/um-reviews-members.php';

		// Filters
		require_once um_reviews_path . 'includes/core/filters/um-reviews-tabs.php';
		require_once um_reviews_path . 'includes/core/filters/um-reviews-license.php';
		require_once um_reviews_path . 'includes/core/filters/um-reviews-settings.php';
		require_once um_reviews_path . 'includes/core/filters/um-reviews-permissions.php';
		require_once um_reviews_path . 'includes/core/filters/um-reviews-fields.php';
	}

	public function widgets_init() {
		register_widget( 'um_reviews_top_rated' );
		register_widget( 'um_reviews_most_rated' );
		register_widget( 'um_reviews_lowest_rated' );
	}
}

//create class var
add_action( 'plugins_loaded', 'um_init_reviews', -10, 1 );
function um_init_reviews() {
	if ( function_exists( 'UM' ) ) {
		UM()->set_class( 'Reviews', true );
	}
}
