<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Filter for user permissions
 *
 * @param array $meta
 *
 * @return array
 */
function um_reviews_user_permissions_filter( $meta ) {
	if ( ! isset( $meta['can_have_reviews_tab'] ) ) {
		$meta['can_have_reviews_tab'] = 1;
	}

	if ( ! isset( $meta['can_review'] ) ) {
		$meta['can_review'] = 1;
	}

	if ( ! isset( $meta['can_publish_review'] ) ) {
		$meta['can_publish_review'] = 1;
	}

	if ( ! isset( $meta['can_remove_review'] ) ) {
		if ( ! empty( $meta['can_edit_everyone'] ) && $meta['can_edit_everyone'] == 1 ) {
			$meta['can_remove_review'] = 1;
		} else {
			$meta['can_remove_review'] = 0;
		}
	}

	if ( ! isset( $meta['can_remove_own_review'] ) ) {
		$meta['can_remove_own_review'] = 1;
	}

	return $meta;
}
add_filter( 'um_user_permissions_filter', 'um_reviews_user_permissions_filter' );

/**
 * Allowed permissions
 *
 * @param $user_id
 * @param $reviewer_id
 * @param $my_id
 * @param $review_id
 */
function um_review_front_actions( $user_id, $reviewer_id, $my_id, $review_id ) {
	$args_t = compact( 'my_id', 'review_id', 'reviewer_id', 'user_id' );
	UM()->get_template( 'review-front-actions.php', um_reviews_plugin, $args_t, true );
}
add_action( 'um_review_front_actions', 'um_review_front_actions', 99, 4 );
