<?php 
/**
 * Google Translate PHP class adapted for Video Blogster
 *
 * @author      Levan Velijanashvili <me@stichoza.com>
 * @link        http://stichoza.com/  https://github.com/Stichoza/google-translate-php
 * @version     v2.0.4
 */
if ( ! class_exists( 'VB_GoogleTranslate' ) ) {
class VB_GoogleTranslate {
    
    /**
     * Last translation
     * @var string
     * @access private
     */
    public $lastResult = "";
    
    /**
     * Language translating from
     * @var string
     * @access private
     */
    private $langFrom;
    
    /**
     * Language translating to
     * @var string
     * @access private
     */
    private $langTo;
    
    /**
     * Google Translate URL format
     * @var string
     * @access private
     */
    private static $urlRequest = "http://translate.google.com/translate_a/t";
    private static $urlParams = array (
		'client'		=> 't',
		'hl'			=> 'en',
		'sl'			=> null,
		'tl'			=> null,
		'text'			=> null,
		'ie'			=> 'UTF-8',
		'oe'			=> 'UTF-8',
		'multires'		=> 1,
		'otf'			=> 0,
		'pc'			=> 1,
		'trs'			=> 1,
		'ssel'			=> 0,
		'tsel'			=> 0,
		'sc'			=> 1,
		'tk'			=> null
		);
    /**
     * Class constructor
     * 
     * @param string $from Language translating from (Optional)
     * @param string $to Language translating to (Optional)
     * @access public
     */
    public function __construct($from = "en", $to = "ka") {
        $this->setLangFrom($from)->setLangTo($to);
    }
    /**
     * Set language we are transleting from
     * 
     * @param string $from Language code
     * @return VB_GoogleTranslate
     * @access public
     */
    public function setLangFrom($lang) {
        $this->langFrom = $lang;
        return $this;
    }
    
    /**
     * Set language we are transleting to
     * 
     * @param string $to Language code
     * @return VB_GoogleTranslate
     * @access public
     */
    public function setLangTo($lang) {
        $this->langTo = $lang;
        return $this;
    }
    
    
    /**
     * Simplified curl method
     * @param string $url URL
     * @param array $params Parameter array
     * @param boolean $cookieSet
     * @return string
     * @access public
     */
    public static final function makeCurl($url, array $params = array(), $cookieSet = false) {
        $ch = curl_init($url);

	$queryUrl = preg_replace('/%5B(?:[0-9]|[1-9][0-9]+)%5D=/', '=', http_build_query($params));

        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_USERAGENT, 'Stichoza');
        curl_setopt($ch, CURLOPT_HEADER, false);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $queryUrl );

        if (!$cookieSet) {
            $cookie = tempnam(sys_get_temp_dir(), "CURLCOOKIE");
            curl_setopt($ch, CURLOPT_COOKIEJAR, $cookie);
	}
	else {
		curl_setopt($ch, CURLOPT_COOKIEFILE, '');
	}

        $output = curl_exec($ch);

	curl_close($ch);

        if (!$cookieSet) {
            // Clean up temporary file
            unset($ch);
            unlink($cookie);
	}

        
        return $output;
    }
    /**
     * Translate text
     * 
     * @param string $string Text to translate
     * @return string/boolean Translated text
     * @access public
     */
    public function translate($string) {
        return $this->lastResult = self::staticTranslate($string, $this->langFrom, $this->langTo);
    }
    /**
     * Static method for translating text
     * 
     * @param string $string Text to translate
     * @param string $from Language code
     * @param string $to Language code
     * @return string/boolean Translated text
     * @access public
     */
    public static function staticTranslate($string, $from, $to) {
	$requestParams = array (
		'text'		=> $string,
		'sl'		=> $from,
		'tl'		=> $to,
		'tk'		=> self::TL( $string )
		);
	$params = array_merge(self::$urlParams, $requestParams);
        $result = self::makeCurl(self::$urlRequest, $params);
        $result = preg_replace('!,+!', ',', $result); // remove repeated commas (causing JSON syntax error)
        $result = str_replace ("[,", "[", $result);
        $resultArray = json_decode($result, true);
        if (!empty($resultArray[0])) {
		return $resultArray[0];
        }
        return false;
    }


public static function shr32($x, $bits)
{

    if($bits <= 0){
        return $x;
    }
    if($bits >= 32){
        return 0;
    }

    $bin = decbin($x);
    $l = strlen($bin);

    if($l > 32){
        $bin = substr($bin, $l - 32, 32);
    }elseif($l < 32){
        $bin = str_pad($bin, 32, '0', STR_PAD_LEFT);
    }

    return bindec(str_pad(substr($bin, 0, 32 - $bits), 32, '0', STR_PAD_LEFT));
}        

public static function charCodeAt($str, $index)
{
    $char = mb_substr($str, $index, 1, 'UTF-8');

    if (mb_check_encoding($char, 'UTF-8'))
    {
        $ret = mb_convert_encoding($char, 'UTF-32BE', 'UTF-8');
        return hexdec(bin2hex($ret));
    }
    else
    {
        return null;
    }
}


public static function RL($a, $b)
{
    for($c = 0; $c < strlen($b) - 2; $c +=3) {
        $d = $b{$c+2};
        $d = $d >= 'a' ? self::charCodeAt($d,0) - 87 : intval($d);
        $d = $b{$c+1} == '+' ? self::shr32($a, $d) : $a << $d;
        $a = $b{$c} == '+' ? ($a + $d & 4294967295) : $a ^ $d;
    }
    return $a;
}


public static function generateB() 
{
        $start = new DateTime('1970-01-01');
        $now = new DateTime('now');
        $diff = $now->diff($start);
        return $diff->h + ($diff->days * 24);
}

public static function TL( $a )
{
        $b = self::generateB();
        for ($d = array(), $e = 0, $f = 0; $f < mb_strlen($a, 'UTF-8'); $f++) {
            $g = self::charCodeAt($a, $f);
            if (128 > $g) {
                $d[$e++] = $g;
            } else {
                if (2048 > $g) {
                    $d[$e++] = $g >> 6 | 192;
                } else {
                    if (55296 == ($g & 64512) && $f + 1 < mb_strlen($a, 'UTF-8') && 56320 == (self::charCodeAt($a, $f + 1) & 64512)) {
                        $g = 65536 + (($g & 1023) << 10) + (self::charCodeAt($a, ++$f) & 1023);
                        $d[$e++] = $g >> 18 | 240;
                        $d[$e++] = $g >> 12 & 63 | 128;
                    } else {
                        $d[$e++] = $g >> 12 | 224;
                        $d[$e++] = $g >> 6 & 63 | 128;
                    }
                }
                $d[$e++] = $g & 63 | 128;
            }
        }
        $a = $b;
        for ($e = 0; $e < count($d); $e++) {
            $a += $d[$e];
            $a = self::RL($a, '+-a^+6');
        }
        $a = self::RL($a, '+-3^+b+-f');
        if (0 > $a) {
            $a = ($a & 2147483647) + 2147483648;
        }
        $a = fmod($a, pow(10, 6));
        return $a.'.'.($a ^ $b);
}


public static function TLold( $a )
{   
    mb_internal_encoding("UTF-8");
    $b = 402890;
    for ($d = array(), $e = 0, $f = 0; $f < mb_strlen($a); $f++) {
        $g = self::charCodeAt($a, $f);

        if ( 128 > $g ) {
            $d[$e++] = $g; 
        } else {
            if ( 2048 > $g ) { 
                $d[$e++] = $g >> 6 | 192;
            } else { 
                if ( 55296 == ($g & 64512) && $f + 1 < mb_strlen($a) && 56320 == (charCodeAt($a, $f + 1) & 64512) ) { 

                    $g = 65536 + (($g & 1023) << 10) + (charCodeAt($a, ++$f) & 1023);
                    $d[$e++] = $g >> 18 | 240; 
                    $d[$e++] = $g >> 12 & 63 | 128;
                } else {
                    $d[$e++] = $g >> 12 | 224;
                    $d[$e++] = $g >> 6 & 63 | 128;
                }
            }
            $d[$e++] = $g & 63 | 128;
        }
    }

    $a = $b;
    for ($e = 0; $e < count($d); $e++) {
        $a += $d[$e];
        $a = self::RL($a, '+-a^+6');
    }
    $a = self::RL($a, "+-3^+b+-f");
    if (0 > $a) $a = ($a & 2147483647) + 2147483648;
    $a %= pow(10, 6);
    return sprintf('%d.%d', $a, $a ^ $b);
}



}
}
?>
