<?php

/*
Admin Filter by Custom Fields
Filter posts or pages in admin by custom fields (post meta)
Version: 1.0
Author: Bainternet
Author URI: http://en.bainternet.info
Code URI: https://github.com/michael-cannon/wordpress-theme-helpers/blob/master/lib/admin-filter.php
*/



add_filter( 'parse_query', 'ba_admin_posts_filter' );
add_action( 'restrict_manage_posts', 'ba_admin_posts_filter_restrict_manage_posts' );

if ( ! function_exists( 'ba_admin_posts_filter' ) ) {
function ba_admin_posts_filter( $query )
{
    global $pagenow;
    if ( is_admin() && 'edit.php' === $pagenow && ! empty($_GET['ADMIN_FILTER_FIELD_NAME']) ) {
        $query->query_vars['meta_key'] = esc_attr( $_GET['ADMIN_FILTER_FIELD_NAME'] );
		$query->query_vars['meta_compare'] = 'LIKE';
		if ( ! empty($_GET['ADMIN_FILTER_FIELD_VALUE']))
			$query->query_vars['meta_value'] = esc_attr( $_GET['ADMIN_FILTER_FIELD_VALUE'] );
    }
}
}

if ( ! function_exists( 'ba_admin_posts_filter_restrict_manage_posts' ) ) {
function ba_admin_posts_filter_restrict_manage_posts()
{
    global $wpdb;
	$sql = 'SELECT DISTINCT meta_key FROM ' . $wpdb->postmeta;
	$sql .= ' WHERE 1 = 1';
	$sql .= ' AND meta_key NOT LIKE "field_%"';
	$sql .= ' AND meta_key NOT LIKE "wpcf-%"';
	$sql .= ' ORDER BY meta_key ASC';
	$fields = $wpdb->get_results($sql, ARRAY_N);
?>
<select name="ADMIN_FILTER_FIELD_NAME">
<option value=""><?php esc_html_e('Filter By Custom Fields', 'video-blogster'); ?></option>
<?php
    $current = isset($_GET['ADMIN_FILTER_FIELD_NAME'])? $_GET['ADMIN_FILTER_FIELD_NAME']:'';
    $current_v = isset($_GET['ADMIN_FILTER_FIELD_VALUE'])? $_GET['ADMIN_FILTER_FIELD_VALUE']:'';
    foreach ($fields as $field) {
        if (substr($field[0],0,1) !== "_"){
        printf
            (
                '<option value="%s"%s>%s</option>',
                $field[0],
		selected( $field[0] == $current, true, false ),
                $field[0]
            );
        }
    }
?>
</select> <?php esc_html_e('Value:', 'video-blogster'); ?><input type="TEXT" name="ADMIN_FILTER_FIELD_VALUE" value="<?php echo $current_v; ?>" />
<?php
}
}
?>
