<?php

defined( 'ABSPATH' ) or die( "Oops! This is a WordPress plugin and should not be called directly.\n" );

/* Support for plugin BAW Post Views Count
 * https://wordpress.org/plugins/baw-post-views-count/
 *
 * This plugin uses it's own custom meta field for VideoViews.
 * This function hook will add those fields to Video Blogster feed form.
 * This file will only be included if BAW Post Views Count is detected.
 *
 */

if ( ! function_exists( 'vb_insert_baw_changes' ) ) :

// shows changes on make video feed form:
add_action('vb_make_feed', 'vb_insert_baw_changes', 10, 1);
function vb_insert_baw_changes( $args ) {
	$addFields = array(
		'_count-views_all'	=> '%VideoViews%'
	);
	$args['pMetaFields'] = array_merge( $args['pMetaFields'], $addFields );
	return $args;
}

// dynamic get VB meta field values if missing
add_filter('get_post_metadata', 'vb_baw_meta_check', 10, 4);
function vb_baw_meta_check( $metadata, $postID, $meta_key, $single ) {
        global $wpdb;
        $metadata = $wpdb->get_var( "SELECT meta_value FROM $wpdb->postmeta WHERE post_id = {$postID} AND meta_key = '{$meta_key}'" );
        if ( $metadata != null ) return null;
        if ( $meta_key == '_count-views_all' )     return get_post_meta( $postID, 'VideoViews', $single );
        return null;
}

endif;
?>
