<?php

defined( 'ABSPATH' ) or die( "Oops! This is a WordPress plugin and should not be called directly.\n" );

/* Support for plugin Entry Views
 * https://wordpress.org/plugins/entry-views/
 */

if ( ! function_exists( 'vb_insert_ev_changes' ) ) :

// shows changes on make video feed form:
add_action('vb_make_feed', 'vb_insert_ev_changes', 10, 1);

function vb_insert_ev_changes( $args ) {
	$addFields = array(
		'Views'	=> '%VideoViews%',
	);
	$args['pMetaFields'] = array_merge( $args['pMetaFields'], $addFields );
	return $args;
}

add_action( 'vb_pre_custom_meta', 'vb_pre_custom_meta', 10, 2 );

// case sensitive db - remove default 'views' so vlog can set 'Views'.
function vb_pre_custom_meta( $postID, $videoInfo ) {
  	delete_post_meta( $postID, 'views' );
}

endif;

?>
