<?php

defined( 'ABSPATH' ) or die( "Oops! This is a WordPress plugin and should not be called directly.\n" );

/* Support for plugin WordPress Popular Posts
 * https://wordpress.org/support/plugin/wordpress-popular-posts
 *
 * This plugin uses it's own custom database, so use a hook to write to it after Video Blogster creates each new post.
 * This file will only be included if WordPress Popular Posts is installed.
 *
 */

if ( ! function_exists( 'vb_insert_into_wordpress_popular_posts' ) ) :

add_action('vb_create_the_post_finished', 'vb_insert_into_wordpress_popular_posts', 10, 2);

function vb_insert_into_wordpress_popular_posts( $postID, $videoInfo ) {
	global $wpdb;

	if ( ! $postID || ! $videoInfo['viewCount'] ) {
		return;
	}

	$table = $wpdb->prefix . "popularposts";
	$now = current_time('mysql');
	$curdate = gmdate( 'Y-m-d', ( time() + ( get_site_option( 'gmt_offset' ) * 3600 ) ));
	$views = $videoInfo['viewCount'];

	// Update all-time table
	$result1 = $wpdb->query( $wpdb->prepare(
				"INSERT INTO {$table}data
				(postid, day, last_viewed, pageviews) VALUES (%d, %s, %s, %d)
				ON DUPLICATE KEY UPDATE pageviews = pageviews + %4\$d, last_viewed = '%3\$s';",
				$postID,
				$now,
				$now,
				$views
	));

	// Update range (summary) table
	$result2 = $wpdb->query( $wpdb->prepare(
				"INSERT INTO {$table}summary
				(postid, pageviews, view_date, last_viewed) VALUES (%d, %d, %s, %s)
				ON DUPLICATE KEY UPDATE pageviews = pageviews + %2\$d, last_viewed = '%4\$s';",
				$postID,
				$views,
				$curdate,
				$now
	));

}

endif;
?>
