<?php

defined( 'ABSPATH' ) or die( "Oops! This is a WordPress plugin and should not be called directly.\n" );

/* Support for plugin WTI Like Post
 * https://wordpress.org/plugins/wti-like-post/
 *
 * This plugin uses it's own custom database, so use a hook to write to it after Video Blogster creates each new post.
 * This file will only be included if WTI Like Post is installed.
 *
 */

if ( ! function_exists( 'vb_insert_into_wti' ) ) :

add_action('vb_create_the_post_finished', 'vb_insert_into_wti', 10, 2);

function vb_insert_into_wti( $postID, $videoInfo ) {
	global $wpdb;

	if ( !$videoInfo['likeCount'] && !$videoInfo['dislikeCount']) {
		return;
	}

	// insert likes
	$query = "INSERT INTO {$wpdb->prefix}wti_like_post SET ";
	$query .= "post_id = '" . $postID . "', ";
	$query .= "value = '".$videoInfo['likeCount']."', ";
	$query .= "date_time = '" . date('Y-m-d H:i:s') . "', ";
	$query .= "ip = ''";
	$success = $wpdb->query($query);

	// insert dislikes
	$query = "INSERT INTO {$wpdb->prefix}wti_like_post SET ";
	$query .= "post_id = '" . $postID . "', ";
	$query .= "value = '".( -1 * $videoInfo['dislikeCount'])."', ";
	$query .= "date_time = '" . date('Y-m-d H:i:s') . "', ";
	$query .= "ip = ''";
	$success = $wpdb->query($query);
}

endif;
?>
