<div class='wrap video-blogster-section'>
	<h2 class="video-blogster-title"><?php echo $this->plugin['name'] . " v" . $this->plugin['version']; ?></h2>
	<?php include( sprintf( "%stemplates/buttons.php", $this->plugin['dir'] ) ); ?>
	<p><?php esc_html_e( 'All important log events during video feed Schedule requests will be shown here.', 'video-blogster' );?></p>
</div>
<?php 
$messages = get_option( $this->plugin['prefix'] . 'messages', array( 'video_import' => false, 'video_skip' => true, 'utility_funcs' => false, 'debug' => false ) ); 
$max = (int) get_option( $this->plugin['prefix'] . 'messages_max', 1000 );
if ( ! isset( $messages['video_skip'] ) ) { $messages['video_skip'] = true; } 
?>
<div class='wrap video-blogster-section'>
	<h3 class='video-blogster-title'>Log Messages</h3>
	<form method="post" action="<?php echo $_SERVER["REQUEST_URI"]; ?>">
	<table class='form-table'>
		<tr>
			<th scope="row"><label class='video-blogster-label'><?php esc_html_e( 'Display Messages', 'video-blogster' );?></label></th>
		<td>
			<input type="checkbox" name="messages_critical" disabled value="true" checked /> <?php esc_html_e( 'Critical', 'video-blogster' );?>
			<input type="checkbox" name="messages_video_import" value="true" <?php checked( $messages['video_import'], true, true ); ?> /> <?php esc_html_e( 'Video Import', 'video-blogster' );?>
			<input type="checkbox" name="messages_video_skip" value="true" <?php checked( $messages['video_skip'], true, true ); ?> /> <?php esc_html_e( 'Video Skipped', 'video-blogster' );?>
			<input type="checkbox" name="messages_debug" value="true" <?php checked( $messages['debug'], true, true ); ?> /> <?php esc_html_e( 'Debug Messages', 'video-blogster' );?>
			<br />
		<?php esc_html_e( '(If importing manually, messages will be shown on the screen as well)', 'video-blogster' );?>
		</td>
		</tr>
		<tr>
			<th scope="row"><label class='video-blogster-label' for='messages_max'><?php esc_html_e( 'Max log messages to save', 'video-blogster' );?></label></th>
		<td>
			<input type="text" size="6" maxlength="6" name="messages_max" id="messages_max" value="<?php echo $max; ?>" />
			<?php esc_html_e( 'Enter 0 for no  limit.', 'video-blogster' );?>
		</td>
		</tr>
	</table>
	<p>
	<input type="submit" name="save_values" value="<?php esc_html_e('Save Settings', 'video-blogster' );?>" />
	<input type="submit" name="clear_log" value="<?php esc_html_e('Clear Log Messages', 'video-blogster' );?>" />
	</p>
	</form>

	<div class="vbp-text" id="vbp-log-messages">
	<?php echo $output; ?>
	</div>

</div>
