<?php
	$valid_taxonomies = $this->get_taxonomies();
?>
<dl class="vbp-accordion">
  <dt>
	<span class='video-blogster-label'><?php printf( esc_html__( '%s Metadata', 'video-blogster' ), $importType );?></span>
  </dt>
  <dd class='video-blogster-hidden'>
	<table class='form-table'>
	<tr>
<?php if ( in_array( 'category', $optImport ) ) : ?>
		<td>
			<div class='video-blogster-block span_3_of_12'>
			<label class='video-blogster-label' for='feed_add_source_cat'><?php esc_html_e( 'Import Category as', 'video-blogster' );?></label>
<a target="_blank" href="#" title="Import <?php echo $importType;?> category into this taxonomy, creating it if needed."><img width='16' height='16' alt='?' src='<?php echo plugins_url( '../images/question.png', __FILE__ );?>'></a>
			</div>
			<div class='video-blogster-block span_2_of_12'>
			<?php $optValue = $this->get_value( $args, 'cAddSourceCategory', '' ); ?>
			<?php if ( $optValue == "1" ) $optValue = 'category'; ?>
			<select class="vb-stretch" name="feed_add_source_cat" id="feed_add_source_cat">
				<option value="0">None</option>
<?php 				foreach ( $valid_taxonomies as $taxonomy ) { ?>
				<option value="<?php echo $taxonomy;?>" <?php echo ($optValue == $taxonomy) ? "SELECTED" : "" ?>><?php echo $taxonomy;?></option>
<?php				} ?>
			</select>
			</div>
			<div class='video-blogster-block span_2_of_12'></div>
<?php endif; ?>
<?php if ( in_array( 'tags', $optImport ) ) : ?>
			<div class='video-blogster-block span_3_of_12'>
			<label class='video-blogster-label' for='feed_grab_tags'><?php esc_html_e( 'Import Tags as', 'video-blogster' );?></label>
<a target="_blank" href="#" title="Import <?php echo $importType;?> tags into this taxonomy, creating them if needed."><img width='16' height='16' alt='?' src='<?php echo plugins_url( '../images/question.png', __FILE__ );?>'></a>
			</div>
			<div class='video-blogster-block span_2_of_12'>
			<?php $optValue = $this->get_value( $args, 'pGrabTags', '' ); ?>
			<?php if ( $optValue == "1" ) $optValue = 'post_tag'; ?>
			<select class="vb-stretch" name="feed_grab_tags" id="feed_grab_tags">
				<option value="0">None</option>
<?php 				foreach ( $valid_taxonomies as $taxonomy ) { ?>
				<option value="<?php echo $taxonomy;?>" <?php echo ($optValue == $taxonomy) ? "SELECTED" : "" ?>><?php echo $taxonomy;?></option>
<?php				} ?>
			</select>
			</div>
		</td>
<?php endif; ?>
	</tr>
<?php $isHidden = ($optValue == 0) ? "video-blogster-hidden" : ""; ?>
	<tr class="vb-query-tags <?php echo $isHidden;?>">
		<td>
			<div class='video-blogster-block span_3_of_12'>
			<label class='video-blogster-label' for='feed_min_tag_length'><?php esc_html_e( 'Minimum Tag Length', 'video-blogster' );?></label>
<a href="#" title="Tags less than this length will not be imported. 0 for no limit."><img width='16' height='16' alt='?' src='<?php echo plugins_url( '../images/question.png', __FILE__ );?>'></a>
			</div>
			<div class='video-blogster-block span_2_of_12'>
			<input class="vb-stretch" type="text" maxlength="2" name="feed_min_tag_length" id="feed_min_tag_length" value="<?php echo $this->get_value( $args, 'pMinTagLength', 0 ); ?>" />
			</div>
			<div class='video-blogster-block span_2_of_12'></div>
			<div class='video-blogster-block span_3_of_12'>
			<label class='video-blogster-label' for='feed_ignore_tags'><?php esc_html_e( 'Ignore these Tags', 'video-blogster' );?></label>
<a href="#" title="These tags will not be imported."><img width='16' height='16' alt='?' src='<?php echo plugins_url( '../images/question.png', __FILE__ );?>'></a>
			</div>
			<div class='video-blogster-block span_2_of_12'>
			<input class="vb-stretch" type="text" maxlength="256" name="feed_ignore_tags" id="feed_ignore_tags" value="<?php echo $this->get_value( $args, 'pIgnoreTags', '' ); ?>" />
			</div>
		</td>
	</tr>
	</table>
  </dd>
</dl>

