<div class="vbp-tab">
       <input class="vbp-tab-radio" type="radio" id="tab-process" name="tab-group-vbp">
       <label class="vbp-tab-label video-blogster-label" for="tab-process"><div class="dashicons dashicons-migrate"></div>Process the Results</label>

        <div class="vbp-tab-panel">
        <div class="vbp-tab-content">

	<p>The content returned from <?php echo $video_source;?> will then be processed using these rules.</p>

<dl class="vbp-accordion">
	<dt>
		<span class='video-blogster-label'><?php esc_html_e( 'Content Exclusion Rules', 'video-blogster' );?></span>
	</dt>
	<dd>
	<table class='form-table'>
	<tr>
		<td>
			<div class='video-blogster-block span_7_of_12'>
			<label class='video-blogster-label' for='feed_strict_title'><?php esc_html_e( 'Skip content that DOES NOT contain one of these keyphrases', 'video-blogster' );?></label>
<a href="#" title="A comma delimited list of terms. Content Title, Description, Tags, and Association (if any) will be searched."><img width='16' height='16' alt='?' src='<?php echo plugins_url( '../images/question.png', __FILE__ );?>'></a>
			</div>
			<div class='video-blogster-block span_5_of_12'>
			<input class="vb-stretch" type="text" maxlength="256" name="feed_strict_title" id="feed_strict_title" value="<?php echo $this->get_value( $args, 'pStrictTitle', '' ); ?>" />
			</div>
		</td>
	</tr>
	<tr>
		<td>
			<div class='video-blogster-block span_7_of_12'>
			<label class='video-blogster-label' for='feed_negate_title'><?php esc_html_e( 'Skip content that DOES contain one of these keyphrases', 'video-blogster' );?></label>
<a href="#" title="A comma delimited list of terms. Content Title, Description, Tags, and Association (if any) will be searched."><img width='16' height='16' alt='?' src='<?php echo plugins_url( '../images/question.png', __FILE__ );?>'></a>
			</div>
			<div class='video-blogster-block span_5_of_12'>
			<input class="vb-stretch" type="text" maxlength="256" name="feed_negate_title" id="feed_negate_title" value="<?php echo $this->get_value( $args, 'pNegateTitle', '' ); ?>" />
			</div>
		</td>
	</tr>
	<tr>
		<td>
			<div class='video-blogster-block span_3_of_12'>
			<label class='video-blogster-label' for='feed_min_views'><?php esc_html_e( 'Skip if views less than', 'video-blogster' );?></label>
			</div>
			<div class='video-blogster-block span_2_of_12'>
			<input class ="vb-stretch" type="text" maxlength="16" name="feed_min_views" id="feed_min_views" value="<?php echo $this->get_value( $args, 'pMinViews', 0, 1 ); ?>" />
			</div>
			<div class='video-blogster-block span_2_of_12'></div>
			<div class='video-blogster-block span_3_of_12'>
			<label class='video-blogster-label' for='feed_cutoff_date'><?php esc_html_e( 'Skip if date older than', 'video-blogster' );?></label>
<a href="#" title="Use absolute format 'Y-m-d' or relative format (ex: 1 month ago)."><img width='16' height='16' alt='?' src='<?php echo plugins_url( '../images/question.png', __FILE__ );?>'></a>
			</div>
			<div class='video-blogster-block span_2_of_12'>
			<input class="vb-stretch" type="text" maxlength="32" name="feed_cutoff_date" id="feed_cutoff_date" value="<?php echo $this->get_value( $args, 'pCutoffDate', '' ); ?>" />
			</div>
		</td>
	</tr>
	<tr>
		<td>
			<div class='video-blogster-block span_3_of_12'>
			<label class='video-blogster-label' for='feed_duration_min'><?php esc_html_e( 'Skip if duration less than', 'video-blogster' );?></label>
<a href="#" title="Enter duration in minutes."><img width='16' height='16' alt='?' src='<?php echo plugins_url( '../images/question.png', __FILE__ );?>'></a>
			</div>
			<div class='video-blogster-block span_2_of_12'>
			<input class="vb-stretch" type="text" maxlength="3" name="feed_duration_min" id="feed_duration_min" value="<?php echo $this->get_value( $args, 'pDurationMin', '' ); ?>" /> 
			</div>
			<div class='video-blogster-block span_2_of_12'></div>
			<div class='video-blogster-block span_3_of_12'>
			<label class='video-blogster-label' for='feed_duration_max'><?php esc_html_e( 'Skip if duration greater than', 'video-blogster' );?></label>
<a href="#" title="Enter duration in minutes."><img width='16' height='16' alt='?' src='<?php echo plugins_url( '../images/question.png', __FILE__ );?>'></a>
			</div>
			<div class='video-blogster-block span_2_of_12'>
			<input class="vb-stretch" type="text" maxlength="3" name="feed_duration_max" id="feed_duration_max" value="<?php echo $this->get_value( $args, 'pDurationMax', '' ); ?>" />
			</div>
		</td>
	</tr>
	<tr>
		<td>
			<div class='video-blogster-block span_3_of_12'>
			<label class='video-blogster-label' for='feed_no_thumbnails'><?php esc_html_e( 'Skip if no image?', 'video-blogster' );?></label>
<a href="#" title="In rare cases the source site does not render an image."><img width='16' height='16' alt='?' src='<?php echo plugins_url( '../images/question.png', __FILE__ );?>'></a>
			</div>
			<div class='video-blogster-block span_2_of_12'>
			<?php $optValue = $this->get_value( $args, 'pNoThumbnails', '' ); ?>
			<select class="vb-stretch" name="feed_no_thumbnails" id="feed_no_thumbnails">
<?php if ( $video_source === 'video sites' ) : ?>
				<option value="inherit">inherit</option>
<?php endif; ?>
				<option value="0">No</option>
				<option value="1" <?php echo ($optValue === '1') ? "SELECTED" : "" ?>>Yes</option>
			</select>
			</div>
			<div class='video-blogster-block span_2_of_12'></div>
			<div class='video-blogster-block span_3_of_12'>
			<label class='video-blogster-label' for='feed_update_existing'><?php esc_html_e( 'If content previously imported?', 'video-blogster' );?></label>
<a href="#" title="Content stats and comments can be updated."><img width='16' height='16' alt='?' src='<?php echo plugins_url( '../images/question.png', __FILE__ );?>'></a>
			</div>
			<div class='video-blogster-block span_2_of_12'>
			<?php $optValue = $this->get_value( $args, 'pUpdateExisting', '' ); ?>
			<select class="vb-stretch" name="feed_update_existing" id="feed_update_existing">
<?php if ( $video_source === 'video sites' ) : ?>
				<option value="inherit">inherit</option>
<?php endif; ?>
				<option value="0">Skip</option>
				<option value="1" <?php echo ($optValue === '1') ? "SELECTED" : "" ?>>Update</option>
			</select>
			</div>
		</td>
	</tr>
	</table>
	</dd>
</dl>


<dl class="vbp-accordion">
	<dt>
		<span class='video-blogster-label'><?php esc_html_e( 'Content Filters', 'video-blogster' );?></span>
	</dt>
	<dd>
	<table class='form-table'>
	<tr>
		<td>
			<div class='video-blogster-block span_3_of_12'>
			<label class='video-blogster-label' for='feed_translate_api'><?php esc_html_e( 'Translation Service', 'video-blogster' );?></label>
<a href="#" title="Either translation service requires a free or paid API key entered in Main Settings."><img width='16' height='16' alt='?' src='<?php echo plugins_url( '../images/question.png', __FILE__ );?>'></a>
			</div>
			<div class='video-blogster-block span_2_of_12'>
			<?php $optValue = $this->get_value( $args, 'pTranslateApi', '' ); ?>
			<select class="vb-stretch" name="feed_translate_api" id="feed_translate_api">
<?php if ( $video_source === 'video sites' ) : ?>
				<option value="inherit">inherit</option>
<?php endif; ?>
				<option value="">None</option>
				<option value="google" <?php echo ($optValue === "google") ? "SELECTED" : "" ?>>Google</option>
				<option value="ms azure" <?php echo ($optValue === "ms azure") ? "SELECTED" : "" ?>>MS Azure</option>
			</select>
			</div>
			<div class='video-blogster-block span_2_of_12'></div>
			<div class='video-blogster-block span_3_of_12'>
			<label class='video-blogster-label' for='feed_translate_to'><?php esc_html_e( 'Translate into Language', 'video-blogster' );?></label>
<a href="#" title="Note that translation services may have trouble if the content uses html tags."><img width='16' height='16' alt='?' src='<?php echo plugins_url( '../images/question.png', __FILE__ );?>'></a>
			</div>
                        <div class='video-blogster-block span_2_of_12'>
                        <?php $optValue = strtolower( $this->get_value( $args, 'pTranslateTo', '' ) ); ?>
                        <select class="vb-stretch" name="feed_translate_to" id="feed_translate_to">
<?php if ( $video_source === 'video sites' ) : ?>
				<option value="inherit">inherit</option>
<?php endif; ?>
<?php include( sprintf( "%stemplates/iso-639-1.php", $this->plugin['dir'] ) ); ?>
                        </select>
                        </div>
		</td>
	</tr>
	<tr>
		<td>
			<div class='video-blogster-block span_3_of_12'>
			<label class='video-blogster-label' for='feed_translate_content'><?php esc_html_e( 'Translate Content', 'video-blogster' );?></label>
<a href="#" title="Select whether to translate the video title and/or description."><img width='16' height='16' alt='?' src='<?php echo plugins_url( '../images/question.png', __FILE__ );?>'></a>
			</div>
			<div class='video-blogster-block span_2_of_12'>
			<?php $optValue = $this->get_value( $args, 'pTranslateContent', '' ); ?>
			<select class="vb-stretch" name ="feed_translate_content" id="feed_translate_content">
				<option value="TitleDesc">Title and Description</option>
				<option value="Title" <?php echo ($optValue === 'Title') ? "SELECTED" : "" ?>>Title Only</option>
				<option value="Desc" <?php echo ($optValue === 'Desc') ? "SELECTED" : "" ?>>Description Only</option>
			</select>
			</div>
			<div class='video-blogster-block span_2_of_12'></div>
			<div class='video-blogster-block span_3_of_12'>
			</div>
		</td>
	</tr>
	<tr>
		<td>
			<div class='video-blogster-block span_3_of_12'>
			<label class='video-blogster-label' for='feed_remove_desc_urls'><?php esc_html_e( 'Remove Description URLs', 'video-blogster' );?></label>
<a href="#" title="Completely remove any URLs found in content description."><img width='16' height='16' alt='?' src='<?php echo plugins_url( '../images/question.png', __FILE__ );?>'></a>
			</div>
			<div class='video-blogster-block span_2_of_12'>
			<?php $optValue = $this->get_value( $args, 'pRemoveDescUrls', '' ); ?>
			<select class="vb-stretch" name ="feed_remove_desc_urls" id="feed_remove_desc_urls">
<?php if ( $video_source === 'video sites' ) : ?>
				<option value="inherit">inherit</option>
<?php endif; ?>
				<option value="0">No</option>
				<option value="1" <?php echo ($optValue === '1') ? "SELECTED" : "" ?>>Yes</option>
			</select>
			</div>
			<div class='video-blogster-block span_2_of_12'></div>
			<div class='video-blogster-block span_3_of_12'>
			<label class='video-blogster-label' for='feed_remove_comm_urls'><?php esc_html_e( 'Remove Comment URLs', 'video-blogster' );?></label>
<a href="#" title="Completely remove any URLs found in content comments."><img width='16' height='16' alt='?' src='<?php echo plugins_url( '../images/question.png', __FILE__ );?>'></a>
			</div>
			<div class='video-blogster-block span_2_of_12'>
			<?php $optValue = $this->get_value( $args, 'pRemoveCommUrls', '' ); ?>
			<select class="vb-stretch" name ="feed_remove_comm_urls" id="feed_remove_comm_urls">
<?php if ( $video_source === 'video sites' ) : ?>
				<option value="inherit">inherit</option>
<?php endif; ?>
				<option value="0">No</option>
				<option value="1" <?php echo ($optValue === '1') ? "SELECTED" : "" ?>>Yes</option>
			</select>
			</div>
		</td>
	</tr>
	<tr>
		<td>
			<div class='video-blogster-block span_3_of_12'>
			<label class='video-blogster-label' for='feed_linkify_desc_urls'><?php esc_html_e( 'Linkify Description URLs', 'video-blogster' );?></label>
<a href="#" title="Linkify any URLs found in content description."><img width='16' height='16' alt='?' src='<?php echo plugins_url( '../images/question.png', __FILE__ );?>'></a>
			</div>
			<div class='video-blogster-block span_2_of_12'>
			<?php $optValue = $this->get_value( $args, 'pLinkifyDescUrls', '' ); ?>
			<select class="vb-stretch" name ="feed_linkify_desc_urls" id="feed_linkify_desc_urls">
<?php if ( $video_source === 'video sites' ) : ?>
				<option value="inherit">inherit</option>
<?php endif; ?>
				<option value="0">No</option>
				<option value="1" <?php echo ($optValue === '1') ? "SELECTED" : "" ?>>Yes</option>
			</select>
			</div>
			<div class='video-blogster-block span_2_of_12'></div>
			<div class='video-blogster-block span_3_of_12'>
			<label class='video-blogster-label' for='feed_linkify_comm_urls'><?php esc_html_e( 'Linkify Comment URLs', 'video-blogster' );?></label>
<a href="#" title="Linkify any URLs found in content comments."><img width='16' height='16' alt='?' src='<?php echo plugins_url( '../images/question.png', __FILE__ );?>'></a>
			</div>
			<div class='video-blogster-block span_2_of_12'>
			<?php $optValue = $this->get_value( $args, 'pLinkifyCommUrls', '' ); ?>
			<select class="vb-stretch" name ="feed_linkify_comm_urls" id="feed_linkify_comm_urls">
<?php if ( $video_source === 'video sites' ) : ?>
				<option value="inherit">inherit</option>
<?php endif; ?>
				<option value="0">No</option>
				<option value="1" <?php echo ($optValue === '1') ? "SELECTED" : "" ?>>Yes</option>
			</select>
			</div>
		</td>
	</tr>
	<tr>
		<td>
			<div class='video-blogster-block span_3_of_12'>
			<label class='video-blogster-label' for='feed_remove_title_chars'><?php esc_html_e( 'Remove these Chars from Title', 'video-blogster' );?></label>
<a href="#" title="Example: /*&^%$#@!"><img width='16' height='16' alt='?' src='<?php echo plugins_url( '../images/question.png', __FILE__ );?>'></a>
			</div>
			<div class='video-blogster-block span_2_of_12'>
			<input class="vb-stretch" type="text" maxlength="256" name="feed_remove_title_chars" id="feed_remove_title_chars" value="<?php echo $this->get_value( $args, 'pRemoveTitleChars', '' ); ?>" />
			</div>
		</td>
	</tr>
	<tr>
		<td>
			<div class='video-blogster-block span_3_of_12'>
			<label class='video-blogster-label' for='feed_limit_title_chars'><?php esc_html_e( 'Max Title Chars', 'video-blogster' );?></label>
<a href="#" title="Cuts long titles down to size, finding the closest word or phrase boundry. 0 for no limit.."><img width='16' height='16' alt='?' src='<?php echo plugins_url( '../images/question.png', __FILE__ );?>'></a>
			</div>
			<div class='video-blogster-block span_2_of_12'>
			<input class="vb-stretch" type="text" maxlength="4" name="feed_limit_title_chars" id="feed_limit_title_chars" value="<?php echo $this->get_value( $args, 'pLimitTitleChars', 0, 1 ); ?>" />
			</div>
			<div class='video-blogster-block span_2_of_12'></div>
			<div class='video-blogster-block span_3_of_12'>
			<label class='video-blogster-label' for='feed_limit_title_word'><?php esc_html_e( 'End Title at Phrase', 'video-blogster' );?></label>
<a href="#" title="Ends long titles to just before this phrase. Useful if source always appends their name to the title or similar."><img width='16' height='16' alt='?' src='<?php echo plugins_url( '../images/question.png', __FILE__ );?>'></a>
			</div>
			<div class='video-blogster-block span_2_of_12'>
			<input class="vb-stretch" type="text" maxlength="32" name="feed_limit_title_word" id="feed_limit_title_word" value="<?php echo $this->get_value( $args, 'pLimitTitleWord', '' ); ?>" />
			</div>
		</td>
	</tr>
	<tr>
		<td>
			<div class='video-blogster-block span_3_of_12'>
			<label class='video-blogster-label' for='feed_limit_desc_chars'><?php esc_html_e( 'Max Desc Chars', 'video-blogster' );?></label>
<a href="#" title="Cuts long descriptions down to size, finding the closest word or phrase boundry. 0 for no limit."><img width='16' height='16' alt='?' src='<?php echo plugins_url( '../images/question.png', __FILE__ );?>'></a>
			</div>
			<div class='video-blogster-block span_2_of_12'>
			<input class="vb-stretch" type="text" maxlength="4" name="feed_limit_desc_chars" id="feed_limit_desc_chars" value="<?php echo $this->get_value( $args, 'pLimitDescChars', 0, 1 ); ?>" />
			</div>
			<div class='video-blogster-block span_2_of_12'></div>
			<div class='video-blogster-block span_3_of_12'>
			<label class='video-blogster-label' for='feed_limit_desc_word'><?php esc_html_e( 'End Desc at Phrase', 'video-blogster' );?></label>
<a href="#" title="Ends long descriptions to just before this phrase. Useful if source always appends their description with 'Subscribe to my channel!' or similar."><img width='16' height='16' alt='?' src='<?php echo plugins_url( '../images/question.png', __FILE__ );?>'></a>
			</div>
			<div class='video-blogster-block span_2_of_12'>
			<input class="vb-stretch" type="text" maxlength="32" name="feed_limit_desc_word" id="feed_limit_desc_word" value="<?php echo $this->get_value( $args, 'pLimitDescWord', '' ); ?>" />
			</div>
		</td>
	</tr>
	<tr>
		<td>
			<div class='video-blogster-block span_3_of_12'>
			<label class='video-blogster-label' for='feed_sentence_remove'><?php esc_html_e( 'Desc Sentences to Remove', 'video-blogster' );?></label>
<a href="#" title="Removes the first X sentences from the description. Useful if source always prepends their description with 'Welcome to my channel!' or similar."><img width='16' height='16' alt='?' src='<?php echo plugins_url( '../images/question.png', __FILE__ );?>'></a>
			</div>
			<div class='video-blogster-block span_2_of_12'>
			<input class="vb-stretch" type="text" maxlength="4" name="feed_sentence_remove" id="feed_sentence_remove" value="<?php echo $this->get_value( $args, 'pSentenceRemove', 0, 1 ); ?>" />
			</div>
			<div class='video-blogster-block span_2_of_12'></div>
			<div class='video-blogster-block span_3_of_12'>
			<label class='video-blogster-label' for='feed_sentence_remove_phrase'><?php esc_html_e( 'Remove any Sentence with', 'video-blogster' );?></label>
<a href="#" title="Remove any sentence with these phrases. Useful for sources that spam certain things like 'Click Here' or 'support my channel'. Separate phrases with commas. 256 char limit."><img width='16' height='16' alt='?' src='<?php echo plugins_url( '../images/question.png', __FILE__ );?>'></a>
			</div>
			<div class='video-blogster-block span_2_of_12'>
			<input class="vb-stretch" type="text" maxlength="256" name="feed_sentence_remove_phrase" id="feed_sentence_remove_phrase" value="<?php echo $this->get_value( $args, 'pSentenceRemovePhrase', '' ); ?>" />
			</div>
		</td>
	</tr>
	<tr>
		<td>
			<div class='video-blogster-block span_12_of_12'>
			<label class='video-blogster-label' for='feed_replace_phrases'><?php esc_html_e( 'Replace phrases in title and/or description.', 'video-blogster' );?></label>
<a href="#" title="One rule per line in X=>Y format. Case sensitive. Supports spintax. See docs for examples."><img width='16' height='16' alt='?' src='<?php echo plugins_url( '../images/question.png', __FILE__ );?>'></a>
			<br>
			<?php $optValue = $this->get_value( $args, 'pReplacePhrases', '' ); ?>
			<textarea class="vb-stretch" rows="2" cols="100" name="feed_replace_phrases" id="feed_replace_phrases"><?php echo $optValue; ?></textarea>
			</div>
		</td>
	</tr>
	<tr>
		<td>
			<div class='video-blogster-block span_3_of_12'>
			<label class='video-blogster-label' for='feed_spinner'><?php esc_html_e( 'Spin Content with', 'video-blogster' );?></label>
<a href="#" title="Will only show detected and supported spinner software, like Spin Rewriter."><img width='16' height='16' alt='?' src='<?php echo plugins_url( '../images/question.png', __FILE__ );?>'></a>
			</div>
			<div class='video-blogster-block span_2_of_12'>
			<?php $optValue = $this->get_value( $args, 'pSpinner', '' ); ?>
			<select class="vb-stretch" name ="feed_spinner" id="feed_spinner">
<?php if ( $video_source === 'video sites' ) : ?>
				<option value="inherit">inherit</option>
<?php endif; ?>
				<option value="">No Spin</option>
<?php if ( is_plugin_active( 'wp-magic-spinner/wp-magic-spinner.php' ) ) : ?>
                                <option value="WP Magic Spinner" <?php echo ($optValue === 'WP Magic Spinner') ? "SELECTED" : "" ?>>WP Magic Spinner</option>
<?php endif; ?>
<?php if ( is_plugin_active( 'spin-rewriter-wp-plugin/spin-rewriter-wp-plugin.php' ) || is_plugin_active( 'spin-rewriter-wordpress-plugin/spin-rewriter-wordpress-plugin.php' ) ) : ?>
                                <option value="Spin Rewriter" <?php echo ($optValue == 'Spin Rewriter') ? "SELECTED" : "" ?>>Spin Rewriter</option>
<?php endif; ?>
			</select>
			</div>
			<div class='video-blogster-block span_2_of_12'></div>
			<div class='video-blogster-block span_3_of_12'>
			<label class='video-blogster-label' for='feed_spin_title'><?php esc_html_e( 'Spin Title', 'video-blogster' );?></label>
<a href="#" title="Will spin the Content Title."><img width='16' height='16' alt='?' src='<?php echo plugins_url( '../images/question.png', __FILE__ );?>'></a>
			</div>
			<div class='video-blogster-block span_2_of_12'>
			<?php $optValue = $this->get_value( $args, 'pSpinTitle', '' ); ?>
			<select class="vb-stretch" name ="feed_spin_title" id="feed_spin_title">
<?php if ( $video_source === 'video sites' ) : ?>
				<option value="inherit">inherit</option>
<?php endif; ?>
				<option value="0">No</option>
				<option value="1" <?php echo ($optValue === '1') ? "SELECTED" : "" ?>>Yes</option>
			</select>
			</div>
		</td>
	</tr>
	<tr>
		<td>
			<div class='video-blogster-block span_3_of_12'>
			<label class='video-blogster-label' for='feed_spin_desc'><?php esc_html_e( 'Spin Description', 'video-blogster' );?></label>
<a href="#" title="Will spin the Content Description."><img width='16' height='16' alt='?' src='<?php echo plugins_url( '../images/question.png', __FILE__ );?>'></a>
			</div>
			<div class='video-blogster-block span_2_of_12'>
			<?php $optValue = $this->get_value( $args, 'pSpinDesc', '' ); ?>
			<select class="vb-stretch" name ="feed_spin_desc" id="feed_spin_desc">
<?php if ( $video_source === 'video sites' ) : ?>
				<option value="inherit">inherit</option>
<?php endif; ?>
				<option value="0">No</option>
				<option value="1" <?php echo ($optValue === '1') ? "SELECTED" : "" ?>>Yes</option>
			</select>
			</div>
			<div class='video-blogster-block span_2_of_12'></div>
			<div class='video-blogster-block span_3_of_12'>
			<label class='video-blogster-label' for='feed_spin_captions'><?php esc_html_e( 'Spin Captions', 'video-blogster' );?></label>
<a href="#" title="Will spin the Content Captions, if applicable."><img width='16' height='16' alt='?' src='<?php echo plugins_url( '../images/question.png', __FILE__ );?>'></a>
			</div>
			<div class='video-blogster-block span_2_of_12'>
			<?php $optValue = $this->get_value( $args, 'pSpinCaptions', '' ); ?>
			<select class="vb-stretch" name ="feed_spin_captions" id="feed_spin_captions">
<?php if ( $video_source === 'video sites' ) : ?>
				<option value="inherit">inherit</option>
<?php endif; ?>
				<option value="0">No</option>
				<option value="1" <?php echo ($optValue === '1') ? "SELECTED" : "" ?>>Yes</option>
			</select>
			</div>
		</td>
	</tr>
<?php if ( ! isset( $args['func'] ) || $args['func'] != 'Make' ) : ?>
	<tr>
		<td>
			<div class='video-blogster-block span_12_of_12'>
                        <input type="checkbox" name="feed_process_retro" value="1" />
                        <?php _e ('Apply changes to existing content?', 'video-blogster' );?>
                        <?php esc_html_e( 'If checked, when you click \'Save\' all previous content/comments imported from this feed will be processed again with each content\'s <u>saved</u> meta data (will not import them again). WARNING: Can take a long time if there is lots of content - you are advised to first deactivate any other plugins that trigger when a post is updated and clear the Update Services in Settings->Writing. Also if lots of content, your server may timeout if not using mod_php.', 'video-blogster' );?>
			</div>
		</td>
	</tr>
<?php endif; ?>

	</table>
	</dd>
</dl>



        </div>
        </div>
</div>
