<div class="vbp-tab">
       <input class="vbp-tab-radio" type="radio" id="tab-query" name="tab-group-vbp" checked>
       <label class="vbp-tab-label video-blogster-label" for="tab-query"><div class="dashicons dashicons-editor-help"></div>Build <?php echo $video_source;?> Query</label>

        <div class="vbp-tab-panel">
        <div class="vbp-tab-content">

	<p><?php printf( esc_html__( 'This builds the query that will be sent to the %s API to retrieve videos.', 'video-blogster' ), $video_source ); ?></p>

<dl class="vbp-accordion">
  <dt>
	<span class='video-blogster-label'><?php esc_html_e( 'API Request', 'video-blogster' );?></span>
  </dt>
<?php
$importType = esc_html__( 'Video', 'video-blogster' );
$importTypes = esc_html__( 'Videos', 'video-blogster' );
$optValue = $this->get_value( $args, 'qAssocType', 'search');
$isSearch = ($optValue == 'search' || empty( $optValue ) ) ? "" : "video-blogster-hidden";
$isChannel = ($optValue == 'channel' ) ? "" : "video-blogster-hidden";
$isPlaylist = ($optValue == 'playlist' ) ? "" : "video-blogster-hidden";
$isUser = ($optValue == 'user' ) ? "" : "video-blogster-hidden";
$isVideo = ($optValue == 'video' ) ? "" : "video-blogster-hidden";
$VideoHide = ( empty( $isVideo ) ) ? "video-blogster-hidden" : "";
?>
  <dd class='video-blogster-hidden'>
	<table class='form-table'>
	<tr>
		<td>
			<div class='video-blogster-block span_3_of_12'>
			<label class='video-blogster-label' for='feed_numVideos'><?php printf( esc_html__( '%s to Request', 'video-blogster' ), $importTypes );?></label>
<a href="#" title="There is no documented limit to the number of videos requested. You can enter -1 to request all possible videos or X-Y to randomly select a number in that range."><img width='16' height='16' alt='?' src='<?php echo plugins_url( '../images/question.png', __FILE__ );?>'></a>
			</div>
			<div class='video-blogster-block span_2_of_12'>
			<input class="vb-stretch" type="text" maxlength="5" name="feed_numVideos" id="feed_numVideos" value="<?php echo $this->get_value( $args, 'qNumVideos', '1' ); ?>" />
			</div>
			<div class='video-blogster-block span_2_of_12'></div>
			<div class='video-blogster-block span_3_of_12'>
			<label class='video-blogster-label' for='dm_feed_assoc_type'><?php esc_html_e( 'Type of Request', 'video-blogster' );?></label>
			</div>
			<div class='video-blogster-block span_2_of_12'>
			<select class="vb-stretch" name="feed_assoc_type" id="dm_feed_assoc_type">
				<option value="search">search only</option>
				<option value="channel" <?php echo ($optValue == 'channel') ? "SELECTED" : "" ?>>channel</option>
				<option value="playlist" <?php echo ($optValue == 'playlist') ? "SELECTED" : "" ?>>playlist</option>
				<option value="user" <?php echo ($optValue == 'user') ? "SELECTED" : "" ?>>user</option>
				<option value="video" <?php echo ($optValue == 'video') ? "SELECTED" : "" ?>>video id</option>
			</select>
			</div>
		</td>
	</tr>
<?php $isHidden = ( empty( $isSearch ) ) ? 'video-blogster-hidden' : '';?>
	<tr class="vb-dm-id-row <?php echo $isHidden;?>">
		<td>
			<div class='video-blogster-block span_2_of_12'>
<?php
	$qAssoc = $this->get_value( $args, 'qAssoc', '' );
	$for = "for='feed_assoc'";
	$link = null;
	if ( ! empty( $qAssoc ) ) {
		if ( empty( $isChannel ) ) $link = 'http://www.dailymotion.com/us/channel/' . $qAssoc;
		else if ( empty( $isPlaylist ) ) $link = 'http://www.dailymotion.com/playlist/' . $qAssoc;
		else if ( empty( $isUser ) ) $link = 'https://www.dailymotion.com/' . $qAssoc;
		else if ( empty( $isVideo ) ) $link = 'http://www.dailymotion.com/video/' . $qAssoc;
		if ( $link ) {
			echo "<a class='video-blogster-label' target='_blank' href='{$link}'>"; 
			$for = null;
		}
	} 
?>
			<label <?php echo $for;?> class="video-blogster-label <?php echo $isChannel;?> vb-dm-assoc-label vb-dm-channel-id"><?php esc_html_e( 'Channel ID', 'video-blogster' );?></label>
			<label <?php echo $for;?> class="video-blogster-label <?php echo $isPlaylist;?> vb-dm-assoc-label vb-dm-playlist-id"><?php esc_html_e( 'Playlist ID', 'video-blogster' );?></label>
			<label <?php echo $for;?> class="video-blogster-label <?php echo $isUser;?> vb-dm-assoc-label vb-dm-user-id"><?php esc_html_e( 'User ID', 'video-blogster' );?></label>
			<label <?php echo $for;?> class="video-blogster-label <?php echo $isVideo;?> vb-dm-assoc-label vb-dm-video-id"><?php esc_html_e( 'Video ID', 'video-blogster' );?></label>
<?php if ( $qAssoc && $link ) echo "</a>\n"; ?>
			</div>
			<div class='video-blogster-block span_3_of_12'>
			<input class="vb-stretch vb-dm-assoc" type="text" maxlength="256" name="feed_assoc" id="feed_assoc" value="<?php echo $this->get_value( $args, 'qAssoc', '' ); ?>" />
			</div>
			<div class='video-blogster-block span_2_of_12'></div>
			<div class='video-blogster-block span_5_of_12 video-blogster-text-center'>
				<img class="vb-dm-id-example <?php echo $isChannel;?> vb-dm-channel-id" width='228' height='25' alt='DailyMotion Channel ID example' src='<?php echo plugins_url( '../images/dm-channel-id.jpg', __FILE__ );?>'>
				<img class="vb-dm-id-example <?php echo $isPlaylist;?> vb-dm-playlist-id" width='208' height='25' alt='DailyMotion Playlist ID example' src='<?php echo plugins_url( '../images/dm-playlist-id.jpg', __FILE__ );?>'>
				<img class="vb-dm-id-example <?php echo $isUser;?> vb-dm-user-id" width='154' height='25' alt='DailyMotion User ID example' src='<?php echo plugins_url( '../images/dm-user-id.jpg', __FILE__ );?>'>
				<img class="vb-dm-id-example <?php echo $isVideo;?> vb-dm-video-id" width='202' height='25' alt='DailyMotion Video ID example' src='<?php echo plugins_url( '../images/dm-video-id.jpg', __FILE__ );?>'>
			</div>
		</td>
	</tr>
	<tr class="vb-dm-search-order-row <?php echo $VideoHide;?>">
		<td>
			<div class='video-blogster-block span_2_of_12'>
			<label class='video-blogster-label vb-dm-search' for='feed_keyphrase'>
			<?php esc_html_e( 'Search Terms', 'video-blogster' );?> 
			</label>
<a href="#" title='Search terms default to using the OR operator. Use quotes for the AND parameter, such "Vero Beach Hotel".'><img width='16' height='16' alt='?' src='<?php echo plugins_url( '../images/question.png', __FILE__ );?>'></a>
			</div>
			<div class='video-blogster-block span_3_of_12'>
			<input class="vb-stretch vb-dm-search" type="text" maxlength="256" name="feed_keyphrase" id="feed_keyphrase" value="<?php echo $this->get_value( $args, 'qKeyphrase', '' ); ?>" />
			</div>
			<div class='video-blogster-block span_2_of_12'></div>
			<div class='video-blogster-block span_3_of_12'>
			<label class='video-blogster-label vb-dm-order' for='feed_orderby'><?php esc_html_e( 'Sort Videos by', 'video-blogster' );?></label>
			</div>
			<div class='video-blogster-block span_2_of_12'>
			<?php $optValue = $this->get_value( $args, 'qOrderBy', 'recent'); ?>
			<select class="vb-stretch vb-dm-order" name="feed_orderby" id="feed_orderby">
				<option value="recent" <?php echo ($optValue == 'recent') ? "SELECTED" : "" ?>>recent</option>
				<option value="relevance" <?php echo ($optValue == 'relevance') ? "SELECTED" : "" ?>>search relevance</option>
				<option value="visited" <?php echo ($optValue == 'visited') ? "SELECTED" : "" ?>>visited</option>
				<option value="visited-hour" <?php echo ($optValue == 'visited-hour') ? "SELECTED" : "" ?>>visited-hour</option>
				<option value="visited-today" <?php echo ($optValue == 'visited-today') ? "SELECTED" : "" ?>>visited-today</option>
				<option value="visited-week" <?php echo ($optValue == 'visited-week') ? "SELECTED" : "" ?>>visited-week</option>
				<option value="visited-month" <?php echo ($optValue == 'visited-month') ? "SELECTED" : "" ?>>visited-month</option>
				<option value="random" <?php echo ($optValue == 'random') ? "SELECTED" : "" ?>>random</option>
				<option value="trending" <?php echo ($optValue == 'trending') ? "SELECTED" : "" ?>>trending</option>
				<option value="old" <?php echo ($optValue == 'old') ? "SELECTED" : "" ?>>old</option>
				<option value="live-audience" <?php echo ($optValue == 'live-audience') ? "SELECTED" : "" ?>>live-audience</option>
				<option value="least-visited" <?php echo ($optValue == 'least-visited') ? "SELECTED" : "" ?>>least-visited</option>
				<option value="live-airing-time" <?php echo ($optValue == 'live-airing-time') ? "SELECTED" : "" ?>>live-airing-time</option>
			</select>
			</div>
		</td>
	</tr>
<?php $isHidden = ( empty( $isVideo ) ) ? 'video-blogster-hidden' : '';?>
        <tr class="vb-behaviour <?php echo $isHidden;?>">
		<td>
			<div class='video-blogster-block span_3_of_12'>
			<label class='video-blogster-label' for='feed_query_behavior'><?php esc_html_e( 'Query Behavior', 'video-blogster' );?></label>
<a href="#" title="STRICT queries will request exactly X videos, skipping/updating any duplicates. CONTINUOUS queries will keep requesting videos until X videos are imported, skipping/updating any duplicates."><img width='16' height='16' alt='?' src='<?php echo plugins_url( '../images/question.png', __FILE__ );?>'></a>
			</div>
			<div class='video-blogster-block span_2_of_12'>
			<?php $optValue = $this->get_value( $args, 'qQueryBehavior', FALSE ); ?>
			<select class="vb-stretch" name="feed_query_behavior" id="feed_query_behavior">
				<option value="strict">Strict</option>
				<option value="continuous" <?php echo ($optValue == 'continuous') ? "SELECTED" : "" ?>>Continuous</option>
			</select>
			</div>
		</td>
	</tr>
	<tr>
		<td>

<div class="vb-dm-id-example <?php echo $isPlaylist;?> vb-dm-playlist-filters span_12_of_12">
DailyMotion does not support playlist filters. The playlist videos are returned as they are listed.<br><br>
</div>
<div class="vb-dm-id-example <?php echo $isVideo;?> vb-dm-video-filters span_12_of_12">
Requests for a specific video do not need search filters.<br><br>
</div>
		</td>
	</tr>
</table>
	</dd>
</dl>

<dl class="vbp-accordion vb-dm-filters <?php echo $VideoHide;?>">
  <dt>
	<span class='video-blogster-label'><?php esc_html_e( 'Search Filters', 'video-blogster' );?></span>
  </dt>
  <dd>
	<table class='form-table'>
<?php $isHidden = ( empty( $isChannel) || empty( $isUser ) ) ? 'video-blogster-hidden' : '';?>
	<tr class='vb-dm-country-region <?php echo $isHidden;?>'>
		<td>
			<div class='video-blogster-block span_3_of_12'>
			<label class='video-blogster-label' for='feed_region_code'><?php esc_html_e( 'Country', 'video-blogster' );?></label>
<a href="#" title="Instructs the API to return search results for videos that can only be viewed in the specified 2-letter country code."><img width='16' height='16' alt='?' src='<?php echo plugins_url( '../images/question.png', __FILE__ );?>'></a>
			</div>
			<div class='video-blogster-block span_2_of_12'>
			<input class="vb-stretch" type="text" maxlength="8" name="feed_region_code" id="feed_region_code" value="<?php echo $this->get_value( $args, 'qRegionCode', '' ); ?>" />
			</div>
			<div class='video-blogster-block span_2_of_12'></div>
			<div class='video-blogster-block span_3_of_12'>
			<label class='video-blogster-label' for='feed_language'><?php esc_html_e( 'Relevance Language', 'video-blogster' );?></label>
<a href="#" title="Instructs the API to return search results that are most relevant to the specified language."><img width='16' height='16' alt='?' src='<?php echo plugins_url( '../images/question.png', __FILE__ );?>'></a>
			</div>
			<div class='video-blogster-block span_2_of_12'>
			<?php $optValue = strtolower( $this->get_value( $args, 'qLanguage', '' ) ); ?>
			<select class="vb-stretch" name="feed_language" id="feed_language">
<?php include( sprintf( "%stemplates/iso-639-1.php", $this->plugin['dir'] ) ); ?>
			</select>
			</div>
		</td>
	</tr>
	<tr class='vb-dm-created'>
		<td>
			<div class='video-blogster-block span_3_of_12'>
			<label class='video-blogster-label' for='feed_pub_after'><?php esc_html_e( 'Created After', 'video-blogster' );?></label>
<a href="#" title="Indicates that the API response should only contain resources created at or after the specified time. The value is an RFC 3339 formatted date-time value (1970-01-01T00:00:00Z) or relative time (1 month ago)."><img width='16' height='16' alt='?' src='<?php echo plugins_url( '../images/question.png', __FILE__ );?>'></a>
			</div>
			<div class='video-blogster-block span_2_of_12'>
			<input class="vb-stretch" type="text" size="20" maxlength="32" name="feed_pub_after" id="feed_pub_after" value="<?php echo $this->get_value( $args, 'qPublishedAfter', '' ); ?>" />
			</div>
			<div class='video-blogster-block span_2_of_12'></div>
			<div class='video-blogster-block span_3_of_12'>
			<label class='video-blogster-label' for='feed_pub_before'><?php esc_html_e( 'Created Before', 'video-blogster' );?></label>
<a href="#" title="Indicates that the API response should only contain resources created before or at the specified time. The value is an RFC 3339 formatted date-time value (1970-01-01T00:00:00Z) or relative time (1 month ago)."><img width='16' height='16' alt='?' src='<?php echo plugins_url( '../images/question.png', __FILE__ );?>'></a>
			</div>
			<div class='video-blogster-block span_2_of_12'>
			<input class="vb-stretch" type="text" size="20" maxlength="32" name="feed_pub_before" id="feed_pub_before" value="<?php echo $this->get_value( $args, 'qPublishedBefore', '' ); ?>" />
			</div>
		</td>
	</tr>
	<tr>
		<td>
			<div class='video-blogster-block span_3_of_12'>
			<label class='video-blogster-label' for='feed_extra_params'><?php esc_html_e( 'Other Filters', 'video-blogster' );?></label>
<a target="_blank" href="https://developer.dailymotion.com/tools#/video/list" title="This covers any of the rarer DailyMotion search parameters NOT on this page. This field is added on to the end of the query URL. For instance, to restrict your query to search only HD videos related to a video-game, you would enter 'flags=has_game,hd'."><img width='16' height='16' alt='?' src='<?php echo plugins_url( '../images/question.png', __FILE__ );?>'></a>
			</div>
			<div class='video-blogster-block span_9_of_12'>
			<input class="vb-stretch" type="text" maxlength="256" name="feed_extra_params" id="feed_extra_params" value="<?php echo $this->get_value( $args, 'qExtraParams', '' ); ?>" />
			</div>
		</td>
	</tr>
	</table>
  </dd>
</dl>

<?php $optImport = array( 'category', 'tags' ); ?>
<?php include( sprintf( "%stemplates/metadata.php", $this->plugin['dir'] ) ); ?>

<dl class="vbp-accordion">
  <dt>
	<span class='video-blogster-label'><?php printf( esc_html__( '%s Image', 'video-blogster' ), $importType );?></span>
  </dt>
  <dd class='video-blogster-hidden'>
	<table class='form-table'>
	<tr>
		<td>
			<div class='video-blogster-block span_12_of_12'>
			<?php $optValue = $this->get_value( $args, 'qImageImport', 1 ); ?>
			<input type="checkbox" name="feed_image_import" value=1 <?php echo ($optValue == 1) ? "CHECKED" : "" ?>/>
			<label class='video-blogster-label' for='feed_extra_params2'><?php esc_html_e( 'Import featured image quality', 'video-blogster' );?></label>
			<?php $optValue = $this->get_value( $args, 'qExtraParams2', 'original' ); ?>
			<select name="feed_extra_params2" id="feed_extra_params2">
				<option value="original">original</option>
				<option value="720px" <?php echo ($optValue == '720px') ? "SELECTED" : "" ?>>720px height</option>
				<option value="480px" <?php echo ($optValue == '480px') ? "SELECTED" : "" ?>>480px height</option>
				<option value="360px" <?php echo ($optValue == '360px') ? "SELECTED" : "" ?>>360px height</option>
				<option value="240px" <?php echo ($optValue == '240px') ? "SELECTED" : "" ?>>240px height</option>
				<option value="180px" <?php echo ($optValue == '180px') ? "SELECTED" : "" ?>>180px height</option>
				<option value="120px" <?php echo ($optValue == '120px') ? "SELECTED" : "" ?>>120px height</option>
				<option value="60px" <?php echo ($optValue == '60px') ? "SELECTED" : "" ?>>60px height</option>
			</select>
			</div>
		</td>
	</tr>
	<tr>
		<td>
<?php
    	$vbp_image_id = $this->get_value( $args, 'qImageId', 0 );
	if ( $vbp_image_id )
		$image = wp_get_attachment_image( $vbp_image_id, 'medium', false, array( 'id' => 'vbp-preview-image' ) );
	else
         	$image = "<img id='vbp-preview-image' src='' >";
?>
	<div class='video-blogster-block span_12_of_12'>
	<label class='video-blogster-label' for='feed_image_attachment_id'>
        <input type='hidden' name='feed_image_attachment_id' id='feed_image_attachment_id' value='<?php echo $vbp_image_id; ?>'>
	<?php esc_html_e( 'or ', 'video-blogster' );?>
        <input type="button" class="button" value="<?php _e( 'Select an image', 'video-blogster' ); ?>" id="vbp_media_manager" />
	<?php esc_html_e( ' to use as featured image for all imported videos.', 'video-blogster' );?>
	</label>

	<p>
	<?php echo ( $image ); ?>
	</p>

	</div>
		</td>
	</tr>
	</table>
  </dd>
</dl>



<dl class="vbp-accordion">
  <dt>
	<span class='video-blogster-label'><?php printf( esc_html__( '%s Comments', 'video-blogster' ), $importType );?></span>
  </dt>
  <dd class='video-blogster-hidden'>
	<table class='form-table'>
	<tr>
		<td>
			<div class='video-blogster-block span_3_of_12'>
			<label class='video-blogster-label' for='feed_num_comments'><?php esc_html_e( 'Comments to Request', 'video-blogster' );?></label>
<a href="#" title="Comments to request for each video imported. Use -1 to request all comments or X-Y to randomly select a number in that range."><img width='16' height='16' alt='?' src='<?php echo plugins_url( '../images/question.png', __FILE__ );?>'></a>
			</div>
			<div class='video-blogster-block span_2_of_12'>
			<input class="vb-stretch" type="text" maxlength="4" name="feed_num_comments" id="feed_num_comments" value="<?php echo $this->get_value( $args, 'qNumComments', '', 1 ); ?>" />
			</div>
		</td>
	</tr>
	</table>
  </dd>
</dl>


		</td>
	</tr>
	</table>

        </div>
        </div>
</div>
