<div class="vbp-tab">
       <input class="vbp-tab-radio" type="radio" id="tab-query" name="tab-group-vbp" checked>
       <label class="vbp-tab-label video-blogster-label" for="tab-query"><div class="dashicons dashicons-editor-help"></div>Build <?php echo $video_source;?> Query</label>

        <div class="vbp-tab-panel">
        <div class="vbp-tab-content">

	<p><?php printf( esc_html__( 'This builds the query that will be sent to the %s API to retrieve videos.', 'video-blogster' ), $video_source ); ?></p>

<dl class="vbp-accordion">
  <dt>
	<span class='video-blogster-label'><?php esc_html_e( 'API Request', 'video-blogster' );?></span>
  </dt>
<?php
$importType = esc_html__( 'Video', 'video-blogster' );
$importTypes = esc_html__( 'Videos', 'video-blogster' );
?>
  <dd class='video-blogster-hidden'>
	<table class='form-table'>
	<tr>
		<td>
			<div class='video-blogster-block span_3_of_12'>
			<label class='video-blogster-label' for='feed_numVideos'><?php printf( esc_html__( '%s to Request', 'video-blogster' ), $importTypes );?></label>
<a href="#" title="GiantBomb rate limit default is 200 requests per hour. You can enter -1 to request all possible videos or X-Y to randomly select a number in that range."><img width='16' height='16' alt='?' src='<?php echo plugins_url( '../images/question.png', __FILE__ );?>'></a>
			</div>
			<div class='video-blogster-block span_2_of_12'>
			<input class="vb-stretch" type="text" maxlength="5" name="feed_numVideos" id="feed_numVideos" value="<?php echo $this->get_value( $args, 'qNumVideos', '1' ); ?>" />
			</div>
			<div class='video-blogster-block span_2_of_12'></div>
			<div class='video-blogster-block span_3_of_12'>
			<label class='video-blogster-label' for='feed_search_category'><?php esc_html_e( 'Video Type', 'video-blogster' );?></label>
			</div>
			<div class='video-blogster-block span_2_of_12'>
			<?php $optValue = $this->get_value( $args, 'qCategory', 0 ); ?>
                        <?php
                        $args['videoSource'] = 'GiantBomb';
                        $this->create_video_source( $args );
			$categories = isset( $this->video_source ) ? $this->video_source->grab_categories() : array();
			?>
			<select name="feed_search_category" id="feed_search_category">
				<option value="">Any</option>
			<?php
			foreach ( $categories->results->video_type as $cat ) {
			?>
				<option value="<?php echo $cat->id;?>" <?php echo ($optValue == $cat->id) ? "SELECTED" : "" ?>><?php echo (string)$cat->name; ?></option>
			<?php
			}
			?>
			</select>
			</div>
		</td>
	</tr>
	<tr>
		<td>
			<div class='video-blogster-block span_2_of_12'>
			<label class='video-blogster-label' for='feed_keyphrase'>
			<?php esc_html_e( 'Video Filters', 'video-blogster' );?> 
			</label>
			</div>
			<div class='video-blogster-block span_3_of_12'>
			<span class='vb-dm-search'>
			<input class="vb-stretch" type="text" maxlength="256" name="feed_keyphrase" id="feed_keyphrase" value="<?php echo $this->get_value( $args, 'qKeyphrase', '' ); ?>" />
			</span>
			</div>
			<div class='video-blogster-block span_2_of_12'></div>
			<div class='video-blogster-block span_3_of_12'>
			<label class='video-blogster-label' for='feed_orderby'>
			<?php esc_html_e( 'Sort Results By', 'video-blogster' );?> 
<a target="_blank" href="https://www.giantbomb.com/api/documentation#toc-0-48" title="Sorts are in field:direction format."><img width='16' height='16' alt='?' src='<?php echo plugins_url( '../images/question.png', __FILE__ );?>'></a>
			</label>
			</div>
			<div class='video-blogster-block span_2_of_12'>
			<?php $optValue = $this->get_value( $args, 'qOrderBy', 'publish_date:desc' ); if ( false === strpos( $optValue, ':' ) ) $optValue = 'publish_date:desc'; ?>
			<input class="vb-stretch" type="text" maxlength="256" name="feed_orderby" id="feed_orderby" value="<?php echo $optValue; ?>" />
			</div>
		</td>
	</tr>
	<tr>
		<td>

<div class="span_12_of_12">
			<?php printf( 
				esc_html__( "GiantBomb provides all their %sfilter options%s in the videos filter parameter.", 'video-blogster' ), 
				'<a target="_blank" href="' . esc_url( 'http://www.giantbomb.com/api/documentation#toc-0-48' ) . '">',
				'</a>'
			);?>
			<br>
			<?php esc_html__( "Examples:", 'video-blogster' ); ?>
			<br>
			<?php printf( esc_html__( "%sname:Call of Duty%s => search for videos that contain Call of Duty in the name.", 'video-blogster' ),
				'<strong>',
				'</strong>'
			 );?>
			<br>
			<?php printf( esc_html__( "%sdeck:Call of Duty%s => search for video that contain Call of Duty in the summary.", 'video-blogster' ),
				'<strong>',
				'</strong>'
			 );?>
			<br>
			<?php printf( esc_html__( "%sname:Call of Duty,deck:Call of Duty%s => search for videos that contain Call of Duty in the name or summary.", 'video-blogster' ),
				'<strong>',
				'</strong>'
			 );?>
			<br>
			<?php printf( esc_html__( "%sid:11835%s => search for the video with this unique id.", 'video-blogster' ),
				'<strong>',
				'</strong>'
			 );?>
			<br>
			<?php printf( esc_html__( "%spublish_date:2017-02-01|2017-02-02%s => search for videos published between these two dates.", 'video-blogster' ),
				'<strong>',
				'</strong>'
			 );?>
</div>
		</td>
	</tr>
	<tr class="vb-behaviour">
		<td>
			<div class='video-blogster-block span_3_of_12'>
			<label class='video-blogster-label' for='feed_query_behavior'><?php esc_html_e( 'Query Behavior', 'video-blogster' );?></label>
<a href="#" title="STRICT queries will request exactly X videos, skipping/updating any duplicates. CONTINUOUS queries will keep requesting videos until X videos are imported, skipping/updating any duplicates."><img width='16' height='16' alt='?' src='<?php echo plugins_url( '../images/question.png', __FILE__ );?>'></a>
			</div>
			<div class='video-blogster-block span_2_of_12'>
			<?php $optValue = $this->get_value( $args, 'qQueryBehavior', FALSE ); ?>
			<select class="vb-stretch" name="feed_query_behavior" id="feed_query_behavior">
				<option value="strict">Strict</option>
				<option value="continuous" <?php echo ($optValue == 'continuous') ? "SELECTED" : "" ?>>Continuous</option>
			</select>
			</div>
		</td>
	</tr>
</table>
	</dd>
</dl>


<?php $optImport = array( 'category' ); ?>
<?php include( sprintf( "%stemplates/metadata.php", $this->plugin['dir'] ) ); ?>

<dl class="vbp-accordion">
  <dt>
	<span class='video-blogster-label'><?php esc_html_e( 'Video Image', 'video-blogster' );?></span>
  </dt>
  <dd class='video-blogster-hidden'>
	<table class='form-table'>
	<tr>
		<td>
			<div class='video-blogster-block span_12_of_12'>
			<?php $optValue = $this->get_value( $args, 'qImageImport', 1 ); ?>
			<input type="checkbox" name="feed_image_import" value=1 <?php echo ($optValue == 1) ? "CHECKED" : "" ?>/>
			<label class='video-blogster-label' for='feed_extra_params2'><?php esc_html_e( 'Import featured image quality', 'video-blogster' );?></label>
			<?php $optValue = $this->get_value( $args, 'qExtraParams2', 'super' ); ?>
			<select name="feed_extra_params2" id="feed_extra_params2">
				<option value="super">super</option>
				<option value="medium" <?php echo ($optValue == 'medium') ? "SELECTED" : "" ?>>medium</option>
				<option value="small" <?php echo ($optValue == 'small') ? "SELECTED" : "" ?>>small</option>
			</select>
			</div>
		</td>
	</tr>
	<tr>
		<td>
<?php
    	$vbp_image_id = $this->get_value( $args, 'qImageId', 0 );
	if ( $vbp_image_id )
		$image = wp_get_attachment_image( $vbp_image_id, 'medium', false, array( 'id' => 'vbp-preview-image' ) );
	else
         	$image = "<img id='vbp-preview-image' src='' >";
?>
	<div class='video-blogster-block span_12_of_12'>
	<label class='video-blogster-label' for='feed_image_attachment_id'>
        <input type='hidden' name='feed_image_attachment_id' id='feed_image_attachment_id' value='<?php echo $vbp_image_id; ?>'>
	<?php esc_html_e( 'or ', 'video-blogster' );?>
        <input type="button" class="button" value="<?php _e( 'Select an image', 'video-blogster' ); ?>" id="vbp_media_manager" />
	<?php esc_html_e( ' to use as featured image for all imported videos.', 'video-blogster' );?>
	</label>

	<p>
	<?php echo ( $image ); ?>
	</p>

	</div>
		</td>
	</tr>
	</table>
  </dd>
</dl>


		</td>
	</tr>
	</table>

        </div>
        </div>
</div>
