<div class="vbp-tab">
       <input class="vbp-tab-radio" type="radio" id="tab-query" name="tab-group-vbp" checked>
       <label class="vbp-tab-label video-blogster-label" for="tab-query"><div class="dashicons dashicons-editor-help"></div>Build <?php echo $video_source;?> Query</label>

        <div class="vbp-tab-panel">
        <div class="vbp-tab-content">

	<p><?php printf( esc_html__( 'This builds the query that will be sent to the %s API to retrieve tracks.', 'video-blogster' ), $video_source ); ?></p>

<dl class="vbp-accordion">
  <dt>
	<span class='video-blogster-label'><?php esc_html_e( 'API Request', 'video-blogster' );?></span>
  </dt>
<?php
$importType = esc_html__( 'Track', 'video-blogster' );
$importTypes = esc_html__( 'Tracks', 'video-blogster' );
$optValue = $this->get_value( $args, 'qAssocType', 'search');
$isSearch = ($optValue == 'search' || empty( $optValue ) ) ? "" : "video-blogster-hidden";
$isPlaylist = ($optValue == 'playlist' ) ? "" : "video-blogster-hidden";
$isTrack = ($optValue == 'track' ) ? "" : "video-blogster-hidden";
$isUser = ($optValue == 'user' ) ? "" : "video-blogster-hidden";
?>
  <dd class='video-blogster-hidden'>
	<table class='form-table'>
	<tr>
		<td>
			<div class='video-blogster-block span_3_of_12'>
			<label class='video-blogster-label' for='feed_numVideos'><?php printf( esc_html__( '%s to Request', 'video-blogster' ), $importTypes );?></label>
<a href="#" title="There is no documented limit to the number of tracks requested. You can enter -1 to request all possible tracks or X-Y to randomly select a number in that range."><img width='16' height='16' alt='?' src='<?php echo plugins_url( '../images/question.png', __FILE__ );?>'></a>
			</div>
			<div class='video-blogster-block span_2_of_12'>
			<input class="vb-stretch" type="text" maxlength="5" name="feed_numVideos" id="feed_numVideos" value="<?php echo $this->get_value( $args, 'qNumVideos', '1' ); ?>" />
			</div>
			<div class='video-blogster-block span_2_of_12'></div>
			<div class='video-blogster-block span_3_of_12'>
			<label class='video-blogster-label' for='sound_feed_assoc_type'><?php esc_html_e( 'Type of Request', 'video-blogster' );?></label>
			</div>
			<div class='video-blogster-block span_2_of_12'>
			<select class="vb-stretch" name="feed_assoc_type" id="sound_feed_assoc_type">
				<option value="search">search only</option>
				<option value="playlist" <?php echo ($optValue == 'playlist') ? "SELECTED" : "" ?>>playlist</option>
				<option value="track" <?php echo ($optValue == 'track') ? "SELECTED" : "" ?>>track</option>
				<option value="user" <?php echo ($optValue == 'user') ? "SELECTED" : "" ?>>user</option>
			</select>
			</div>
		</td>
	</tr>
<?php $isHidden = ( empty( $isSearch ) ) ? 'video-blogster-hidden' : '';?>
	<tr class="vb-sound-id-row <?php echo $isHidden;?>">
		<td>
			<div class='video-blogster-block span_3_of_12'>
<?php
	$qAssoc = $this->get_value( $args, 'qAssoc', '' );
	$for = "for='feed_assoc'";
	if ( ! empty( $qAssoc ) ) {
		echo "<a class='video-blogster-label' target='_blank' href='{$qAssoc}'>";
		$for = null;
	} 
?>
			<label <?php echo $for;?> class="video-blogster-label <?php echo $isPlaylist;?> vb-sound-assoc-label vb-sound-playlist-id"><?php esc_html_e( 'Playlist URL', 'video-blogster' );?></label>
			<label <?php echo $for;?> class="video-blogster-label <?php echo $isTrack;?> vb-sound-assoc-label vb-sound-track-id"><?php esc_html_e( 'Track URL', 'video-blogster' );?></label>
			<label <?php echo $for;?> class="video-blogster-label <?php echo $isUser;?> vb-sound-assoc-label vb-sound-user-id"><?php esc_html_e( 'User URL', 'video-blogster' );?></label>
<?php if ( $qAssoc ) echo "</a>\n"; ?>
<a href="#" title="Enter the full URL to the resource, such as https://soundcloud.com/telepopmusiktm/sets/fever-trymeanyway"><img width='16' height='16' alt='?' src='<?php echo plugins_url( '../images/question.png', __FILE__ );?>'></a>
			</div>
			<div class='video-blogster-block span_9_of_12'>
			<input class="vb-stretch vb-sound-assoc" type="text" maxlength="256" name="feed_assoc" id="feed_assoc" value="<?php echo $this->get_value( $args, 'qAssoc', '' ); ?>" />
			</div>
	</tr>
<?php $isHidden = ( empty( $isSearch ) ) ? '' : 'video-blogster-hidden';?>
	<tr class="vb-sound-search-row <?php echo $isSearch;?>">
		<td>
			<div class='video-blogster-block span_3_of_12'>
			<label class='video-blogster-label vb-sound-search' for='feed_keyphrase'>
			<?php esc_html_e( 'Search Terms', 'video-blogster' );?> 
			</label>
			</div>
			<div class='video-blogster-block span_9_of_12'>
			<input class="vb-stretch vb-sound-search" type="text" maxlength="256" name="feed_keyphrase" id="feed_keyphrase" value="<?php echo $this->get_value( $args, 'qKeyphrase', '' ); ?>" />
			</div>
		</td>
	</tr>
        <tr>
                <td>
                        <div class='video-blogster-block span_3_of_12'>
                        <label class='video-blogster-label' for='feed_extra_params'><?php esc_html_e( 'Other Filters', 'video-blogster' );?></label>
<a href="#" title="This covers any of the rarer SoundCloud filter parameters NOT on this page. This field is added on to the end of the query URL. For instance, to restrict your query to search only tracks with at least 40bpm, you would enter 'bpm[from]=40'."><img width='16' height='16' alt='?' src='<?php echo plugins_url( '../images/question.png', __FILE__ );?>'></a>
                        </div>
                        <div class='video-blogster-block span_9_of_12'>
                        <input class="vb-stretch" type="text" maxlength="256" name="feed_extra_params" id="feed_extra_params" value="<?php echo $this->get_value( $args, 'qExtraParams', '' ); ?>" />
                        </div>
                </td>
        </tr>
<?php $isHidden = ( empty( $isTrack ) ) ? 'video-blogster-hidden' : '';?>
        <tr class="vb-behaviour <?php echo $isHidden;?>">
		<td>
			<div class='video-blogster-block span_3_of_12'>
			<label class='video-blogster-label' for='feed_query_behavior'><?php esc_html_e( 'Query Behavior', 'video-blogster' );?></label>
<a href="#" title="STRICT queries will request exactly X tracks, skipping/updating any duplicates. CONTINUOUS queries will keep requesting tracks until X tracks are imported, skipping/updating any duplicates."><img width='16' height='16' alt='?' src='<?php echo plugins_url( '../images/question.png', __FILE__ );?>'></a>
			</div>
			<div class='video-blogster-block span_2_of_12'>
			<?php $optValue = $this->get_value( $args, 'qQueryBehavior', FALSE ); ?>
			<select class="vb-stretch" name="feed_query_behavior" id="feed_query_behavior">
				<option value="strict">Strict</option>
				<option value="continuous" <?php echo ($optValue == 'continuous') ? "SELECTED" : "" ?>>Continuous</option>
			</select>
			</div>
		</td>
	</tr>
</table>
	</dd>
</dl>


<?php $optImport = array( 'category', 'tags' ); ?>
<?php include( sprintf( "%stemplates/metadata.php", $this->plugin['dir'] ) ); ?>


<dl class="vbp-accordion">
  <dt>
	<span class='video-blogster-label'><?php printf( esc_html__( '%s Image', 'video-blogster' ), $importType );?></span>
  </dt>
  <dd class='video-blogster-hidden'>
	<table class='form-table'>
	<tr>
		<td>
			<div class='video-blogster-block span_12_of_12'>
			<?php $optValue = $this->get_value( $args, 'qImageImport', 1 ); ?>
			<input type="checkbox" name="feed_image_import" value=1 <?php echo ($optValue == 1) ? "CHECKED" : "" ?>/>
			<label class='video-blogster-label' for='feed_extra_params2'><?php esc_html_e( 'Import featured image quality', 'video-blogster' );?></label>
			<?php $optValue = $this->get_value( $args, 'qExtraParams2', 't500x500' ); ?>
			<select name="feed_extra_params2" id="feed_extra_params2">
				<option value="t500x500">500x500</option>
				<option value="crop" <?php echo ($optValue == 'crop') ? "SELECTED" : "" ?>>400x400</option>
				<option value="t300x300" <?php echo ($optValue == 't300x300') ? "SELECTED" : "" ?>>300x300</option>
				<option value="large" <?php echo ($optValue == 'large') ? "SELECTED" : "" ?>>100x100</option>
				<option value="badge" <?php echo ($optValue == 'badge') ? "SELECTED" : "" ?>>47x47</option>
				<option value="small" <?php echo ($optValue == 'small') ? "SELECTED" : "" ?>>32x32</option>
				<option value="mini" <?php echo ($optValue == 'mini') ? "SELECTED" : "" ?>>16x16</option>
				<option value="original" <?php echo ($optValue == 'original') ? "SELECTED" : "" ?>>original</option>
			</select>
			</div>
		</td>
	</tr>
	<tr>
		<td>
<?php
    	$vbp_image_id = $this->get_value( $args, 'qImageId', 0 );
	if ( $vbp_image_id )
		$image = wp_get_attachment_image( $vbp_image_id, 'medium', false, array( 'id' => 'vbp-preview-image' ) );
	else
         	$image = "<img id='vbp-preview-image' src='' >";
?>
	<div class='video-blogster-block span_12_of_12'>
	<label class='video-blogster-label' for='feed_image_attachment_id'>
        <input type='hidden' name='feed_image_attachment_id' id='feed_image_attachment_id' value='<?php echo $vbp_image_id; ?>'>
	<?php esc_html_e( 'or ', 'video-blogster' );?>
        <input type="button" class="button" value="<?php _e( 'Select an image', 'video-blogster' ); ?>" id="vbp_media_manager" />
	<?php esc_html_e( ' to use as featured image for all imported videos.', 'video-blogster' );?>
	</label>

	<p>
	<?php echo ( $image ); ?>
	</p>

	</div>
		</td>
	</tr>
	</table>
  </dd>
</dl>



<dl class="vbp-accordion">
  <dt>
	<span class='video-blogster-label'><?php printf( esc_html__( '%s Comments', 'video-blogster' ), $importType );?></span>
  </dt>
  <dd class='video-blogster-hidden'>
	<table class='form-table'>
	<tr>
		<td>
			<div class='video-blogster-block span_3_of_12'>
			<label class='video-blogster-label' for='feed_num_comments'><?php esc_html_e( 'Comments to Request', 'video-blogster' );?></label>
<a href="#" title="Comments to request for each track imported. Use -1 to request all comments or X-Y to randomly select a number in that range."><img width='16' height='16' alt='?' src='<?php echo plugins_url( '../images/question.png', __FILE__ );?>'></a>
			</div>
			<div class='video-blogster-block span_2_of_12'>
			<input class="vb-stretch" type="text" maxlength="4" name="feed_num_comments" id="feed_num_comments" value="<?php echo $this->get_value( $args, 'qNumComments', '', 1 ); ?>" />
			</div>
		</td>
	</tr>
	</table>
  </dd>
</dl>


		</td>
	</tr>
	</table>

        </div>
        </div>
</div>
