<div class="vbp-tab">
       <input class="vbp-tab-radio" type="radio" id="tab-query" name="tab-group-vbp" checked>
       <label class="vbp-tab-label video-blogster-label" for="tab-query"><div class="dashicons dashicons-editor-help"></div>Build <?php echo $video_source;?> Query</label>

        <div class="vbp-tab-panel">
        <div class="vbp-tab-content">

	<p><?php printf( esc_html__( 'This builds the query that will be sent to the %s API to retrieve content.', 'video-blogster' ), $video_source ); ?></p>

<dl class="vbp-accordion">
  <dt>
	<span class='video-blogster-label'><?php esc_html_e( 'API Request', 'video-blogster' );?></span>
  </dt>
<?php
$importType = esc_html__( 'Content', 'video-blogster' );
$importTypes = esc_html__( 'Content', 'video-blogster' );
$optValue = $this->get_value( $args, 'qAssocType', 'album');

$isUsingID = ( false !== strpos( $optValue, 'ID' ) ) ? "": "video-blogster-hidden";
$notUsingID = ( false !== strpos( $optValue, 'ID' ) ) ? "video-blogster-hidden" : "";

$isAlbumID = ($optValue === 'albumID' ) ? "" : "video-blogster-hidden";
$isArtistID = ($optValue === 'artistID' ) ? "" : "video-blogster-hidden";
$isPlaylistID = ($optValue === 'playlistID' ) ? "" : "video-blogster-hidden";
$isShowID = ($optValue === 'showID' ) ? "" : "video-blogster-hidden";
$qAssoc = $this->get_value( $args, 'qAssoc', '' );

?>
  <dd class='video-blogster-hidden'>
	<table class='form-table'>
	<tr>
		<td>
			<div class='video-blogster-block span_3_of_12'>
			<label class='video-blogster-label' for='feed_numVideos'><?php printf( esc_html__( '%s to Request', 'video-blogster' ), $importTypes );?></label>
<a href="#" title="There is no documented limit to the amount of content requested. You can enter -1 to request all possible content or X-Y to randomly select a number in that range."><img width='16' height='16' alt='?' src='<?php echo plugins_url( '../images/question.png', __FILE__ );?>'></a>
			</div>
			<div class='video-blogster-block span_2_of_12'>
			<input class="vb-stretch" type="text" maxlength="5" name="feed_numVideos" id="feed_numVideos" value="<?php echo $this->get_value( $args, 'qNumVideos', '1' ); ?>" />
			</div>
			<div class='video-blogster-block span_2_of_12'></div>
			<div class='video-blogster-block span_3_of_12'>
			<label class='video-blogster-label' for='spotify_feed_assoc_type'><?php esc_html_e( 'Type of Request', 'video-blogster' );?></label>
			</div>
			<div class='video-blogster-block span_2_of_12'>
			<select class="vb-stretch" name="feed_assoc_type" id="spotify_feed_assoc_type">
				<option value="album" <?php echo ($optValue == 'album') ? "SELECTED" : "" ?>>albums</option>
				<option value="artist" <?php echo ($optValue == 'artist') ? "SELECTED" : "" ?>>artists</option>
				<option value="playlist" <?php echo ($optValue == 'playlist') ? "SELECTED" : "" ?>>playlists</option>
				<option value="track" <?php echo ($optValue == 'track') ? "SELECTED" : "" ?>>tracks</option>
<?php /* Spotify API always returns empty item list for show search. Last checked 5/11/2020
				<option value="show" <?php echo ($optValue == 'show') ? "SELECTED" : "" ?>>shows</option>
*/ ?>
				<option value="albumID" <?php echo ($optValue == 'albumID') ? "SELECTED" : "" ?>>album ID</option>
				<option value="artistID" <?php echo ($optValue == 'artistID') ? "SELECTED" : "" ?>>artistID (top tracks)</option>
				<option value="playlistID" <?php echo ($optValue == 'playlistID') ? "SELECTED" : "" ?>>playlist ID</option>
				<option value="showID" <?php echo ($optValue == 'showID') ? "SELECTED" : "" ?>>show ID</option>
			</select>
			</div>
		</td>
	</tr>
	<tr class="vb-spotify-search-row <?php echo $notUsingID;?>">
		<td>
			<div class='video-blogster-block span_3_of_12'>
			<label class='video-blogster-label vb-spotify-assoc-label vb-spotify-search' for='feed_keyphrase'><?php esc_html_e( 'Search Terms', 'video-blogster' );?></label>
<a target="_blank" href="https://developer.spotify.com/web-api/search-item/" title="Spotify supports some specific matching filters. See https://developer.spotify.com/web-api/search-item/"><img width='16' height='16' alt='?' src='<?php echo plugins_url( '../images/question.png', __FILE__ );?>'></a>
			</div>
			<div class='video-blogster-block span_9_of_12'>
			<input class="vb-stretch vb-spotify-search" type="text" maxlength="256" name="feed_keyphrase" id="feed_keyphrase" value="<?php echo $this->get_value( $args, 'qKeyphrase', '' ); ?>" />
			</div>
		</td>
	</tr>
<?php $for = "for='feed_assoc'";?>
	<tr class="vb-spotify-using-id-row <?php echo $isUsingID;?>">
		<td>
			<div class='video-blogster-block span_2_of_12'>
			<label <?php echo $for;?> class="video-blogster-label vb-spotify-assoc-label vb-spotify-album-id <?php echo $isAlbumID;?>"><?php esc_html_e( 'Album ID', 'video-blogster' );?></label>
			<label <?php echo $for;?> class="video-blogster-label vb-spotify-assoc-label vb-spotify-artist-id <?php echo $isArtistID;?>"><?php esc_html_e( 'Artist ID', 'video-blogster' );?></label>
			<label <?php echo $for;?> class="video-blogster-label vb-spotify-assoc-label vb-spotify-playlist-id <?php echo $isPlaylistID;?>"><?php esc_html_e( 'Playlist ID', 'video-blogster' );?></label>
			<label <?php echo $for;?> class="video-blogster-label vb-spotify-assoc-label vb-spotify-show-id <?php echo $isShowID;?>"><?php esc_html_e( 'Show ID', 'video-blogster' );?></label>
			</div>
			<div class='video-blogster-block span_3_of_12'>
			<input class="vb-stretch vb-spotify-assoc" type="text" maxlength="256" name="feed_assoc" id="feed_assoc" value="<?php echo $qAssoc; ?>" />
			</div>
			<div class='video-blogster-block span_2_of_12'></div>
			<div class='video-blogster-block span_5_of_12 video-blogster-text-center'>
				<img class="vb-spotify-example vb-spotify-album-id-example <?php echo $isAlbumID;?>" width='340' height='25' alt='Album ID example' src='<?php echo plugins_url( '../images/spotify-album-id.jpg', __FILE__ );?>'>
				<img class="vb-spotify-example vb-spotify-artist-id-example <?php echo $isArtistID;?>" width='331' height='25' alt='Artist ID example' src='<?php echo plugins_url( '../images/spotify-artist-id.jpg', __FILE__ );?>'>
				<img class="vb-spotify-example vb-spotify-playlist-id-example <?php echo $isPlaylistID;?>" width='347' height='25' alt='Playlist ID example' src='<?php echo plugins_url( '../images/spotify-playlist-id.jpg', __FILE__ );?>'>
				<img class="vb-spotify-example vb-spotify-show-id-example <?php echo $isShowID;?>" width='312' height='25' alt='Show ID example' src='<?php echo plugins_url( '../images/spotify-show-id.jpg', __FILE__ );?>'>
			</div>
		</td>
	</tr>
        <tr>
                <td>
                        <div class='video-blogster-block span_3_of_12'>
                        <label class='video-blogster-label' for='feed_extra_params'><?php esc_html_e( 'Other Filters', 'video-blogster' );?></label>
<a target="_blank" href="https://developer.spotify.com/web-api/search-item/" title="This covers any of the rarer Spotify filter parameters NOT on this page. This field is added on to the end of the query URL. For instance, to restrict your query to search only content playable in the US market, you would enter 'market=US'."><img width='16' height='16' alt='?' src='<?php echo plugins_url( '../images/question.png', __FILE__ );?>'></a>
                        </div>
                        <div class='video-blogster-block span_9_of_12'>
                        <input class="vb-stretch" type="text" maxlength="256" name="feed_extra_params" id="feed_extra_params" value="<?php echo $this->get_value( $args, 'qExtraParams', '' ); ?>" />
                        </div>
                </td>
        </tr>
        <tr class="vb-behaviour">
		<td>
			<div class='video-blogster-block span_3_of_12'>
			<label class='video-blogster-label' for='feed_query_behavior'><?php esc_html_e( 'Query Behavior', 'video-blogster' );?></label>
<a href="#" title="STRICT queries will request exactly X results, skipping/updating any duplicates. CONTINUOUS queries will keep requesting results until X results are imported, skipping/updating any duplicates."><img width='16' height='16' alt='?' src='<?php echo plugins_url( '../images/question.png', __FILE__ );?>'></a>
			</div>
			<div class='video-blogster-block span_2_of_12'>
			<?php $optValue = $this->get_value( $args, 'qQueryBehavior', FALSE ); ?>
			<select class="vb-stretch" name="feed_query_behavior" id="feed_query_behavior">
				<option value="strict">Strict</option>
				<option value="continuous" <?php echo ($optValue == 'continuous') ? "SELECTED" : "" ?>>Continuous</option>
			</select>
			</div>
		</td>
	</tr>
</table>
	</dd>
</dl>


<?php $optImport = array( 'tags' ); ?>
<?php include( sprintf( "%stemplates/metadata.php", $this->plugin['dir'] ) ); ?>


<dl class="vbp-accordion">
  <dt>
	<span class='video-blogster-label'><?php printf( esc_html__( '%s Image', 'video-blogster' ), $importType );?></span>
  </dt>
  <dd class='video-blogster-hidden'>
	<table class='form-table'>
	<tr>
		<td>
			<div class='video-blogster-block span_12_of_12'>
			<?php $optValue = $this->get_value( $args, 'qImageImport', 1 ); ?>
			<input type="checkbox" name="feed_image_import" value=1 <?php echo ($optValue == 1) ? "CHECKED" : "" ?>/>
			<label class='video-blogster-label' for='feed_extra_params2'><?php esc_html_e( 'Import featured image quality', 'video-blogster' );?></label>
			<?php $optValue = $this->get_value( $args, 'qExtraParams2', 'large' ); ?>
			<select name="feed_extra_params2" id="feed_extra_params2">
				<option value="large" <?php echo ($optValue == 'large') ? "SELECTED" : "" ?>>large</option>
				<option value="medium" <?php echo ($optValue == 'medium') ? "SELECTED" : "" ?>>medium</option>
				<option value="small" <?php echo ($optValue == 'small') ? "SELECTED" : "" ?>>small</option>
			</select>
			</div>
		</td>
	</tr>
	<tr>
		<td>
<?php
    	$vbp_image_id = $this->get_value( $args, 'qImageId', 0 );
	if ( $vbp_image_id )
		$image = wp_get_attachment_image( $vbp_image_id, 'medium', false, array( 'id' => 'vbp-preview-image' ) );
	else
         	$image = "<img id='vbp-preview-image' src='' >";
?>
	<div class='video-blogster-block span_12_of_12'>
	<label class='video-blogster-label' for='feed_image_attachment_id'>
        <input type='hidden' name='feed_image_attachment_id' id='feed_image_attachment_id' value='<?php echo $vbp_image_id; ?>'>
	<?php esc_html_e( 'or ', 'video-blogster' );?>
        <input type="button" class="button" value="<?php _e( 'Select an image', 'video-blogster' ); ?>" id="vbp_media_manager" />
	<?php esc_html_e( ' to use as featured image for all imported videos.', 'video-blogster' );?>
	</label>

	<p>
	<?php echo ( $image ); ?>
	</p>

	</div>
		</td>
	</tr>
	</table>
  </dd>
</dl>


		</td>
	</tr>
	</table>

        </div>
        </div>
</div>
