<div class="vbp-tab">
       <input class="vbp-tab-radio" type="radio" id="tab-query" name="tab-group-vbp" checked>
       <label class="vbp-tab-label video-blogster-label" for="tab-query"><div class="dashicons dashicons-editor-help"></div>Build <?php echo $video_source;?> Query</label>

        <div class="vbp-tab-panel">
        <div class="vbp-tab-content">

	<p><?php printf( esc_html__( 'This builds the query that will be sent to the %s API to retrieve videos.', 'video-blogster' ), $video_source ); ?></p>

<dl class="vbp-accordion">
  <dt>
	<span class='video-blogster-label'><?php esc_html_e( 'API Request', 'video-blogster' );?></span>
  </dt>
<?php
$importType = esc_html__( 'Video', 'video-blogster' );
$importTypes = esc_html__( 'Videos', 'video-blogster' );
$optValue = $this->get_value( $args, 'qAssocType', 'search');
$isSearch = ($optValue == 'search' || empty( $optValue ) ) ? "" : "video-blogster-hidden";
$isCategory = ($optValue == 'category' ) ? "" : "video-blogster-hidden";
$isChannel = ($optValue == 'channel' ) ? "" : "video-blogster-hidden";
$isGroup = ($optValue == 'group' ) ? "" : "video-blogster-hidden";
$isUser = ($optValue == 'user' ) ? "" : "video-blogster-hidden";
$isVideo = ($optValue == 'video' ) ? "" : "video-blogster-hidden";
$SearchHide = ( empty( $isCategory ) || empty( $isVideo ) ) ? "video-blogster-hidden" : "";
$OrderHide = ( empty( $isCategory ) || empty( $isVideo ) ) ? "video-blogster-hidden" : "";
?>
  <dd class='video-blogster-hidden'>
	<table class='form-table'>
	<tr>
		<td>
			<div class='video-blogster-block span_3_of_12'>
			<label class='video-blogster-label' for='feed_numVideos'><?php printf( esc_html__( '%s to Request', 'video-blogster' ), $importTypes );?></label>
<a href="#" title="Vimeo has a rolling rate limit per API key. See docs for details. You can enter -1 to request all possible videos or X-Y to randomly select a number in that range."><img width='16' height='16' alt='?' src='<?php echo plugins_url( '../images/question.png', __FILE__ );?>'></a>
			</div>
			<div class='video-blogster-block span_2_of_12'>
			<input class="vb-stretch" type="text" maxlength="5" name="feed_numVideos" id="feed_numVideos" value="<?php echo $this->get_value( $args, 'qNumVideos', '1' ); ?>" />
			</div>
			<div class='video-blogster-block span_2_of_12'></div>
			<div class='video-blogster-block span_3_of_12'>
			<label class='video-blogster-label' for='vimeo_feed_assoc_type'><?php esc_html_e( 'Type of Request', 'video-blogster' );?></label>
			</div>
			<div class='video-blogster-block span_2_of_12'>
			<select class="vb-stretch" name="feed_assoc_type" id="vimeo_feed_assoc_type">
				<option value="search">search only</option>
				<option value="category" <?php echo ($optValue == 'category') ? "SELECTED" : "" ?>>category</option>
				<option value="channel" <?php echo ($optValue == 'channel') ? "SELECTED" : "" ?>>channel</option>
				<option value="group" <?php echo ($optValue == 'group') ? "SELECTED" : "" ?>>group</option>
				<option value="user" <?php echo ($optValue == 'user') ? "SELECTED" : "" ?>>user</option>
				<option value="video" <?php echo ($optValue == 'video') ? "SELECTED" : "" ?>>video id</option>
			</select>
			</div>
		</td>
	</tr>
<?php $isHidden = ( empty( $isSearch ) ) ? 'video-blogster-hidden' : '';?>
	<tr class="vb-vimeo-id-row <?php echo $isHidden;?>">
		<td>
			<div class='video-blogster-block span_3_of_12'>
<?php
	$qAssoc = $this->get_value( $args, 'qAssoc', '' );
	$for = "for='feed_assoc'";
	$link = null;
		if ( empty( $isCategory ) ) $link = 'http://www.vimeo.com/categories/' . $qAssoc;
		else if ( empty( $isChannel ) ) $link = 'http://www.vimeo.com/channels/' . $qAssoc;
		else if ( empty( $isGroup ) ) $link = 'http://www.vimeo.com/groups/' . $qAssoc;
		else if ( empty( $isUser ) ) $link = 'https://www.vimeo.com/' . $qAssoc;
		else if ( empty( $isVideo ) ) $link = 'https://www.vimeo.com/' . $qAssoc;
		if ( $link ) {
			echo "<a class='video-blogster-label' target='_blank' href='{$link}'>"; 
			$for = null;
		}
?>
			<label <?php echo $for;?> class="video-blogster-label <?php echo $isCategory;?> vb-vimeo-assoc-label vb-vimeo-category-id"><?php esc_html_e( 'Category ID', 'video-blogster' );?></label>
			<label <?php echo $for;?> class="video-blogster-label <?php echo $isChannel;?> vb-vimeo-assoc-label vb-vimeo-channel-id"><?php esc_html_e( 'Channel ID', 'video-blogster' );?></label>
			<label <?php echo $for;?> class="video-blogster-label <?php echo $isGroup;?> vb-vimeo-assoc-label vb-vimeo-group-id"><?php esc_html_e( 'Group ID', 'video-blogster' );?></label>
			<label <?php echo $for;?> class="video-blogster-label <?php echo $isUser;?> vb-vimeo-assoc-label vb-vimeo-user-id"><?php esc_html_e( 'User ID', 'video-blogster' );?></label>
			<label <?php echo $for;?> class="video-blogster-label <?php echo $isVideo;?> vb-vimeo-assoc-label vb-vimeo-video-id"><?php esc_html_e( 'Video ID', 'video-blogster' );?></label>
<?php if ( $link ) echo "</a>\n"; ?>
<a class="video-blogster-label <?php echo $isCategory;?> vb-vimeo-assoc-label vb-vimeo-category-id" href="<?php echo $link;?>" title="Enter the category name, such as 'travel'. For subcategories like 'travel/northamerica', just enter 'northamerica'. "><img width='16' height='16' alt='?' src='<?php echo plugins_url( '../images/question.png', __FILE__ );?>'></a>
			</div>
			<div class='video-blogster-block span_2_of_12'>
			<input class="vb-stretch vb-vimeo-assoc" type="text" maxlength="256" name="feed_assoc" id="feed_assoc" value="<?php echo $this->get_value( $args, 'qAssoc', '' ); ?>" />
			</div>
			<div class='video-blogster-block span_2_of_12'></div>
			<div class='video-blogster-block span_5_of_12 video-blogster-text-center'>
				<img class="vb-vimeo-id-example <?php echo $isCategory;?> vb-vimeo-category-id" width='202' height='25' alt='Vimeo Category ID example' src='<?php echo plugins_url( '../images/vimeo-category-id.jpg', __FILE__ );?>'>
				<img class="vb-vimeo-id-example <?php echo $isChannel;?> vb-vimeo-channel-id" width='196' height='25' alt='Vimeo Channel ID example' src='<?php echo plugins_url( '../images/vimeo-channel-id.jpg', __FILE__ );?>'>
				<img class="vb-vimeo-id-example <?php echo $isGroup;?> vb-vimeo-group-id" width='212' height='25' alt='Vimeo Group ID example' src='<?php echo plugins_url( '../images/vimeo-group-id.jpg', __FILE__ );?>'>
				<img class="vb-vimeo-id-example <?php echo $isUser;?> vb-vimeo-user-id" width='163' height='25' alt='Vimeo User ID example' src='<?php echo plugins_url( '../images/vimeo-user-id.jpg', __FILE__ );?>'>
				<img class="vb-vimeo-id-example <?php echo $isVideo;?> vb-vimeo-video-id" width='314' height='25' alt='Vimeo Video ID example' src='<?php echo plugins_url( '../images/vimeo-video-id.jpg', __FILE__ );?>'>
			</div>
		</td>
	</tr>
	<tr class="vb-vimeo-search-row <?php echo $SearchHide;?>">
		<td>
			<div class='video-blogster-block span_3_of_12'>
			<label class='video-blogster-label vb-vimeo-search' for='feed_keyphrase'>
			<?php esc_html_e( 'Search Terms', 'video-blogster' );?> 
			</label>
			</div>
			<div class='video-blogster-block span_9_of_12'>
			<input class="vb-stretch vb-vimeo-search" type="text" maxlength="256" name="feed_keyphrase" id="feed_keyphrase" value="<?php echo $this->get_value( $args, 'qKeyphrase', '' ); ?>" />
			</div>
		</td>
	</tr>
	<tr class="vb-vimeo-order-row <?php echo $OrderHide;?>">
		<td>
			<div class='video-blogster-block span_3_of_12'>
			<label class='video-blogster-label vb-vimeo-order' for='feed_orderby'><?php esc_html_e( 'Sort Videos by', 'video-blogster' );?></label>
			</div>
			<div class='video-blogster-block span_2_of_12'>
			<?php $optValue = $this->get_value( $args, 'qOrderBy', ''); ?>
			<select class="vb-stretch vb-vimeo-order" name="feed_orderby" id="feed_orderby">
				<option value="relevant" <?php echo ($optValue == 'relevant') ? "SELECTED" : "" ?>>relevance</option>
				<option value="date" <?php echo ($optValue == 'date') ? "SELECTED" : "" ?>>date</option>
				<option value="alphabetical" <?php echo ($optValue == 'alphabetical') ? "SELECTED" : "" ?>>alphabetical</option>
				<option value="plays" <?php echo ($optValue == 'plays') ? "SELECTED" : "" ?>>plays</option>
				<option value="likes" <?php echo ($optValue == 'likes') ? "SELECTED" : "" ?>>likes</option>
				<option value="comments" <?php echo ($optValue == 'comments') ? "SELECTED" : "" ?>>comments</option>
				<option value="duration" <?php echo ($optValue == 'duration') ? "SELECTED" : "" ?>>duration</option>
			</select>
			</div>
			<div class='video-blogster-block span_2_of_12'></div>
			<div class='video-blogster-block span_3_of_12'>
			<label class='video-blogster-label vb-vimeo-order' for='feed_order_direction'><?php esc_html_e( 'Sort Direction', 'video-blogster' );?></label>
			</div>
			<div class='video-blogster-block span_2_of_12'>
			<?php $optValue = $this->get_value( $args, 'qOrderDirection', 'desc' ); ?>
			<select name="feed_order_direction" id="feed_order_direction">
				<option value="desc" <?php echo ($optValue == 'desc') ? "SELECTED" : "" ?>>descending</option>
				<option value="asc" <?php echo ($optValue == 'asc') ? "SELECTED" : "" ?>>ascending</option>
			</select>

			</div>
		</td>
	</tr>
<?php $isHidden = ( empty( $isVideo ) ) ? 'video-blogster-hidden' : '';?>
        <tr class="vb-behaviour <?php echo $isHidden;?>">
		<td>
			<div class='video-blogster-block span_3_of_12'>
			<label class='video-blogster-label' for='feed_query_behavior'><?php esc_html_e( 'Query Behavior', 'video-blogster' );?></label>
<a href="#" title="STRICT queries will request exactly X videos, skipping/updating any duplicates. CONTINUOUS queries will keep requesting videos until X videos are imported, skipping/updating any duplicates."><img width='16' height='16' alt='?' src='<?php echo plugins_url( '../images/question.png', __FILE__ );?>'></a>
			</div>
			<div class='video-blogster-block span_2_of_12'>
			<?php $optValue = $this->get_value( $args, 'qQueryBehavior', FALSE ); ?>
			<select class="vb-stretch" name="feed_query_behavior" id="feed_query_behavior">
				<option value="strict">Strict</option>
				<option value="continuous" <?php echo ($optValue == 'continuous') ? "SELECTED" : "" ?>>Continuous</option>
			</select>
			</div>
<div class="vb-vimeo-example <?php echo $isCategory;?> vb-vimeo-category-filters span_12_of_12">
<br><br>
Vimeo category endpoint does not support search or filters.
</div>
		</td>
	</tr>
</table>
	</dd>
</dl>

<dl class="vbp-accordion vb-vimeo-filters <?php echo $SearchHide;?>">
  <dt>
	<span class='video-blogster-label'><?php esc_html_e( 'Search Filters', 'video-blogster' );?></span>
  </dt>
  <dd>
	<table class='form-table'>
	<tr>
		<td>
			<div class='video-blogster-block span_3_of_12'>
			<label class='video-blogster-label' for='feed_extra_params'><?php esc_html_e( 'Other Filters', 'video-blogster' );?></label>
<?php
	$link = null;
		if ( empty( $isCategory ) ) $link = 'https://developer.vimeo.com/api/endpoints/categories#GET/categories/{category}/videos';
		else if ( empty( $isChannel ) ) $link = 'https://developer.vimeo.com/api/endpoints/channels#GET/channels/{channel_id}/videos';
		else if ( empty( $isGroup ) ) $link = 'https://developer.vimeo.com/api/endpoints/groups#GET/groups/{group_id}/videos';
		else if ( empty( $isUser ) ) $link = 'https://developer.vimeo.com/api/endpoints/videos#GET/users/{user_id}/videos';
		else if ( empty( $isVideo ) ) $link = 'https://developer.vimeo.com/api/endpoints/videos#GET/videos';
		else if ( empty( $isSearch ) ) $link = 'https://developer.vimeo.com/api/endpoints/videos#GET/videos';
?>
<a target="_blank" href="<?php echo $link;?>" title="This covers any of the rarer Vimeo search parameters NOT on this page. This field is added on to the end of the query URL. For instance, to restrict your query to search only videos rated 'safe', you would enter 'filter=content_rating&filter_content_rating=safe'."><img width='16' height='16' alt='?' src='<?php echo plugins_url( '../images/question.png', __FILE__ );?>'></a>
			</div>
			<div class='video-blogster-block span_9_of_12'>
			<input class="vb-stretch" type="text" maxlength="256" name="feed_extra_params" id="feed_extra_params" value="<?php echo $this->get_value( $args, 'qExtraParams', '' ); ?>" />
			</div>
		</td>
	</tr>
	<tr><td>*NOTE* Many of the Vimeo filters do not seem to work properly (March 2018). No official response yet.</td></tr>
	</table>
  </dd>
</dl>


<?php $optImport = array( 'tags' ); ?>
<?php include( sprintf( "%stemplates/metadata.php", $this->plugin['dir'] ) ); ?>


<dl class="vbp-accordion">
  <dt>
	<span class='video-blogster-label'><?php printf( esc_html__( '%s Image', 'video-blogster' ), $importType );?></span>
  </dt>
  <dd class='video-blogster-hidden'>
	<table class='form-table'>
	<tr>
		<td>
			<div class='video-blogster-block span_12_of_12'>
			<?php $optValue = $this->get_value( $args, 'qImageImport', 1 ); ?>
			<input type="checkbox" name="feed_image_import" value=1 <?php echo ($optValue == 1) ? "CHECKED" : "" ?>/>
			<label class='video-blogster-label' for='feed_extra_params2'><?php esc_html_e( 'Import featured image quality', 'video-blogster' );?></label>
			<?php $optValue = $this->get_value( $args, 'qExtraParams2', 'original' ); ?>
			<select name="feed_extra_params2" id="feed_extra_params2">
				<option value="original">original</option>
				<option value="1920px" <?php echo ($optValue == '1920px') ? "SELECTED" : "" ?>>1920px width</option>
				<option value="1280px" <?php echo ($optValue == '1280px') ? "SELECTED" : "" ?>>1280px width</option>
				<option value="960px" <?php echo ($optValue == '960px') ? "SELECTED" : "" ?>>960px width</option>
				<option value="640px" <?php echo ($optValue == '640px') ? "SELECTED" : "" ?>>640px width</option>
				<option value="295px" <?php echo ($optValue == '295px') ? "SELECTED" : "" ?>>295px width</option>
				<option value="200px" <?php echo ($optValue == '200px') ? "SELECTED" : "" ?>>200px width</option>
				<option value="100px" <?php echo ($optValue == '100px') ? "SELECTED" : "" ?>>100px width</option>
			</select>
			</div>
		</td>
	</tr>
	<tr>
		<td>
<?php
    	$vbp_image_id = $this->get_value( $args, 'qImageId', 0 );
	if ( $vbp_image_id )
		$image = wp_get_attachment_image( $vbp_image_id, 'medium', false, array( 'id' => 'vbp-preview-image' ) );
	else
         	$image = "<img id='vbp-preview-image' src='' >";
?>
	<div class='video-blogster-block span_12_of_12'>
	<label class='video-blogster-label' for='feed_image_attachment_id'>
        <input type='hidden' name='feed_image_attachment_id' id='feed_image_attachment_id' value='<?php echo $vbp_image_id; ?>'>
	<?php esc_html_e( 'or ', 'video-blogster' );?>
        <input type="button" class="button" value="<?php _e( 'Select an image', 'video-blogster' ); ?>" id="vbp_media_manager" />
	<?php esc_html_e( ' to use as featured image for all imported videos.', 'video-blogster' );?>
	</label>

	<p>
	<?php echo ( $image ); ?>
	</p>

	</div>
		</td>
	</tr>
	</table>
  </dd>
</dl>



<dl class="vbp-accordion">
  <dt>
	<span class='video-blogster-label'><?php printf( esc_html__( '%s Comments', 'video-blogster' ), $importType );?></span>
  </dt>
  <dd class='video-blogster-hidden'>
	<table class='form-table'>
	<tr>
		<td>
			<div class='video-blogster-block span_3_of_12'>
			<label class='video-blogster-label' for='feed_num_comments'><?php esc_html_e( 'Comments to Request', 'video-blogster' );?></label>
<a href="#" title="Comments to request for each video imported. Use -1 to request all comments or X-Y to randomly select a number in that range."><img width='16' height='16' alt='?' src='<?php echo plugins_url( '../images/question.png', __FILE__ );?>'></a>
			</div>
			<div class='video-blogster-block span_2_of_12'>
			<input class="vb-stretch" type="text" maxlength="4" name="feed_num_comments" id="feed_num_comments" value="<?php echo $this->get_value( $args, 'qNumComments', '', 1 ); ?>" />
			</div>
		</td>
	</tr>
	</table>
  </dd>
</dl>

		</td>
	</tr>
	</table>

        </div>
        </div>
</div>
