<div class="vbp-tab">
       <input class="vbp-tab-radio" type="radio" id="tab-query" name="tab-group-vbp" checked>
       <label class="vbp-tab-label video-blogster-label" for="tab-query"><div class="dashicons dashicons-editor-help"></div>Build <?php echo $video_source;?> Query</label>

        <div class="vbp-tab-panel">
        <div class="vbp-tab-content">

	<p>
	<?php 
		printf( 
		esc_html__( 'This builds the query that will be sent to the %s API to retrieve videos using a public API key. %sBy using this query you agree to %sYouTube\'s Terms of Service%s and %sGoogle\'s Privacy Policy%s. %sNo user data is collected, stored, processed, or otherwise used.', 'video-blogster' ), 
		$video_source, 
		'<br>',
		'<a target="_blank" href="' . esc_url('https://www.youtube.com/t/terms') . '">',
		'</a>',
		'<a target="_blank" href="' . esc_url('https://policies.google.com/privacy?hl=en-US') . '">',
		'</a>',
		'<br>'
		); 
	?>
	</p>

<dl class="vbp-accordion">
  <dt>
	<span class='video-blogster-label'><?php esc_html_e( 'API Request', 'video-blogster' );?></span>
  </dt>
<?php
$importType = esc_html__( 'Video', 'video-blogster' );
$importTypes = esc_html__( 'Videos', 'video-blogster' );
$optValue = $this->get_value( $args, 'qAssocType', 'search');
$isSearch = ($optValue == 'search' || empty( $optValue) ) ? "" : "video-blogster-hidden";
$isChannel = ($optValue == 'channel' ) ? "" : "video-blogster-hidden";
$isPlaylist = ($optValue == 'playlist' ) ? "" : "video-blogster-hidden";
$isUser = ($optValue == 'user' ) ? "" : "video-blogster-hidden";
$isVideo = ($optValue == 'video' ) ? "" : "video-blogster-hidden";
$isMostPopular = ($optValue == 'mostPopular' ) ? "" : "video-blogster-hidden";
$VideoHide = ( empty( $isVideo ) ) ? "video-blogster-hidden" : "";
$PlaylistOrVideoHide = ( empty( $isPlaylist ) || empty( $isVideo ) ) ? "video-blogster-hidden" : "";
$PlaylistOrVideoOrMostPopularHide = ( empty( $isPlaylist ) || empty( $isVideo ) || empty( $isMostPopular) ) ? "video-blogster-hidden" : "";
$mostPopularHide = ( empty( $isMostPopular) ) ? "video-blogster-hidden" : "";
?>
  <dd class='video-blogster-hidden'>
	<table class='form-table'>
	<tr>
		<td>
			<div class='video-blogster-block span_3_of_12'>
			<label class='video-blogster-label' for='feed_numVideos'><?php printf( esc_html__( '%s to Request', 'video-blogster' ), $importTypes );?></label>
<a href="#" title="YouTube has a soft search limit of 500 videos, regardless of total results. Playlists use a different API endpoint and do not have this restriction. You can enter -1 to request all possible videos or X-Y to randomly select a number in that range."><img width='16' height='16' alt='?' src='<?php echo plugins_url( '../images/question.png', __FILE__ );?>'></a>
			</div>
			<div class='video-blogster-block span_2_of_12'>
			<input class="vb-stretch" type="text" maxlength="8" name="feed_numVideos" id="feed_numVideos" value="<?php echo $this->get_value( $args, 'qNumVideos', '1' ); ?>" />
			</div>
			<div class='video-blogster-block span_2_of_12'></div>
			<div class='video-blogster-block span_3_of_12'>
			<label class='video-blogster-label' for='yt_feed_assoc_type'><?php esc_html_e( 'Type of Request', 'video-blogster' );?></label>
<a href="#" title="YouTube uses different parameters and endpoints depending on the type of request, including search terms, search filters and/or a channel/playlist/user ID."><img width='16' height='16' alt='?' src='<?php echo plugins_url( '../images/question.png', __FILE__ );?>'></a>
			</div>
			<div class='video-blogster-block span_2_of_12'>
			<select class="vb-stretch" name="feed_assoc_type" id="yt_feed_assoc_type">
				<option value="search">search only</option>
				<option value="channel" <?php echo ($optValue == 'channel') ? "SELECTED" : "" ?>>channel</option>
				<option value="playlist" <?php echo ($optValue == 'playlist') ? "SELECTED" : "" ?>>playlist</option>
				<option value="user" <?php echo ($optValue == 'user') ? "SELECTED" : "" ?>>username</option>
				<option value="video" <?php echo ($optValue == 'video') ? "SELECTED" : "" ?>>video id</option>
				<option value="mostPopular" <?php echo ($optValue == 'mostPopular') ? "SELECTED" : "" ?>>most popular</option>
			</select>
			</div>
		</td>
	</tr>
<?php $isHidden = ( empty( $isSearch ) || empty( $isMostPopular ) ) ? 'video-blogster-hidden' : '';?>
	<tr class="vb-yt-id-row <?php echo $isHidden;?>">
		<td>
			<div class='video-blogster-block span_2_of_12'>
<?php
	$qAssoc = $this->get_value( $args, 'qAssoc', '' );
	$for = "for='feed_assoc'";
	$link = null;
	if ( ! empty( $qAssoc ) ) {
		if ( empty( $isChannel ) ) $link = 'https://www.youtube.com/channel/' . $qAssoc;
		else if ( empty( $isPlaylist ) ) $link = 'https://www.youtube.com/playlist?list=' . $qAssoc;
		else if ( empty( $isUser ) ) $link = 'https://www.youtube.com/user/' . $qAssoc;
		else if ( empty( $isVideo ) ) $link = 'https://www.youtube.com/watch?v=' . $qAssoc;
		if ( $link ) {
			echo "<a class='video-blogster-label' target='_blank' href='{$link}'>";
			$for = null;
		}
	} 
?>
			<label <?php echo $for;?> class="video-blogster-label <?php echo $isChannel;?> vb-yt-assoc-label vb-yt-channel-id"><?php esc_html_e( 'Channel ID', 'video-blogster' );?></label>
			<label <?php echo $for;?> class="video-blogster-label <?php echo $isPlaylist;?> vb-yt-assoc-label vb-yt-playlist-id"><?php esc_html_e( 'Playlist ID', 'video-blogster' );?></label>
			<label <?php echo $for;?> class="video-blogster-label <?php echo $isUser;?> vb-yt-assoc-label vb-yt-user-id"><?php esc_html_e( 'User ID', 'video-blogster' );?></label>
			<label <?php echo $for;?> class="video-blogster-label <?php echo $isVideo;?> vb-yt-assoc-label vb-yt-video-id"><?php esc_html_e( 'Video ID', 'video-blogster' );?></label>
<?php if ( $qAssoc && $link ) echo "</a>\n"; ?>
			</div>
			<div class='video-blogster-block span_3_of_12'>
			<input class="vb-stretch vb-yt-assoc" type="text" maxlength="256" name="feed_assoc" id="feed_assoc" value="<?php echo $qAssoc; ?>" />
			</div>
			<div class='video-blogster-block span_2_of_12'></div>
			<div class='video-blogster-block span_5_of_12 video-blogster-text-center'>
				<img class="vb-yt-example <?php echo $isChannel;?> vb-yt-channel-id-example" width='412' height='25' alt='YouTube Channel ID example' src='<?php echo plugins_url( '../images/yt-channel-id.jpg', __FILE__ );?>'>
				<img class="vb-yt-example <?php echo $isPlaylist;?> vb-yt-playlist-id-example" width='521' height='25' alt='YouTube Playlist ID example' src='<?php echo plugins_url( '../images/yt-playlist-id.jpg', __FILE__ );?>'>
				<img class="vb-yt-example <?php echo $isUser;?> vb-yt-user-id-example" width='321' height='25' alt='YouTube User ID example' src='<?php echo plugins_url( '../images/yt-user-id.jpg', __FILE__ );?>'>
				<img class="vb-yt-example <?php echo $isVideo;?> vb-yt-video-id-example" width='323' height='25' alt='YouTube Video ID example' src='<?php echo plugins_url( '../images/yt-video-id.jpg', __FILE__ );?>'>
			</div>
		</td>
	</tr>
	<tr class="vb-yt-search-order-row <?php echo $PlaylistOrVideoOrMostPopularHide;?>">
		<td>
			<div class='video-blogster-block span_2_of_12'>
			<label class='video-blogster-label vb-yt-search' for='feed_keyphrase' >
			<?php esc_html_e( 'Search Terms', 'video-blogster' );?> 
			</label>
<a href="#" title="Search terms are sent to the YouTube API which also supports many advanced search operators."><img width='16' height='16' alt='?' src='<?php echo plugins_url( '../images/question.png', __FILE__ );?>'></a>
			</div>
			<div class='video-blogster-block span_3_of_12'>
			<span class='vb-yt-search'>
			<input class="vb-stretch" type="text" maxlength="256" name="feed_keyphrase" id="feed_keyphrase" value="<?php echo $this->get_value( $args, 'qKeyphrase', '' ); ?>" />
			</span>
			</div>
			<div class='video-blogster-block span_2_of_12'></div>
			<div class='video-blogster-block span_3_of_12'>
			<label class='video-blogster-label vb-yt-order' for='feed_orderby'><?php esc_html_e( 'Order Videos by', 'video-blogster' );?></label>
			</div>
			<div class='video-blogster-block span_2_of_12'>
			<span class='vb-yt-order'>
			<?php $optValue = $this->get_value( $args, 'qOrderBy', ''); ?>
			<select class="vb-stretch" name="feed_orderby" id="feed_orderby">
				<option value="relevance" <?php echo ($optValue == 'relevance') ? "SELECTED" : "" ?>>search relevance</option>
				<option value="date" <?php echo ($optValue == 'date') ? "SELECTED" : "" ?>>date</option>
				<option value="rating" <?php echo ($optValue == 'rating') ? "SELECTED" : "" ?>>rating</option>
				<option value="title" <?php echo ($optValue == 'title') ? "SELECTED" : "" ?>>title</option>
				<option value="viewCount" <?php echo ($optValue == 'viewCount') ? "SELECTED" : "" ?>>viewCount</option>
			</select>
			</span>
			</div>
		</td>
	</tr>
<?php $isHidden = ( empty( $isVideo ) ) ? 'video-blogster-hidden' : '';?>
        <tr class="vb-behaviour <?php echo $isHidden;?>">
		<td>
			<div class='video-blogster-block span_3_of_12'>
			<label class='video-blogster-label' for='feed_query_behavior' ><?php esc_html_e( 'Query Behavior', 'video-blogster' );?></label>
<a href="#" title="STRICT queries will request exactly X videos, skipping/updating any duplicates. CONTINUOUS queries will keep requesting videos until X videos are imported, skipping/updating any duplicates."><img width='16' height='16' alt='?' src='<?php echo plugins_url( '../images/question.png', __FILE__ );?>'></a>
			</div>
			<div class='video-blogster-block span_2_of_12'>
			<?php $optValue = $this->get_value( $args, 'qQueryBehavior', FALSE ); ?>
			<select class="vb-stretch" name="feed_query_behavior" id="feed_query_behavior">
				<option value="strict">Strict</option>
				<option value="continuous" <?php echo ($optValue == 'continuous') ? "SELECTED" : "" ?>>Continuous</option>
			</select>
			</div>
		</td>
	</tr>
	<tr>
		<td>

<div class="vb-yt-example <?php echo $isPlaylist;?> vb-yt-playlist-filters span_12_of_12">
YouTube does not support playlist filters. The playlist videos are returned as they are listed.
</div>
<div class="vb-yt-example <?php echo $isVideo;?> vb-yt-video-filters span_12_of_12">
Requests for a specific video do not need search filters.
</div>
<div class="vb-yt-example <?php echo $isMostPopular;?> vb-yt-mostpopular-id-example span_12_of_12">
Returns the most popular videos for the specified video category and content region.
</div>
		</td>
	</tr>
</table>
	</dd>
</dl>

<dl class="vbp-accordion vb-yt-filters <?php echo $PlaylistOrVideoHide;?>">
  <dt>
	<span class='video-blogster-label'><?php esc_html_e( 'Search Filters', 'video-blogster' );?></span>
  </dt>
  <dd>
	<table class='form-table'>
	<tr class="vb-yt-filters-1">
		<td>
			<div class='video-blogster-block span_3_of_12'>
			<label class='video-blogster-label' for='feed_search_category'><?php esc_html_e( 'Video Category', 'video-blogster' );?></label>
<a href="#" title="Filters video search results based on their category."><img width='16' height='16' alt='?' src='<?php echo plugins_url( '../images/question.png', __FILE__ );?>'></a>
			</div>
			<div class='video-blogster-block span_2_of_12'>
			<?php $optValue = $this->get_value( $args, 'qCategory', 0 ); ?>
			<?php
			$args['videoSource'] = 'YouTube';
			$this->create_video_source( $args );
			$categories = isset( $this->video_source ) ? $this->video_source->grab_categories( 'US' ) : array();
			?>
			<select class="vb-stretch" name="feed_search_category" id="feed_search_category">
				<option value="">Any</option>
			<?php
			foreach ( $categories as $cat ) { 
			?>
				<option value="<?php echo $cat->id;?>" <?php echo ($optValue == $cat->id) ? "SELECTED" : "" ?>><?php echo $cat->snippet->title; ?></option>
			<?php 
			} 
			?>
			</select>

			<?php if ( empty( $categories ) ) $this->info_message( esc_html__( 'Notice: Unable to retrieve categories from the YouTube API.', 'video-blogster' ) ); ?>
			</div>
			<div class='video-blogster-block span_2_of_12'></div>
			<div class='video-blogster-block span_3_of_12'>
			<label class='video-blogster-label' for='feed_region_code'><?php esc_html_e( 'Region Code', 'video-blogster' );?></label>
<a href="#" title="Instructs the API to return search results for videos that can only be viewed in the specified country. If changing this value, SAVE so that the categories for this specific region will be shown in the Video Category select box."><img width='16' height='16' alt='?' src='<?php echo plugins_url( '../images/question.png', __FILE__ );?>'></a>
			</div>
			<div class='video-blogster-block span_2_of_12'>
			<?php $optValue = $this->get_value( $args, 'qRegionCode', '' ); ?>
			<?php $regions = isset( $this->video_source ) ? $this->video_source->grab_regions() : array(); ?>
			<select class="vb-stretch" name="feed_region_code" id="feed_region_code">
				<option value="">None</option>
			<?php
			foreach ( $regions as $reg ) {
			?>
				<option value="<?php echo $reg->id;?>" <?php echo ($optValue == $reg->id) ? "SELECTED" : "" ?>><?php echo $reg->snippet->name; ?></option>
			<?php 
			} 
			?>
			</select>
			</div>
		</td>
	</tr>
	<tr class="vb-yt-filters-2 <?php echo $mostPopularHide;?>">
		<td>
			<div class='video-blogster-block span_3_of_12'>
			<label class='video-blogster-label' for='feed_safesearch'><?php esc_html_e( 'safeSearch', 'video-blogster' );?></label>
<a href="#" title="Whether the search results should include restricted content as well as standard content."><img width='16' height='16' alt='?' src='<?php echo plugins_url( '../images/question.png', __FILE__ );?>'></a>
			</div>
			<div class='video-blogster-block span_2_of_12'>
			<?php $optValue = $this->get_value( $args, 'qSafeSearch', 'moderate' ); ?>
			<select class="vb-stretch" name="feed_safesearch" id="feed_safesearch">
				<option value="moderate">Moderate</option>
				<option value="none" <?php echo ($optValue == 'none') ? "SELECTED" : "" ?>>None</option>
				<option value="strict" <?php echo ($optValue == 'strict') ? "SELECTED" : "" ?>>Strict</option>
			</select>
			</div>
			<div class='video-blogster-block span_2_of_12'></div>
			<div class='video-blogster-block span_3_of_12'>
			<label class='video-blogster-label' for='feed_search_definition'><?php esc_html_e( 'Video Definition', 'video-blogster' );?></label>
<a href="#" title="Restrict a search to only include either high definition (HD) or standard definition (SD) videos. HD videos are available for playback in at least 720p, though higher resolutions, like 1080p, might also be available."><img width='16' height='16' alt='?' src='<?php echo plugins_url( '../images/question.png', __FILE__ );?>'></a>
			</div>
			<div class='video-blogster-block span_2_of_12'>
			<?php $optValue = $this->get_value( $args, 'qDefinition', '' ); ?>
			<select class="vb-stretch" name="feed_search_definition" id="feed_search_definition">
				<option value="any">Any</option>
				<option value="high" <?php echo ($optValue == 'high') ? "SELECTED" : "" ?>>High Def only</option>
				<option value="standard" <?php echo ($optValue == 'standard') ? "SELECTED" : "" ?>>Standard Def only</option>
			</select>
			</div>
		</td>
	</tr>
	<tr class="vb-yt-filters-2 <?php echo $mostPopularHide;?>">
		<td>
			<div class='video-blogster-block span_3_of_12'>
			<label class='video-blogster-label' for='feed_pub_after'><?php esc_html_e( 'Published After', 'video-blogster' );?></label>
<a href="#" title="Indicates that the API response should only contain resources created at or after the specified time. The value is an RFC 3339 formatted date-time value (1970-01-01T00:00:00Z) or relative time (1 month ago)."><img width='16' height='16' alt='?' src='<?php echo plugins_url( '../images/question.png', __FILE__ );?>'></a>
			</div>
			<div class='video-blogster-block span_2_of_12'>
			<input class="vb-stretch" type="text" maxlength="32" name="feed_pub_after" id="feed_pub_after" value="<?php echo $this->get_value( $args, 'qPublishedAfter', '' ); ?>" />
			</div>
			<div class='video-blogster-block span_2_of_12'></div>
			<div class='video-blogster-block span_3_of_12'>
			<label class='video-blogster-label' for='feed_pub_before'><?php esc_html_e( 'Published Before', 'video-blogster' );?></label>
<a href="#" title="Indicates that the API response should only contain resources created before or at the specified time. The value is an RFC 3339 formatted date-time value (1970-01-01T00:00:00Z) or relative time (1 month ago)."><img width='16' height='16' alt='?' src='<?php echo plugins_url( '../images/question.png', __FILE__ );?>'></a>
			</div>
			<div class='video-blogster-block span_2_of_12'>
			<input class="vb-stretch" type="text" maxlength="32" name="feed_pub_before" id="feed_pub_before" value="<?php echo $this->get_value( $args, 'qPublishedBefore', '' ); ?>" />
			</div>
		</td>
	</tr>
	<tr class="vb-yt-filters-2 <?php echo $mostPopularHide;?>">
		<td>
			<div class='video-blogster-block span_3_of_12'>
			<label class='video-blogster-label' for='feed_search_duration'><?php esc_html_e( 'Video Duration', 'video-blogster' );?></label>
<a href="#" title="Filters video search results based on their duration."><img width='16' height='16' alt='?' src='<?php echo plugins_url( '../images/question.png', __FILE__ );?>'></a>
			</div>
			<div class='video-blogster-block span_2_of_12'>
			<?php $optValue = $this->get_value( $args, 'qDuration', '' ); ?>
			<select class="vb-stretch" name="feed_search_duration" id="feed_search_duration">
				<option value="any">Any</option>
				<option value="long" <?php echo ($optValue == 'long') ? "SELECTED" : "" ?>>20+ minutes</option>
				<option value="medium" <?php echo ($optValue == 'medium') ? "SELECTED" : "" ?>>4 to 20 minutes</option>
				<option value="short" <?php echo ($optValue == 'short') ? "SELECTED" : "" ?>>< 4 minutes</option>
			</select>
			</div>
			<div class='video-blogster-block span_2_of_12'></div>
			<div class='video-blogster-block span_3_of_12'>
			<label class='video-blogster-label' for='feed_language'><?php esc_html_e( 'Relevance Language', 'video-blogster' );?></label>
<a href="#" title="Instructs the API to return search results that are most relevant to the specified language. Please note that results in other languages will still be returned if they are highly relevant to the search query term."><img width='16' height='16' alt='?' src='<?php echo plugins_url( '../images/question.png', __FILE__ );?>'></a>
			</div>
			<div class='video-blogster-block span_2_of_12'>
			<?php $optValue = strtolower( $this->get_value( $args, 'qLanguage', '' ) ); ?>
			<select class="vb-stretch" name="feed_language" id="feed_language">
<?php include( sprintf( "%stemplates/iso-639-1.php", $this->plugin['dir'] ) ); ?>
			</select>
			</div>
		</td>
	</tr>
	<tr class="vb-yt-filters-2 <?php echo $mostPopularHide;?>">
		<td>
			<div class='video-blogster-block span_3_of_12'>
			<label class='video-blogster-label' for='feed_video_license'><?php esc_html_e( 'Video License', 'video-blogster' );?></label>
<a href="#" title="YouTube lets video uploaders choose to attach either the Creative Commons license or the standard YouTube license to each of their videos."><img width='16' height='16' alt='?' src='<?php echo plugins_url( '../images/question.png', __FILE__ );?>'></a>
			</div>
			<div class='video-blogster-block span_2_of_12'>
			<?php $optValue = $this->get_value( $args, 'qLicense', '' ); ?>
			<select class="vb-stretch" name="feed_video_license" id="feed_video_license">
				<option value="any">Any</option>
				<option value="creativeCommon" <?php echo ($optValue == 'creativeCommon') ? "SELECTED" : "" ?>>creativeCommon</option>
				<option value="youtube" <?php echo ($optValue == 'youtube') ? "SELECTED" : "" ?>>youtube</option>
			</select>
			</div>
			<div class='video-blogster-block span_2_of_12'></div>
			<div class='video-blogster-block span_3_of_12'>
			<label class='video-blogster-label' for='feed_video_caption'><?php esc_html_e( 'Video Captions', 'video-blogster' );?></label>
<a href="#" title="Indicates whether the API should filter video search results based on whether they have captions."><img width='16' height='16' alt='?' src='<?php echo plugins_url( '../images/question.png', __FILE__ );?>'></a>
			</div>
			<div class='video-blogster-block span_2_of_12'>
			<?php $optValue = $this->get_value( $args, 'qCaption', '' ); ?>
			<select class="vb-stretch" name="feed_video_caption" id="feed_video_caption">
				<option value="any">Any</option>
				<option value="closedCaption" <?php echo ($optValue == 'closedCaption') ? "SELECTED" : "" ?>>closedCaption</option>
				<option value="none" <?php echo ($optValue == 'none') ? "SELECTED" : "" ?>>none</option>
			</select>
			</div>
		</td>
	</tr>
	<tr class="vb-yt-filters-2 <?php echo $mostPopularHide;?>">
		<td>
			<div class='video-blogster-block span_3_of_12'>
			<label class='video-blogster-label' for='feed_extra_params'><?php esc_html_e( 'Other Filters', 'video-blogster' );?></label>
<a target="_blank" href="https://developers.google.com/youtube/v3/docs/search/list#parameters" title="This covers any of the rarer YouTube search parameters NOT on this page. This field is added on to the end of the query URL. For instance, to restrict your query to search only live broadcasts, you would enter 'type=video&eventType=live'."><img width='16' height='16' alt='?' src='<?php echo plugins_url( '../images/question.png', __FILE__ );?>'></a>
			</div>
			<div class='video-blogster-block span_9_of_12'>
			<input class="vb-stretch" type="text" maxlength="256" name="feed_extra_params" id="feed_extra_params" value="<?php echo $this->get_value( $args, 'qExtraParams', '' ); ?>" />
			</div>
		</td>
	</tr>
	</table>
  </dd>
</dl>


<?php $optImport = array( 'category', 'tags' ); ?>
<?php include( sprintf( "%stemplates/metadata.php", $this->plugin['dir'] ) ); ?>


<dl class="vbp-accordion">
  <dt>
	<span class='video-blogster-label'><?php printf( esc_html__( '%s Image', 'video-blogster' ), $importType );?></span>
  </dt>
  <dd class='video-blogster-hidden'>
	<table class='form-table'>
	<tr>
		<td>
			<div class='video-blogster-block span_12_of_12'>
			<?php $optValue = $this->get_value( $args, 'qImageImport', '' ); ?>
			<input type="checkbox" name="feed_image_import" id="feed_image_import" value=1 <?php echo ($optValue == 1) ? "CHECKED" : "" ?>/>
			<label class='video-blogster-label' for='feed_extra_params2'><?php esc_html_e( 'Import video thumbnail as featured image, quality', 'video-blogster' );?></label>
			<?php $optValue = $this->get_value( $args, 'qExtraParams2', 'largest' ); ?>
			<select name="feed_extra_params2" id="feed_extra_params2">
				<option value="largest">largest available</option>
				<option value="maxres" <?php echo ($optValue === 'maxres') ? "SELECTED" : "" ?>>HD maxres - 1280x720</option>
				<option value="high" <?php echo ($optValue === 'high') ? "SELECTED" : "" ?>>high - 480x360</option>
				<option value="standard" <?php echo ($optValue === 'standard') ? "SELECTED" : "" ?>>HD standard - 640x480</option>
				<option value="medium" <?php echo ($optValue === 'medium') ? "SELECTED" : "" ?>>medium - 320x180</option>
				<option value="default" <?php echo ($optValue === 'default') ? "SELECTED" : "" ?>>default - 120x90</option>
			</select>
<a href="#" title="Choosing 'largest available' will look for HD images first, 1280x720 (16:9 ratio) or 640x480 (4:3 ratio), otherwise it will use the 'high' size of 480x360. Otherwise, if requesting a certain size that is not available,  a lower definition thumbnail by ratio (16:9 or 4:3) will be used instead."><img width='16' height='16' alt='?' src='<?php echo plugins_url( '../images/question.png', __FILE__ );?>'></a>
			</div>
		</td>
	</tr>
	<tr>
		<td>
<?php
    	$vbp_image_id = $this->get_value( $args, 'qImageId', 0 );
	if ( $vbp_image_id )
		$image = wp_get_attachment_image( $vbp_image_id, 'medium', false, array( 'id' => 'vbp-preview-image' ) );
	else
         	$image = "<img id='vbp-preview-image' src='' >";
?>
	<div class='video-blogster-block span_12_of_12'>
	<label class='video-blogster-label' for='vbp_media_manager'>
        <input type='hidden' name='feed_image_attachment_id' id='feed_image_attachment_id' value='<?php echo $vbp_image_id; ?>'>
	<?php esc_html_e( 'or ', 'video-blogster' );?>
        <input type="button" class="button" value="<?php _e( 'Select an image', 'video-blogster' ); ?>" id="vbp_media_manager" />
	<?php esc_html_e( ' to use as featured image for all imported videos.', 'video-blogster' );?>
	</label>

	<p>
	<?php echo ( $image ); ?>
	</p>

	</div>
		</td>
	</tr>
	</table>
  </dd>
</dl>



<dl class="vbp-accordion">
  <dt>
	<span class='video-blogster-label'><?php printf( esc_html__( '%s Comments', 'video-blogster' ), $importType );?></span>
  </dt>
  <dd class='video-blogster-hidden'>
	<table class='form-table'>
	<tr>
		<td>
			<div class='video-blogster-block span_3_of_12'>
			<label class='video-blogster-label' for='feed_num_comments'><?php esc_html_e( 'Comments to Request', 'video-blogster' );?></label>
<a href="#" title="Comments to request for each video imported. Use -1 for all comments or X-Y to randomly select a number in that range."><img width='16' height='16' alt='?' src='<?php echo plugins_url( '../images/question.png', __FILE__ );?>'></a>
			</div>
			<div class='video-blogster-block span_2_of_12'>
			<input class="vb-stretch" type="text" maxlength="8" name="feed_num_comments" id="feed_num_comments" value="<?php echo $this->get_value( $args, 'qNumComments', '', 1 ); ?>" />
			</div>
			<div class='video-blogster-block span_2_of_12'></div>
			<div class='video-blogster-block span_3_of_12'>
			<label class='video-blogster-label' for='feed_comment_orderby'><?php esc_html_e( 'Order Comments by', 'video-blogster' );?></label>
			</div>
			<div class='video-blogster-block span_2_of_12'>
			<?php $optValue = $this->get_value( $args, 'qCommentOrderBy', '' ); ?>
			<select class="vb-stretch" name="feed_comment_orderby" id="feed_comment_orderby">
				<option value="time">time</option>
				<option value="relevance" <?php echo ($optValue == 'relevance') ? "SELECTED" : "" ?>>relevance</option>
			</select>
			</div>
		</td>
	</tr>
	<tr>
		<td>
			<div class='video-blogster-block span_2_of_12'>
			<label class='video-blogster-label' for='feed_comment_search'><?php esc_html_e( 'Search Terms', 'video-blogster' );?></label>
<a href="#" title="Instructs the API to limit the API response to only contain comments that contain the specified search terms."><img width='16' height='16' alt='?' src='<?php echo plugins_url( '../images/question.png', __FILE__ );?>'></a>
			</div>
			<div class='video-blogster-block span_3_of_12'>
			<input class="vb-stretch" type="text" maxlength="256" name="feed_comment_search" id="feed_comment_search" value="<?php echo $this->get_value( $args, 'qCommentSearchTerms', '' ); ?>" />
			</div>
			<div class='video-blogster-block span_2_of_12'></div>
			<div class='video-blogster-block span_5_of_12'>
			<?php $optValue = $this->get_value( $args, 'qCommentReplies', FALSE ); ?>
			<input type="checkbox" name="feed_comment_replies" id="feed_comment_replies" value=1 <?php echo ($optValue === '1') ? "CHECKED" : "" ?>/>
			<label class='video-blogster-label' for='feed_comment_replies'><?php esc_html_e( 'Also import any replies to these comments', 'video-blogster' );?></label>
<a href="#" title="Replies are in addition to comments and so do not count against the number of comment requested."><img width='16' height='16' alt='?' src='<?php echo plugins_url( '../images/question.png', __FILE__ );?>'></a>
			</div>
		</td>
	</tr>
	</table>
  </dd>
</dl>



		</td>
	</tr>
	</table>

        </div>
        </div>
</div>
