<div class='wrap video-blogster-section'>
	<h2 class='video-blogster-title'><?php echo $this->plugin['name'] . " v" . $this->plugin['version']; ?></h2>
	<?php include( sprintf( "%stemplates/buttons.php", $this->plugin['dir'] ) ); ?>
	<p>
	<?php esc_html_e( 'Toggles the status of the Scheduler and if enabled shows the times of next scheduled triggers.', 'video-blogster' );?>
	<br>
	<?php esc_html_e( 'When the Scheduler runs it will query all of the saved Content Feeds.', 'video-blogster' );?>
	</p>
</div>
<div class='wrap video-blogster-section'>
	<h3 class='video-blogster-title'><?php echo $this->plugin['name'];?> Scheduler</h3>
	<form method="post" action="<?php echo $_SERVER["REQUEST_URI"]; ?>">
	<p/>
	<?php if ( ! empty( $running ) ) : ?>
	<div class='video-blogster-block span_3_of_12'>
                <?php esc_html_e( 'Scheduler is importing, started at:', 'video-blogster' ); ?>
	</div>
	<div class='video-blogster-block span_9_of_12'>
		<?php echo $running; ?>
	</div>
	<br /><br />
	<?php endif; ?>

	<div class='video-blogster-block span_3_of_12'>
                <?php esc_html_e( 'Current server time:', 'video-blogster' );?>
	</div>
	<div class='video-blogster-block span_9_of_12'>
		<?php echo $current_server_time; ?>
	</div>
	<br />

	<?php if (get_option( $this->plugin['prefix'] . 'sch_enabled') == TRUE) : ?>
			<div class='video-blogster-block span_3_of_12'>
       		        	<?php esc_html_e( 'Next content feeds check after:', 'video-blogster' );?>
			</div>
			<div class='video-blogster-block span_9_of_12'>
				<?php echo $next_schedule; ?>
			</div>
			<div class='video-blogster-block span_3_of_12'></div>
			<div class='video-blogster-block span_9_of_12'>
       		        	<?php esc_html_e( 'WP-Cron must run to trigger the checks.', 'video-blogster' );?>
			</div>
			<br />
		<p><input type="submit" name="disable_scheduler" value="<?php esc_html_e('Disable Scheduler', 'video-blogster' );?> &raquo;" /></p>
	<?php else : ?>
                <p><input type="submit" name="enable_scheduler" value="<?php esc_html_e('Enable Scheduler', 'video-blogster' );?> &raquo;" /></p>
	<?php endif; ?>

	<hr class='video-blogster-divider' />

        <table class='form-table'>  
	<tr>
		<td>
			<div class='video-blogster-block span_4_of_12'>
				<label class='video-blogster-label' for='video_blogster_sch_start'><?php esc_html_e( 'Once enabled, start querying content feeds in', 'video-blogster' );?></label>
			</div>
			<div class='video-blogster-block span_8_of_12'>
				<input type="text" size="4" maxsize="8" name="video_blogster_sch_start" id="video_blogster_sch_start" value="<?php echo get_option( $this->plugin['prefix'] . 'sch_start' ); ?>" />
				<?php esc_html_e( 'hours', 'video-blogster' );?>
			</div>
			<br />
			<div class='video-blogster-block span_4_of_12'>
				<label class='video-blogster-label' for='video_blogster_sch_freq'><?php esc_html_e( 'then Query the content feeds every', 'video-blogster' );?></label>
			</div>
			<div class='video-blogster-block span_8_of_12'>
				<input type="text" size="4" maxsize="8" name="video_blogster_sch_freq" id="video_blogster_sch_freq" value="<?php echo get_option( $this->plugin['prefix'] . 'sch_freq' ); ?>" />
				<?php esc_html_e( 'hours', 'video-blogster' );?>
			</div>
		</td>
	</tr>
	<tr>
		<td>
			<div class='video-blogster-block span_4_of_12'>
				<label class='video-blogster-label' for='video_blogster_email_to'><?php esc_html_e( 'Email error summary to', 'video-blogster' );?></label>
			</div>
			<div class='video-blogster-block span_8_of_12'>
				<input type="text" size="40" maxsize="256" name="video_blogster_email_to" id="video_blogster_email_to" value="<?php echo get_option( $this->plugin['prefix'] . 'email_to' ); ?>" />
			</div>
		</td>
	</tr>
	</table>

	<hr class='video-blogster-divider' />

	<p><input type="submit" name="save_scheduler" value="<?php esc_html_e('Save Scheduler Options', 'video-blogster' ); ?> &raquo;" /></p>
	</form>
</div>
