<div class='wrap video-blogster-section'>
	<h2 class='video-blogster-title'><?php echo $this->plugin['name'] . " v" . $this->plugin['version'] ; ?></h2>
	<?php include( sprintf( "%stemplates/buttons.php", $this->plugin['dir'] ) ); ?>
	<p><?php esc_html_e('Miscellaneous utility functions for', 'video-blogster' );?> <?php echo $this->plugin['name'];?> <?php esc_html_e( 'to keep the site running smooth.', 'video-blogster' );?><br /><?php esc_html_e( 'Can be triggered via Scheduler or run manually.', 'video-blogster' );?></p>
</div>
<?php $tools = get_option( $this->plugin['prefix'] . 'tools'); ?>
<div class='wrap video-blogster-section'>
	<h3 class='video-blogster-title'><?php echo $this->plugin['name'];?> Tools</h3>
<?php
	$transient = $this->get_my_plugin( 'prefix' ) . 'running_sched';
	$running = get_transient( $transient );
	if ( ! empty( $running ) ) { ?>
		<div class='video-blogster-block span_3_of_12'>
			<?php esc_html_e( 'Utility functions are running, started at:', 'video-blogster' ); ?>
		</div>
		<div class='video-blogster-block span_9_of_12'>
			<?php echo $running; ?>
		</div>
	<?php }
	$scheduledtime = wp_next_scheduled( $this->get_my_plugin('prefix') . 'Check' );
	if ( $scheduledtime ) {
		$current_server_time = date( 'Y-m-d H:i:s', current_time( "timestamp" ) ) . " " . get_option( 'timezone_string' );
	?>
        <div class='video-blogster-block span_3_of_12'>
                <?php esc_html_e( 'Current server time:', 'video-blogster' );?>
        </div>
        <div class='video-blogster-block span_9_of_12'>
                <?php echo $current_server_time; ?>
        </div>
	<?php
		$next_checker = $this->format_scheduled_time( $scheduledtime, $this->get_my_plugin( 'prefix' ) . 'sch_checker' );
                $msg = 'WP-Cron must run to trigger the checks.';
		if ( defined( 'DISABLE_WP_CRON' ) ) {
			$msg .= '<br>' . esc_html__( 'DISABLE_WP_CRON detected - Scheduler will only run from a cron job.', 'video-blogster' );
		}
	?>
		<div class='video-blogster-block span_3_of_12'>
			<?php esc_html_e( 'Next utility functions check after:', 'video-blogster' );?>
		</div>
		<div class='video-blogster-block span_9_of_12'>
			<?php echo $next_checker; ?>
		</div>
                        <div class='video-blogster-block span_3_of_12'></div>
                        <div class='video-blogster-block span_9_of_12'>
                                <?php echo $msg; ?>
                        </div>
	<?php }
?>
	<form method="post" action="<?php echo $_SERVER["REQUEST_URI"]; ?>">
        <table class='form-table'>  
	<tr>
		<th scope="row"><label class='video-blogster-label' for="tool_broken_embeds"><?php esc_html_e( 'Trash Broken Embeds', 'video-blogster' );?></label></th>
		<td>
			<select name="tool_broken_embeds" id="tool_broken_embeds">
				<option value="yes">Yes</option>
				<option value="no" <?php echo ($tools['broken_embeds'] == 'no') ? 'SELECTED' : ''?>>No</option>
			</select>
			<?php printf( 
				esc_html__('Send posts imported with Video Blogster to Trash if its embedded content has been removed from source media site. This cleans up your site instead of showing posts with broken embeds. For a full functional plugin, check out %sVideo Link Checker%s.', 'video-blogster' ), 
				'<a target="_blank" href="' . esc_url( 'https://codecanyon.net/item/video-link-checker-detect-broken-urls-from-youtube-dailymotion-soundcloud-vimeo-etc/13003626' ) . '">',
				'</a>'
			) ;?>
		</td>
	<tr>
		<th scope="row"><label class='video-blogster-label' for="tool_regenerate_thumbnails"><?php esc_html_e( 'Fetch Missing Images', 'video-blogster' );?></label></th>
		<td>
			<select name="tool_regenerate_thumbnails" id="tool_regenerate_thumbnails">
				<option value="yes">Yes</option>
				<option value="no" <?php echo ($tools['regenerate_thumbnails'] == 'no') ? 'SELECTED' : ''?>>No</option>
				<option value="twice" <?php echo ($tools['regenerate_thumbnails'] == 'twice') ? 'SELECTED' : ''?>>Twice</option>
			</select>
			<?php esc_html_e( 'If "Import featured image" is selected and the remote API fails to return an image for whatever reason, this tool lets the plugin re-request the image at the next opportunity. If "Twice" selected and unable to fetch image after 2 additional attempts, post will be sent to Trash. If "Import featured image" was NOT selected at time of import, the images are therefore NOT considered missing.', 'video-blogster' );?>
		</td>
	</tr>
	<tr>
		<th scope="row"><label class='video-blogster-label' for="tool_remove_images"><?php esc_html_e( 'Remove Trash Images', 'video-blogster' );?></label></th>
		<td>
			<select name="tool_remove_images" id="tool_remove_images">
				<option value="yes">Yes</option>
				<option value="no" <?php echo ($tools['remove_images'] == 'no') ? 'SELECTED' : ''?>>No</option>
			</select>
			<?php esc_html_e( 'Remove any images associated with Trashed/Deleted Video Blogster posts to save space. If you Trash posts created by Video Blogster because the content is spam, non-related, removed, etc., this will also delete the images too to save space (WordPress does NOT do this for you). Will ONLY apply to Trashed posts that were created by the Video Blogster engine.', 'video-blogster' );?>
		</td>
	</tr>
	</table>

	<hr class='video-blogster-divider' />

	<input type="submit" name="save_values" value="<?php esc_html_e( 'Save Settings', 'video-blogster' );?>" />
	<input type="submit" name="launch_tools" value="<?php esc_html_e( 'Run Tools Now', 'video-blogster' );?>" />
	</form>
</div>
