<?php

defined( 'ABSPATH' ) or die( "Oops! This is a WordPress plugin and should not be called directly.\n" );

/* Support for theme Avada
 * http://www.videoblogsterpro.com/get/avada/
 *
 * This theme uses the video post format with it's own custom meta fields to store the VideoEmbed.
 * This file will only be included if Avada is the active theme.
 *
 */

if ( ! function_exists( 'vb_insert_avada_changes' ) ) :

// shows changes on make video feed form:
add_action('vbp_make_feed', 'vb_insert_avada_changes', 10, 1);

function vb_insert_avada_changes( $args ) {
	$addArgs = array (
		'pPostTemplate'		=> '%VideoDescription%',
	);
	$args = array_merge( $args, $addArgs );

	$addFields = array(
		'pyre_video'         => '%VideoEmbed%',
	);
	$args['pMetaFields'] = array_merge( $args['pMetaFields'], $addFields );
	return $args;
}

// dynamic get VB meta field values if missing
//add_filter('get_post_metadata', 'vb_meta_check', 10, 4);
function vb_meta_check( $metadata, $postID, $meta_key, $single ) {
	global $wpdb;
	$metadata = $wpdb->get_var( "SELECT meta_value FROM $wpdb->postmeta WHERE post_id = {$postID} AND meta_key = '{$meta_key}'" );
	if ( $metadata != null ) return null;
	if ( $meta_key == 'pyre_video' ) 	return get_post_meta( $postID, 'VideoEmbed', $single );
	return null;
}

// dynamic VB remove any iframe from content - theme uses meta field instead
//add_filter('the_content', 'vb_content_check' );
function vb_content_check( $content ) {
	$content = preg_replace('/<iframe.*?\/iframe>/i','', $content);
	return $content;
}

endif;
?>
