<?php

defined( 'ABSPATH' ) or die( "Oops! This is a WordPress plugin and should not be called directly.\n" );

/* Support for theme Enfold
 * http://www.videoblogsterpro.com/get/enfold/
 *
 * This theme uses the video post format with it's own custom meta fields to store the VideoEmbed.
 * This file will only be included if Enfold is the active theme.
 *
 */

if ( ! function_exists( 'vb_insert_enfold_changes' ) ) :

// shows changes on make video feed form:
add_action('vbp_make_feed', 'vb_insert_enfold_changes', 10, 1);

function vb_insert_enfold_changes( $args ) {
	$addArgs = array (
		'pPostTemplate'		=> '[av_video src="%VideoUrl%" format="16-9" width="16" height="9"]<p>%VideoDescription%</p>'
	);
	$args = array_merge( $args, $addArgs );

	$args['cPostFormat'] = 'video';
	return $args;
}

// dynamic VB remove any iframe from content - theme uses meta field instead
//add_filter('the_content', 'vb_content_check' );
function vb_content_check( $content ) {
	$content = preg_replace('/<iframe.*?\/iframe>/i','', $content);
	return $content;
}


// dynamic VB ensure post format for new posts is 'video'
//add_filter('vb_create_the_post_finished', 'vb_format_check', 10, 2 );
function vb_format_check( $postID, $videoInfo ) {
	set_post_format( $postID, 'video' );
	return null;
}

endif;
?>
