<?php

defined( 'ABSPATH' ) or die( "Oops! This is a WordPress plugin and should not be called directly.\n" );

/* Support for theme EVS theme
 * https://www.evs_theme.com/
 *
 * This theme uses the video post format with it's own custom meta fields.
 * This function hook will set the video post format, add those fields to Video Blogster feed form.
 * This file will only be included if EVS theme is the active theme.
 *
 */

if ( ! function_exists( 'vb_insert_evs_theme_changes' ) ) :

// shows changes on make video feed form:
add_action('vbp_make_feed', 'vb_insert_evs_theme_changes', 10, 1);

function vb_insert_evs_theme_changes( $args ) {
	$addArgs = array (
		'pPostTemplate'		=> '%VideoDescription%',
	);
	$args = array_merge( $args, $addArgs );
	$addFields = array(
		'embed'			=> '%VideoEmbed%',
		'likes_count'		=> '%VideoLikes%',
		'dislikes_count'	=> '%VideoDislikes%',
	);
	$args['pMetaFields'] = array_merge( $args['pMetaFields'], $addFields );

	$args['cPostFormat'] = 'video';
	return $args;
}

// EVS uses seconds for duration then converts
add_action('added_post_meta', 'vb_video_duration_convert', 10, 4);
function vb_video_duration_convert( $meta_id, $post_id, $meta_key, $meta_value ) {
        if ( 'VideoDuration' == $meta_key ) {
                sscanf($meta_value, "%d:%d:%d", $hours, $minutes, $seconds);
                $secs = isset($seconds) ? $hours * 3600 + $minutes * 60 + $seconds : $hours * 60 + $minutes;
                add_post_meta( $post_id, 'duration', $secs );
        }
}

// dynamic VB ensure post format for new posts is 'video'
add_filter('vb_create_the_post_finished', 'vb_format_check', 10, 2 );
function vb_format_check( $postID, $videoInfo ) {
	set_post_format( $postID, 'video' );
	return null;
}

endif;
?>
