<?php

defined( 'ABSPATH' ) or die( "Oops! This is a WordPress plugin and should not be called directly.\n" );

/* Support for theme Gowatch
 *
 * This theme uses the video post format with it's own custom meta fields to store the VideoEmbed and VideoDuration.
 * This function hook will set the video post format, add those fields to Video Blogster feed form and reset the description.
 * This file will only be included if Gowatch is the active theme.
 *
 */

if ( ! function_exists( 'vb_insert_gowatch_changes' ) ) :

// shows changes on make video feed form:
add_action('vbp_make_feed', 'vb_insert_gowatch_changes', 10, 1);

function vb_insert_gowatch_changes( $args ) {
	$addArgs = array (
		'pPostTemplate'		=> '%VideoDescription%',
	);
	$args = array_merge( $args, $addArgs );

	$addFields = array(
		'video_embed'		=> '%VideoEmbed%',
		'airkit_likes'		=> '%VideoLikes%',
		'airkit_views'		=> '%VideoViews%',
	);
	$args['pMetaFields'] = array_merge( $args['pMetaFields'], $addFields );

	$args['cPostFormat'] = 'video';
	return $args;
}

endif;
?>
