<?php

defined( 'ABSPATH' ) or die( "Oops! This is a WordPress plugin and should not be called directly.\n" );

/* Support for theme Nova Video
 * https://www.themabiz.com/shop/wp-themes/novavideo-wordpress-video-theme/
 *
 * This theme uses the video post format with it's own custom meta fields to store the VideoImage, VideoEmbed, Likes and Dislikes.
 * This function hook will set the video post format, add those fields to Video Blogster feed form and reset the description.
 * This file will only be included if Nova Video Mag is the active theme.
 *
 */

if ( ! function_exists( 'vb_insert_novavideo_changes' ) ) :

// shows changes on make video feed form:
add_action('vbp_make_feed', 'vb_insert_novavideo_changes', 10, 1);

function vb_insert_novavideo_changes( $args ) {
	$addArgs = array (
		'pPostTemplate'		=> '%VideoDescription%',
	);
	$args = array_merge( $args, $addArgs );

	$addFields = array(
		'url_thumb'          	=> '%VideoImage%',
		'code'         		=> '%VideoEmbed%',
		'likes_count'         	=> '%VideoLikes%',
		'dislikes_count'       	=> '%VideoDisLikes%',
		'post_views_count'	=> '%VideoViews%',
	);
	$args['pMetaFields'] = array_merge( $args['pMetaFields'], $addFields );

	$args['cPostFormat'] = 'video';
	return $args;
}


// NovaVideo uses seconds for duration then converts
add_action('added_post_meta', 'vb_video_duration_convert', 10, 4);
function vb_video_duration_convert( $meta_id, $post_id, $meta_key, $meta_value ) {
        if ( 'VideoDuration' == $meta_key ) {
                sscanf($meta_value, "%d:%d:%d", $hours, $minutes, $seconds);
                $secs = isset($seconds) ? $hours * 3600 + $minutes * 60 + $seconds : $hours * 60 + $minutes;
                add_post_meta( $post_id, 'duration', $secs );
        }
}

endif;
?>
