<?php

defined( 'ABSPATH' ) or die( "Oops! This is a WordPress plugin and should not be called directly.\n" );

/* Support for theme Reel
 * http://www.wpzoom.com/themes/reel
 *
 * This example uses the portfolio post format with it's own custom meta fields to store the VideoUrl.
 * This function hook will set the video post format, add those fields to Video Blogster feed form and reset the description.
 * This file will only be included if Reel is the active theme.
 *
 */

if ( ! function_exists( 'vb_insert_reel_changes' ) ) :

// shows changes on make video feed form:
add_action('vbp_make_feed', 'vb_insert_reel_changes', 10, 1);

function vb_insert_reel_changes( $args ) {
	$addArgs = array (
		'pPostTemplate'		=> '%VideoDescription%',
	);
	$args = array_merge( $args, $addArgs );

	$addFields = array(

		// this field for importing YouTube:
		'wpzoom_portfolio_single_post_video_external_url'		=> '%VideoUrl%',

		// this field for importing Vimeo:
		// 'wpzoom_portfolio_single_post_video_vimeo_pro'		=> '%VideoUrl%',

	);
	$args['pMetaFields'] = array_merge( $args['pMetaFields'], $addFields );

	$args['cPostType'] = 'portfolio_item';
	$args['cPostFormat'] = 'video';

	return $args;
}


endif;
?>
