<?php

defined( 'ABSPATH' ) or die( "Oops! This is a WordPress plugin and should not be called directly.\n" );

/* Support for theme WP Script Tube
 * 
 *
 * This theme uses it's own custom meta fields to store video information.
 * This file will only be included if WP Script Theme is the active theme.
 *
 */

if ( ! function_exists( 'vb_insert_retrotubechanges' ) ) :

// shows changes on make video feed form:
add_action('vbp_make_feed', 'vb_insert_retrotubechanges', 10, 1);

function vb_insert_retrotubechanges( $args ) {
	$addArgs = array (
		'pPostTemplate'		=> '%VideoDescription%',
	);
	$args = array_merge( $args, $addArgs );

	$addFields = array(
		'featured_video'	=> 'false',
		'hd_video'		=> 'false',
		'video_url'		=> '%VideoUrl%',
		'post_views_count'      => '%VideoViews%',
		'likes_count'		=> '%VideoLikes%',
		'dislikes_count'	=> '%VideoDislikes%',
	);
	$args['pMetaFields'] = array_merge( $args['pMetaFields'], $addFields );

	$args['cPostFormat'] = 'video';

	return $args;
}


// WP Script Theme uses seconds for duration then converts
add_action('added_post_meta', 'vb_video_duration_convert', 10, 4);
add_action('updated_post_meta', 'vb_video_duration_convert', 10, 4);
function vb_video_duration_convert( $meta_id, $post_id, $meta_key, $meta_value ) {
        if ( 'VideoDuration' == $meta_key ) {
                sscanf($meta_value, "%d:%d:%d", $hours, $minutes, $seconds);
                $secs = isset($seconds) ? $hours * 3600 + $minutes * 60 + $seconds : $hours * 60 + $minutes;
                add_post_meta( $post_id, 'duration', $secs );
        }
}

endif;
?>
